/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;
import org.spin.wms.process.GenerateInvoiceInOutBoundAbstract;

public class GenerateInvoiceInOutBound
extends GenerateInvoiceInOutBoundAbstract {
    private Hashtable<Integer, MInvoice> invoices;
    private int created = 0;
    private StringBuffer generatedDocuments = new StringBuffer();

    @Override
    protected String doIt() throws Exception {
        this.invoices = new Hashtable();
        List<Object> list = null;
        if (this.getRecord_ID() > 0) {
            list = new Query(this.getCtx(), "WM_InOutBoundLine", "WM_InOutBound_ID=?", this.get_TrxName()).setParameters(this.getRecord_ID()).setOrderBy("C_Order_ID, DD_Order_ID").list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
            list = this.getInstancesForSelection(this.get_TrxName());
        }
        if (list != null) {
            list.stream().filter(mWMInOutBoundLine -> mWMInOutBoundLine.getC_Invoice_ID() <= 0).forEach(mWMInOutBoundLine -> this.createInvoice((MWMInOutBoundLine)mWMInOutBoundLine));
        }
        this.processingInvoices();
        return "@Created@ " + this.created + (String)(this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createInvoice(MWMInOutBoundLine mWMInOutBoundLine) {
        if (mWMInOutBoundLine.getC_OrderLine_ID() > 0) {
            MOrderLine mOrderLine = mWMInOutBoundLine.getOrderLine();
            if (mOrderLine.getQtyOrdered().subtract(mOrderLine.getQtyInvoiced()).subtract(mWMInOutBoundLine.getPickedQty()).signum() < 0 && !this.getParameterAsBoolean("IsIncludeNotAvailable")) {
                return;
            }
            BigDecimal bigDecimal = mWMInOutBoundLine.getPickedQty();
            MInvoice mInvoice = this.getInvoice(mOrderLine, mWMInOutBoundLine.getParent());
            MInvoiceLine mInvoiceLine = new MInvoiceLine(mWMInOutBoundLine.getCtx(), 0, mWMInOutBoundLine.get_TrxName());
            mInvoiceLine.setOrderLine(mOrderLine);
            if (mWMInOutBoundLine.getM_InOutLine_ID() > 0) {
                mInvoiceLine.setM_InOutLine_ID(mWMInOutBoundLine.getM_InOutLine_ID());
            }
            mInvoiceLine.setC_Invoice_ID(mInvoice.get_ID());
            mInvoiceLine.setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
            mInvoiceLine.setPrice(MUOMConversion.convertProductTo(this.getCtx(), mWMInOutBoundLine.getM_Product_ID(), mWMInOutBoundLine.getC_UOM_ID(), mOrderLine.getPriceActual()));
            mInvoiceLine.setQtyEntered(bigDecimal);
            mInvoiceLine.setQtyInvoiced(bigDecimal);
            mInvoiceLine.setWM_InOutBoundLine_ID(mWMInOutBoundLine.get_ID());
            mInvoiceLine.saveEx();
        }
    }

    private MInvoice getInvoice(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound) {
        MInvoice mInvoice;
        int n = mOrderLine.getC_Order_ID();
        if (this.isConsolidateDocument()) {
            n = mOrderLine.getC_BPartner_ID();
        }
        if ((mInvoice = this.invoices.get(n)) != null) {
            return mInvoice;
        }
        MOrder mOrder = mOrderLine.getParent();
        mInvoice = new MInvoice(mOrder, 0, this.getDateInvoiced());
        if (this.getDocTypeTargetId() > 0) {
            mInvoice.setC_DocType_ID(this.getDocTypeTargetId());
        }
        mInvoice.setIsSOTrx(true);
        mInvoice.saveEx();
        this.invoices.put(n, mInvoice);
        return mInvoice;
    }

    private void addToMessage(String string) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(string);
    }

    private void processingInvoices() {
        if (this.invoices == null) {
            return;
        }
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MInvoice mInvoice = (MInvoice)entry.getValue();
            mInvoice.setDocAction(this.getDocAction());
            if (!mInvoice.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + mInvoice.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + mInvoice.getDocumentInfo());
            }
            mInvoice.saveEx();
            ++this.created;
            this.addToMessage(mInvoice.getDocumentNo());
        });
        ArrayList<PO> arrayList = new ArrayList<PO>();
        this.invoices.entrySet().stream().filter(entry -> entry != null).forEach(entry -> arrayList.add((PO)entry.getValue()));
        this.printDocument(arrayList, true);
    }
}

