/*
 * Decompiled with CFR 0.152.
 */
package org.spin.wms.form;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefList;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;

public class OutBoundOrder {
    public static CLogger log = CLogger.getCLogger(OutBoundOrder.class);
    public final int SELECT = 0;
    public final int ORDER = 2;
    public final int OL_WAREHOUSE = 1;
    public final int ORDER_LINE = 2;
    public final int OL_PRODUCT = 3;
    public final int OL_UOM = 4;
    public final int OL_QTY_ON_HAND = 5;
    public final int OL_QTY = 6;
    public final int OL_WEIGHT = 7;
    public final int OL_VOLUME = 8;
    public final int OL_SEQNO = 9;
    public final int OL_QTY_ORDERED = 10;
    public final int OL_UOM_CONVERSION = 11;
    public final int OL_QTY_RESERVERD = 12;
    public final int OL_QTY_INVOICED = 13;
    public final int OL_QTY_DELIVERED = 14;
    public final int OL_QTY_IN_TRANSIT = 15;
    public final int OL_DELIVERY_RULE = 16;
    public final int SW_PRODUCT = 0;
    public final int SW_UOM = 1;
    public final int SW_WAREHOUSE = 2;
    public final int SW_QTY_ON_HAND = 3;
    public final int SW_QTY_IN_TRANSIT = 4;
    public final int SW_QTY_SET = 5;
    public final int SW_QTY_AVAILABLE = 6;
    public Vector<BufferTableSelect> m_BufferSelect = null;
    public StringBuffer m_Symmary = new StringBuffer();
    public StringBuffer m_QueryAdd = new StringBuffer();
    protected int clientId = 0;
    protected int orgId = 0;
    protected int salesRegionId = 0;
    protected int salesRepId = 0;
    protected int warehouseId = 0;
    protected String movementType = null;
    protected String documentAction = null;
    protected int docTypeId = 0;
    protected int docTypeTargetId = 0;
    protected String deliveryRule = null;
    protected String deliveryViaRule = null;
    protected Timestamp documentDate = null;
    protected Timestamp shipmentDate = null;
    protected int shipperId = 0;
    protected BigDecimal payloadCapacity = Env.ZERO;
    protected BigDecimal volumeCapacity = Env.ZERO;
    protected int uOMWeightId = 0;
    protected int uOMVolumeId = 0;
    protected int weightPrecision = 0;
    protected int volumePrecision = 0;
    protected int rowsSelected = 0;
    protected String uOMWeightSymbol = null;
    protected String uOMVolumeSymbol = null;
    protected BigDecimal totalWeight = Env.ZERO;
    protected BigDecimal totalVolume = Env.ZERO;
    protected int maxSeqNo = 0;
    protected MWMInOutBound outBoundOrder = null;
    protected Integer locatorId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Vector<Object>> getOrderData(IMiniTable iMiniTable) {
        ResultSet resultSet = null;
        CPreparedStatement cPreparedStatement = null;
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        StringBuffer stringBuffer = null;
        if (this.movementType.equals("DD_Order")) {
            stringBuffer = new StringBuffer("SELECT wr.Name Warehouse, ord.DD_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, reg.Name, cit.Name, sr.Name SalesRep, cp.Name Partner, bploc.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID, ord.Weight, ord.Volume FROM DD_Order ord INNER JOIN DD_OrderLine lord ON(lord.DD_Order_ID = ord.DD_Order_ID) INNER JOIN M_Product pr ON(pr.M_Product_ID = lord.M_Product_ID) INNER JOIN C_BPartner cp ON(cp.C_BPartner_ID = ord.C_BPartner_ID) INNER JOIN AD_User sr ON(sr.AD_User_ID = ord.SalesRep_ID) INNER JOIN M_Locator wloc ON(wloc.M_Locator_ID = lord.M_Locator_ID) INNER JOIN M_Warehouse wr ON(wr.M_Warehouse_ID = wloc.M_Warehouse_ID) INNER JOIN C_BPartner_Location bploc ON(bploc.C_BPartner_Location_ID = ord.C_BPartner_Location_ID) INNER JOIN C_Location loc ON(loc.C_Location_ID = bploc.C_Location_ID) LEFT JOIN C_Region reg ON(reg.C_Region_ID = loc.C_Region_ID) LEFT JOIN C_City cit ON(cit.C_City_ID = loc.C_City_ID) LEFT JOIN (SELECT lord.DD_OrderLine_ID, \t(COALESCE(lord.QtyOrdered, 0) - \t\tSUM(\t\t\t\tCASE WHEN (c.IsDelivered = 'N' AND lc.DD_Order_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\tTHEN COALESCE(lc.MovementQty, 0) \t\t\t\t\t\tELSE 0 \t\t\t\tEND\t\t\t)\t) QtyAvailable \tFROM DD_OrderLine lord \tLEFT JOIN WM_InOutBoundLine lc ON(lc.DD_OrderLine_ID = lord.DD_OrderLine_ID) \tLEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) \tWHERE lord.M_Product_ID IS NOT NULL \tGROUP BY lord.DD_Order_ID, lord.DD_OrderLine_ID, lord.QtyOrdered \tORDER BY lord.DD_OrderLine_ID ASC) qafl \tON(qafl.DD_OrderLine_ID = lord.DD_OrderLine_ID) WHERE  wr.IsActive = 'Y' AND ord.DocStatus = 'CO' AND COALESCE(qafl.QtyAvailable, 0) > 0 AND ord.AD_Client_ID=? ");
            if (this.orgId > 0) {
                stringBuffer.append("AND lord.AD_Org_ID=? ");
            }
            if (this.warehouseId > 0) {
                stringBuffer.append("AND wr.M_Warehouse_ID=? ");
            }
            if (this.salesRegionId > 0) {
                stringBuffer.append("AND bploc.C_SalesRegion_ID=? ");
            }
            if (this.salesRepId > 0) {
                stringBuffer.append("AND ord.SalesRep_ID=? ");
            }
            if (this.docTypeId > 0) {
                stringBuffer.append("AND ord.C_DocType_ID=? ");
            }
            stringBuffer.append("GROUP BY wr.Name, ord.DD_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, ord.Weight, ord.Volume, sr.Name, cp.Name, bploc.Name, reg.Name, cit.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID ");
            stringBuffer.append("HAVING (SUM(COALESCE(lord.QtyOrdered, 0)) - SUM(COALESCE(lord.QtyInTransit, 0)) - SUM(COALESCE(lord.QtyDelivered, 0))) > 0 ");
            stringBuffer.append("ORDER BY ord.DD_Order_ID ASC");
        } else {
            stringBuffer = new StringBuffer("SELECT wr.Name Warehouse, ord.C_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, reg.Name, cit.Name, sr.Name SalesRep, cp.Name Partner, bploc.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID, ord.Weight, ord.Volume FROM C_Order ord INNER JOIN C_OrderLine lord ON(lord.C_Order_ID = ord.C_Order_ID) INNER JOIN M_Product pr ON(pr.M_Product_ID = lord.M_Product_ID) INNER JOIN C_BPartner cp ON(cp.C_BPartner_ID = ord.C_BPartner_ID) INNER JOIN M_Warehouse wr ON(wr.M_Warehouse_ID = ord.M_Warehouse_ID) INNER JOIN C_BPartner_Location bploc ON(bploc.C_BPartner_Location_ID = ord.C_BPartner_Location_ID) INNER JOIN C_Location loc ON(loc.C_Location_ID = bploc.C_Location_ID) LEFT JOIN AD_User sr ON(sr.AD_User_ID = ord.SalesRep_ID) LEFT JOIN C_Region reg ON(reg.C_Region_ID = loc.C_Region_ID) LEFT JOIN C_City cit ON(cit.C_City_ID = loc.C_City_ID) LEFT JOIN (SELECT lord.C_OrderLine_ID, \t(COALESCE(lord.QtyOrdered, 0) - \t\tSUM(\t\t\t\tCASE WHEN (c.IsDelivered = 'N' AND lc.C_Order_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\tTHEN COALESCE(lc.MovementQty, 0) \t\t\t\t\t\tELSE 0 \t\t\t\tEND\t\t\t)\t) QtyAvailable \tFROM C_OrderLine lord \tLEFT JOIN WM_InOutBoundLine lc ON(lc.C_OrderLine_ID = lord.C_OrderLine_ID) \tLEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) \tWHERE lord.M_Product_ID IS NOT NULL \tGROUP BY lord.C_Order_ID, lord.C_OrderLine_ID, lord.QtyOrdered \tORDER BY lord.C_OrderLine_ID ASC) qafl \tON(qafl.C_OrderLine_ID = lord.C_OrderLine_ID) WHERE ord.IsSOTrx = 'Y' AND wr.IsActive = 'Y' AND ord.DocStatus = 'CO' AND COALESCE(qafl.QtyAvailable, 0) > 0 AND ord.AD_Client_ID=? ");
            if (this.orgId > 0) {
                stringBuffer.append("AND lord.AD_Org_ID=? ");
            }
            if (this.warehouseId > 0) {
                stringBuffer.append("AND lord.M_Warehouse_ID=? ");
            }
            if (this.salesRegionId > 0) {
                stringBuffer.append("AND bploc.C_SalesRegion_ID=? ");
            }
            if (this.salesRepId > 0) {
                stringBuffer.append("AND ord.SalesRep_ID=? ");
            }
            if (this.docTypeId > 0) {
                stringBuffer.append("AND ord.C_DocType_ID=? ");
            }
            stringBuffer.append("GROUP BY wr.Name, ord.C_Order_ID, ord.DocumentNo, ord.DateOrdered, ord.DatePromised, ord.Weight, ord.Volume, sr.Name, cp.Name, bploc.Name, reg.Name, cit.Name, loc.Address1, loc.Address2, loc.Address3, loc.Address4, ord.C_BPartner_Location_ID ");
            stringBuffer.append("HAVING (SUM(COALESCE(lord.QtyOrdered, 0)) - SUM(COALESCE(lord.QtyDelivered, 0))) > 0 ");
            stringBuffer.append("ORDER BY ord.C_Order_ID ASC");
        }
        log.fine("LoadOrderSQL=" + stringBuffer.toString());
        try {
            int n = 1;
            int n2 = 1;
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            cPreparedStatement.setInt(n++, Env.getAD_Client_ID(Env.getCtx()));
            if (this.orgId > 0) {
                cPreparedStatement.setInt(n++, this.orgId);
            }
            if (this.warehouseId > 0) {
                cPreparedStatement.setInt(n++, this.warehouseId);
            }
            if (this.salesRegionId > 0) {
                cPreparedStatement.setInt(n++, this.salesRegionId);
            }
            if (this.salesRepId > 0) {
                cPreparedStatement.setInt(n++, this.salesRepId);
            }
            if (this.docTypeId > 0) {
                cPreparedStatement.setInt(n++, this.docTypeId);
            }
            log.fine("AD_Org_ID=" + this.orgId);
            log.fine("M_Warehouse_ID=" + this.warehouseId);
            log.fine("SalesRep_ID=" + this.salesRepId);
            log.fine("C_DocType_ID=" + this.docTypeId);
            resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = 1;
                Vector<Object> vector2 = new Vector<Object>();
                vector2.add(Boolean.FALSE);
                vector2.add(resultSet.getString(n2++));
                KeyNamePair keyNamePair = new KeyNamePair(resultSet.getInt(n2++), resultSet.getString(n2++));
                vector2.add(keyNamePair);
                vector2.add(resultSet.getTimestamp(n2++));
                vector2.add(resultSet.getTimestamp(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getString(n2++));
                vector2.add(resultSet.getBigDecimal(n2++));
                vector2.add(resultSet.getBigDecimal(n2++));
                vector.add(vector2);
            }
        }
        catch (SQLException sQLException) {
            try {
                log.log(Level.SEVERE, stringBuffer.toString(), sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
        }
        DB.close(resultSet, cPreparedStatement);
        return vector;
    }

    protected StringBuffer getQueryLine(IMiniTable iMiniTable) {
        StringBuffer stringBuffer = null;
        log.config("getQueryLine");
        if (this.movementType.equals("DD_Order")) {
            int n = iMiniTable.getRowCount();
            this.rowsSelected = 0;
            StringBuffer stringBuffer2 = new StringBuffer("ord.DD_Order_ID IN(0");
            for (int i = 0; i < n; ++i) {
                if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue()) continue;
                int n2 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getKey();
                stringBuffer2.append(",");
                stringBuffer2.append(n2);
                ++this.rowsSelected;
            }
            stringBuffer2.append(")");
            stringBuffer = new StringBuffer("SELECT alm.M_Warehouse_ID, alm.Name Warehouse, lord.DD_OrderLine_ID OrderLine_ID, ord.DocumentNo, lord.M_Product_ID, (pro.Name || COALESCE(' - ' || productattribute(lord.M_AttributeSetInstance_ID), '')) Product, pro.C_UOM_ID, uomp.UOMSymbol, s.QtyOnHand, lord.QtyOrdered, lord.C_UOM_ID Order_UOM_ID, uom.UOMSymbol Order_UOMSymbol, lord.QtyReserved, 0 QtyInvoiced, lord.QtyDelivered, SUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty \t\t\tELSE 0 \t\tEND, 0)) QtyLoc, (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyInTransit, 0) - COALESCE(lord.QtyDelivered, 0) - \tSUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty \t\t\tELSE 0 \t\tEND, 0)\t\t)) Qty, pro.Weight, pro.Volume, ord.DeliveryRule, pro.IsStocked FROM DD_Order ord INNER JOIN DD_OrderLine lord ON(lord.DD_Order_ID = ord.DD_Order_ID) INNER JOIN M_Locator l ON(l.M_Locator_ID = lord.M_Locator_ID) INNER JOIN M_Warehouse alm ON(alm.M_Warehouse_ID = l.M_Warehouse_ID) INNER JOIN M_Product pro ON(pro.M_Product_ID = lord.M_Product_ID) INNER JOIN C_UOM uom ON(uom.C_UOM_ID = lord.C_UOM_ID) INNER JOIN C_UOM uomp ON(uomp.C_UOM_ID = pro.C_UOM_ID) LEFT JOIN WM_InOutBoundLine lc ON(lc.DD_OrderLine_ID = lord.DD_OrderLine_ID) LEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) LEFT JOIN (\t\t\t\tSELECT l.M_Warehouse_ID, st.M_Product_ID, \t\t\t\t\tCOALESCE(SUM(st.QtyOnHand), 0) QtyOnHand, \t\t\t\t\t(CASE WHEN p.M_AttributeSet_ID IS NOT NULL THEN COALESCE(st.M_AttributeSetInstance_ID, 0) ELSE 0 END) M_AttributeSetInstance_ID \t\t\t\tFROM M_Storage st \t\t\t\tINNER JOIN M_Product p ON(p.M_Product_ID = st.M_Product_ID) \t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = st.M_Locator_ID) \t\t\tGROUP BY l.M_Warehouse_ID, st.M_Product_ID, p.M_AttributeSet_ID, 4) s \t\t\t\t\t\t\t\t\t\t\t\t\t\tON(s.M_Product_ID = lord.M_Product_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND s.M_Warehouse_ID = l.M_Warehouse_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND lord.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID) ").append("WHERE ").append(stringBuffer2).append(" ");
            stringBuffer.append("GROUP BY alm.M_Warehouse_ID, lord.DD_Order_ID, lord.DD_OrderLine_ID, alm.Name, ord.DocumentNo, lord.M_Product_ID, lord.M_AttributeSetInstance_ID, pro.Name, lord.C_UOM_ID, uom.UOMSymbol, lord.QtyEntered, pro.C_UOM_ID, uomp.UOMSymbol, lord.QtyOrdered, lord.QtyReserved, lord.QtyDelivered, pro.Weight, pro.Volume, ord.DeliveryRule, s.QtyOnHand,pro.IsStocked").append(" ");
            stringBuffer.append("HAVING (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyInTransit, 0) - COALESCE(lord.QtyDelivered, 0) - \t\t\t\t\t\t\t\tSUM(\t\t\t\t\t\t\t\t\tCOALESCE(CASE \t\t\t\t\t\t\t\t\t\tWHEN (c.IsDelivered = 'N' AND lc.DD_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\t\t\t\t\t\tTHEN lc.MovementQty \t\t\t\t\t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\t\t\t\tEND, 0)\t\t\t\t\t\t\t\t)\t\t\t) > 0 OR pro.IsStocked = 'N' ").append(" ");
            stringBuffer.append("ORDER BY lord.DD_Order_ID ASC");
        } else {
            int n = iMiniTable.getRowCount();
            this.rowsSelected = 0;
            StringBuffer stringBuffer3 = new StringBuffer("ord.C_Order_ID IN(0");
            for (int i = 0; i < n; ++i) {
                if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue()) continue;
                int n3 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getKey();
                stringBuffer3.append(",");
                stringBuffer3.append(n3);
                ++this.rowsSelected;
            }
            stringBuffer3.append(")");
            stringBuffer = new StringBuffer("SELECT lord.M_Warehouse_ID, alm.Name Warehouse, lord.C_OrderLine_ID OrderLine_ID, ord.DocumentNo, lord.M_Product_ID, (pro.Name || COALESCE(' - ' || productattribute(lord.M_AttributeSetInstance_ID), '')) Product, pro.C_UOM_ID, uomp.UOMSymbol, s.QtyOnHand, lord.QtyOrdered, lord.C_UOM_ID Order_UOM_ID, uom.UOMSymbol Order_UOMSymbol, lord.QtyReserved, lord.QtyInvoiced, lord.QtyDelivered, SUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\tELSE 0 \t\tEND, 0)) QtyLoc, (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyDelivered, 0) - \tSUM(\t\tCOALESCE(CASE \t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\tELSE 0 \t\tEND, 0)\t\t)) Qty, pro.Weight, pro.Volume, ord.DeliveryRule, pro.IsStocked FROM C_Order ord INNER JOIN C_OrderLine lord ON(lord.C_Order_ID = ord.C_Order_ID) INNER JOIN M_Warehouse alm ON(alm.M_Warehouse_ID = lord.M_Warehouse_ID) INNER JOIN M_Product pro ON(pro.M_Product_ID = lord.M_Product_ID) INNER JOIN C_UOM uom ON(uom.C_UOM_ID = lord.C_UOM_ID) INNER JOIN C_UOM uomp ON(uomp.C_UOM_ID = pro.C_UOM_ID) LEFT JOIN WM_InOutBoundLine lc ON(lc.C_OrderLine_ID = lord.C_OrderLine_ID) LEFT JOIN WM_InOutBound c ON(c.WM_InOutBound_ID = lc.WM_InOutBound_ID) LEFT JOIN (SELECT iol.WM_InOutBoundLine_ID, SUM(iol.MovementQty) MovementQty \t\t\t\t\t\tFROM M_InOut io \t\t\t\t\t\tINNER JOIN M_InOutLine iol ON(iol.M_InOut_ID = io.M_InOut_ID) \t\t\t\t\t\tWHERE io.DocStatus IN('CO', 'CL') \t\t\t\t\t\tAND iol.WM_InOutBoundLine_ID IS NOT NULL\t\t\t\tGROUP BY iol.WM_InOutBoundLine_ID) iol ON(iol.WM_InOutBoundLine_ID = lc.WM_InOutBoundLine_ID) LEFT JOIN (\t\t\t\tSELECT l.M_Warehouse_ID, st.M_Product_ID, \t\t\t\t\tCOALESCE(SUM(st.QtyOnHand), 0) QtyOnHand, \t\t\t\t\t(CASE WHEN p.M_AttributeSet_ID IS NOT NULL THEN COALESCE(st.M_AttributeSetInstance_ID, 0) ELSE 0 END) M_AttributeSetInstance_ID \t\t\t\tFROM M_Storage st \t\t\t\tINNER JOIN M_Product p ON(p.M_Product_ID = st.M_Product_ID) \t\t\t\tINNER JOIN M_Locator l ON(l.M_Locator_ID = st.M_Locator_ID) \t\t\tGROUP BY l.M_Warehouse_ID, st.M_Product_ID, p.M_AttributeSet_ID, 4) s \t\t\t\t\t\t\t\t\t\t\t\t\t\tON(s.M_Product_ID = lord.M_Product_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND s.M_Warehouse_ID = lord.M_Warehouse_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAND lord.M_AttributeSetInstance_ID = s.M_AttributeSetInstance_ID) ").append("WHERE ").append(stringBuffer3).append(" ");
            stringBuffer.append("GROUP BY lord.M_Warehouse_ID, lord.C_Order_ID, lord.C_OrderLine_ID, alm.Name, ord.DocumentNo, lord.M_Product_ID, lord.M_AttributeSetInstance_ID, pro.Name, lord.C_UOM_ID, uom.UOMSymbol, lord.QtyEntered, pro.C_UOM_ID, uomp.UOMSymbol, lord.QtyOrdered, lord.QtyReserved, lord.QtyDelivered, lord.QtyInvoiced, pro.Weight, pro.Volume, ord.DeliveryRule, s.QtyOnHand, pro.IsStocked").append(" ");
            stringBuffer.append("HAVING (COALESCE(lord.QtyOrdered, 0) - COALESCE(lord.QtyDelivered, 0) - \t\t\t\t\t\t\t\t\tSUM(\t\t\t\t\t\t\t\t\t\tCOALESCE(CASE \t\t\t\t\t\t\t\t\t\t\tWHEN (c.IsDelivered = 'N' AND lc.C_OrderLine_ID IS NOT NULL AND c.DocStatus = 'CO') \t\t\t\t\t\t\t\t\t\t\tTHEN lc.MovementQty - COALESCE(iol.MovementQty, 0) \t\t\t\t\t\t\t\t\t\t\tELSE 0 \t\t\t\t\t\t\t\t\t\tEND, 0)\t\t\t\t\t\t\t\t\t)\t\t\t) > 0  OR pro.IsStocked = 'N' ").append(" ");
            stringBuffer.append("ORDER BY lord.C_Order_ID ASC");
        }
        log.fine("SQL Line Order=" + stringBuffer.toString());
        return stringBuffer;
    }

    protected Vector<String> getOrderColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(Msg.translate(Env.getCtx(), "Select"));
        vector.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        vector.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        vector.add(Msg.translate(Env.getCtx(), "DateOrdered"));
        vector.add(Msg.translate(Env.getCtx(), "DatePromised"));
        vector.add(Msg.translate(Env.getCtx(), "C_Region_ID"));
        vector.add(Msg.translate(Env.getCtx(), "C_City_ID"));
        vector.add(Msg.translate(Env.getCtx(), "SalesRep_ID"));
        vector.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        vector.add(Msg.translate(Env.getCtx(), "C_Location_ID"));
        vector.add(Msg.translate(Env.getCtx(), "Address1"));
        vector.add(Msg.translate(Env.getCtx(), "Address2"));
        vector.add(Msg.translate(Env.getCtx(), "Address3"));
        vector.add(Msg.translate(Env.getCtx(), "Address4"));
        vector.add(Msg.translate(Env.getCtx(), "Weight"));
        vector.add(Msg.translate(Env.getCtx(), "Volume"));
        return vector;
    }

    protected void setOrderColumnClass(IMiniTable iMiniTable) {
        int n = 0;
        iMiniTable.setColumnClass(n++, Boolean.class, false);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, Timestamp.class, true);
        iMiniTable.setColumnClass(n++, Timestamp.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Vector<Object>> getOrderLineData(IMiniTable iMiniTable, StringBuffer stringBuffer) {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        log.fine("LoadOrderLineSQL=" + stringBuffer.toString());
        try {
            cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
            resultSet = cPreparedStatement.executeQuery();
            KeyNamePair keyNamePair = null;
            KeyNamePair keyNamePair2 = null;
            KeyNamePair keyNamePair3 = null;
            KeyNamePair keyNamePair4 = null;
            KeyNamePair keyNamePair5 = null;
            BigDecimal bigDecimal = Env.ZERO;
            BigDecimal bigDecimal2 = Env.ZERO;
            BigDecimal bigDecimal3 = Env.ZERO;
            BigDecimal bigDecimal4 = Env.ZERO;
            BigDecimal bigDecimal5 = Env.ZERO;
            BigDecimal bigDecimal6 = Env.ZERO;
            BigDecimal bigDecimal7 = Env.ZERO;
            BigDecimal bigDecimal8 = Env.ZERO;
            BigDecimal bigDecimal9 = Env.ZERO;
            String string = null;
            boolean bl = false;
            int n = 0;
            while (resultSet.next()) {
                Serializable serializable;
                ValueNamePair valueNamePair;
                keyNamePair = new KeyNamePair(resultSet.getInt("M_Warehouse_ID"), resultSet.getString("Warehouse"));
                keyNamePair2 = new KeyNamePair(resultSet.getInt("OrderLine_ID"), resultSet.getString("DocumentNo"));
                keyNamePair3 = new KeyNamePair(resultSet.getInt("M_Product_ID"), resultSet.getString("Product"));
                keyNamePair4 = new KeyNamePair(resultSet.getInt("C_UOM_ID"), resultSet.getString("UOMSymbol"));
                bigDecimal = resultSet.getBigDecimal("QtyOnHand");
                bigDecimal6 = resultSet.getBigDecimal("QtyOrdered");
                keyNamePair5 = new KeyNamePair(resultSet.getInt("Order_UOM_ID"), resultSet.getString("Order_UOMSymbol"));
                bigDecimal2 = resultSet.getBigDecimal("QtyReserved");
                bigDecimal3 = resultSet.getBigDecimal("QtyInvoiced");
                bigDecimal4 = resultSet.getBigDecimal("QtyDelivered");
                bigDecimal5 = resultSet.getBigDecimal("QtyLoc");
                bigDecimal7 = resultSet.getBigDecimal("Qty");
                bigDecimal8 = resultSet.getBigDecimal("Weight");
                bigDecimal9 = resultSet.getBigDecimal("Volume");
                string = resultSet.getString("DeliveryRule");
                bl = (resultSet.getString("IsStocked") == null ? "N" : resultSet.getString("IsStocked")).equals("Y");
                n = MUOM.getPrecision(Env.getCtx(), keyNamePair4.getKey());
                if (bigDecimal == null) {
                    bigDecimal = Env.ZERO;
                }
                if (!bl) {
                    bigDecimal = bigDecimal7;
                }
                if (Util.isEmpty(string)) {
                    string = "A";
                }
                if (!(valueNamePair = new ValueNamePair(string, MRefList.getListName(Env.getCtx(), 151, string))).getID().equals("F") && !valueNamePair.getID().equals("M")) {
                    serializable = (bl ? Env.ONE : Env.ZERO).multiply(bigDecimal.subtract(bigDecimal7).setScale(n, RoundingMode.HALF_UP));
                    if (((BigDecimal)serializable).doubleValue() < 0.0) {
                        bigDecimal7 = bigDecimal7.subtract(((BigDecimal)serializable).abs()).setScale(n, RoundingMode.HALF_UP);
                    }
                    if (bigDecimal7.doubleValue() <= 0.0) continue;
                }
                serializable = new Vector<Comparable<Boolean>>();
                ((Vector)serializable).add(Boolean.FALSE);
                ((Vector)serializable).add(keyNamePair);
                ((Vector)serializable).add(keyNamePair2);
                ((Vector)serializable).add(keyNamePair3);
                ((Vector)serializable).add(keyNamePair4);
                ((Vector)serializable).add(bigDecimal);
                ((Vector)serializable).add(bigDecimal7);
                ((Vector)serializable).add(bigDecimal8.multiply(bigDecimal7));
                ((Vector)serializable).add(bigDecimal9.multiply(bigDecimal7));
                ((Vector)serializable).add(Env.ZERO);
                ((Vector)serializable).add(bigDecimal6);
                ((Vector)serializable).add(keyNamePair5);
                ((Vector)serializable).add(bigDecimal2);
                ((Vector)serializable).add(bigDecimal3);
                ((Vector)serializable).add(bigDecimal4);
                ((Vector)serializable).add(bigDecimal5);
                ((Vector)serializable).add(valueNamePair);
                vector.add((Vector<Object>)serializable);
            }
        }
        catch (SQLException sQLException) {
            try {
                log.log(Level.SEVERE, stringBuffer.toString(), sQLException);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                throw throwable;
            }
            DB.close(resultSet, cPreparedStatement);
        }
        DB.close(resultSet, cPreparedStatement);
        return vector;
    }

    protected Vector<String> getOrderLineColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(Msg.getMsg(Env.getCtx(), "Select"));
        vector.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        vector.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        vector.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        vector.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        vector.add(Msg.translate(Env.getCtx(), "QtyOnHand"));
        vector.add(Msg.translate(Env.getCtx(), "Qty"));
        vector.add(Msg.translate(Env.getCtx(), "Weight") + (String)(Util.isEmpty(this.uOMWeightSymbol) ? "" : " (" + this.uOMWeightSymbol + ")"));
        vector.add(Msg.translate(Env.getCtx(), "Volume") + (String)(Util.isEmpty(this.uOMWeightSymbol) ? "" : " (" + this.uOMVolumeSymbol + ")"));
        vector.add(Msg.translate(Env.getCtx(), "LoadSequence"));
        vector.add(Msg.translate(Env.getCtx(), "QtyOrdered"));
        vector.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        vector.add(Msg.translate(Env.getCtx(), "QtyReserved"));
        vector.add(Msg.translate(Env.getCtx(), "QtyInvoiced"));
        vector.add(Msg.translate(Env.getCtx(), "QtyDelivered"));
        vector.add(Msg.translate(Env.getCtx(), "QtyInTransit"));
        vector.add(Msg.translate(Env.getCtx(), "DeliveryRule"));
        return vector;
    }

    protected Vector<String> getStockColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        vector.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        vector.add(Msg.translate(Env.getCtx(), "M_Warehouse_ID"));
        vector.add(Msg.translate(Env.getCtx(), "QtyOnHand"));
        vector.add(Msg.translate(Env.getCtx(), "QtyInTransit"));
        vector.add(Msg.translate(Env.getCtx(), "Qty"));
        vector.add(Msg.translate(Env.getCtx(), "PickedQty"));
        return vector;
    }

    protected void setStockColumnClass(IMiniTable iMiniTable) {
        int n = 0;
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.autoSize();
    }

    protected void setOrderLineColumnClass(IMiniTable iMiniTable) {
        int n = 0;
        iMiniTable.setColumnClass(n++, Boolean.class, false);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, false);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, Integer.class, false);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, BigDecimal.class, true);
        iMiniTable.setColumnClass(n++, String.class, true);
        iMiniTable.autoSize();
    }

    public String validateQuantity(IMiniTable iMiniTable) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = DisplayType.getNumberFormat(22);
        for (int i = 0; i < iMiniTable.getRowCount(); ++i) {
            if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue()) continue;
            KeyNamePair keyNamePair = (KeyNamePair)iMiniTable.getValueAt(i, 2);
            int n = ((KeyNamePair)iMiniTable.getValueAt(i, 3)).getKey();
            BigDecimal bigDecimal = (BigDecimal)iMiniTable.getValueAt(i, 6);
            BigDecimal bigDecimal2 = (BigDecimal)iMiniTable.getValueAt(i, 10);
            BigDecimal bigDecimal3 = (BigDecimal)iMiniTable.getValueAt(i, 15);
            BigDecimal bigDecimal4 = (BigDecimal)iMiniTable.getValueAt(i, 14);
            KeyNamePair keyNamePair2 = (KeyNamePair)iMiniTable.getValueAt(i, 4);
            ValueNamePair valueNamePair = (ValueNamePair)iMiniTable.getValueAt(i, 16);
            MProduct mProduct = MProduct.get(Env.getCtx(), n);
            int n2 = MUOM.getPrecision(Env.getCtx(), keyNamePair2.getKey());
            if (valueNamePair.getID().equals("F") || valueNamePair.getID().equals("M")) continue;
            BigDecimal bigDecimal5 = bigDecimal2.subtract(bigDecimal4).subtract(bigDecimal3).setScale(n2, RoundingMode.HALF_UP);
            if (!(bigDecimal.setScale(n2, RoundingMode.HALF_UP).doubleValue() > bigDecimal5.doubleValue())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(Env.NL);
            } else {
                stringBuffer.append("@Error@ @Qty@ > @QtyAvailable@ ");
            }
            stringBuffer.append("@C_Order_ID@ " + keyNamePair.getName()).append(", @M_Product_ID@ " + mProduct.getValue() + "-" + mProduct.getName()).append(", @Qty@ " + decimalFormat.format(bigDecimal)).append(", @QtyAvailable@ " + decimalFormat.format(bigDecimal5));
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public String generateLoadOrder(String string, IMiniTable iMiniTable) {
        Optional<MDocType> optional;
        int n = 0;
        int n2 = iMiniTable.getRowCount();
        this.outBoundOrder = new MWMInOutBound(Env.getCtx(), 0, string);
        MWMInOutBoundLine mWMInOutBoundLine = null;
        BigDecimal bigDecimal = Env.ZERO;
        BigDecimal bigDecimal2 = Env.ZERO;
        if (this.orgId < 0) {
            this.orgId = Env.getAD_Org_ID(Env.getCtx());
        }
        if (this.warehouseId < 0) {
            this.warehouseId = Env.getContextAsInt(Env.getCtx(), "#M_Warehouse_ID");
        }
        this.outBoundOrder.setAD_Org_ID(this.orgId);
        this.outBoundOrder.setDateTrx(this.documentDate);
        this.outBoundOrder.setPickDate(this.documentDate);
        this.outBoundOrder.setShipDate(this.shipmentDate);
        if (this.docTypeTargetId > 0) {
            this.outBoundOrder.setC_DocType_ID(this.docTypeTargetId);
        } else {
            optional = Arrays.asList(MDocType.getOfDocBaseType(Env.getCtx(), "WMO")).stream().filter(mDocType -> mDocType.isSOTrx()).findFirst();
            if (!optional.isPresent()) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            this.outBoundOrder.setC_DocType_ID(((MDocType)optional.get()).getC_DocType_ID());
            this.docTypeTargetId = ((MDocType)optional.get()).getC_DocType_ID();
        }
        optional = this.validateQuantity(iMiniTable);
        if (!Util.isEmpty((String)((Object)optional))) {
            throw new AdempiereException((String)((Object)optional));
        }
        if (this.warehouseId > 0) {
            this.outBoundOrder.setM_Warehouse_ID(this.warehouseId);
        }
        if (!Util.isEmpty(this.deliveryRule)) {
            this.outBoundOrder.setDeliveryRule(this.deliveryRule);
        }
        if (!Util.isEmpty(this.deliveryViaRule)) {
            this.outBoundOrder.setDeliveryViaRule(this.deliveryViaRule);
        }
        if (this.shipperId > 0) {
            this.outBoundOrder.setM_Shipper_ID(this.shipperId);
        }
        this.outBoundOrder.setDocStatus("DR");
        this.outBoundOrder.setIsSOTrx(true);
        this.outBoundOrder.saveEx();
        for (int i = 0; i < n2; ++i) {
            PO pO;
            if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue()) continue;
            int n3 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getKey();
            int n4 = ((KeyNamePair)iMiniTable.getValueAt(i, 3)).getKey();
            BigDecimal bigDecimal3 = (BigDecimal)iMiniTable.getValueAt(i, 6);
            BigDecimal bigDecimal4 = (BigDecimal)iMiniTable.getValueAt(i, 7);
            BigDecimal bigDecimal5 = (BigDecimal)iMiniTable.getValueAt(i, 8);
            mWMInOutBoundLine = new MWMInOutBoundLine(this.outBoundOrder);
            mWMInOutBoundLine.setAD_Org_ID(this.orgId);
            MProduct mProduct = MProduct.get(Env.getCtx(), n4);
            if (this.movementType.equals("DD_Order")) {
                mWMInOutBoundLine.setDD_OrderLine_ID(n3);
                pO = new MDDOrderLine(Env.getCtx(), n3, string);
                mWMInOutBoundLine.setDD_Order_ID(((X_DD_OrderLine)pO).getDD_Order_ID());
                mWMInOutBoundLine.setDD_OrderLine_ID(((X_DD_OrderLine)pO).getDD_OrderLine_ID());
                mWMInOutBoundLine.setM_AttributeSetInstance_ID(((X_DD_OrderLine)pO).getM_AttributeSetInstance_ID());
                mWMInOutBoundLine.setC_UOM_ID(mProduct.getC_UOM_ID());
                mWMInOutBoundLine.setM_Locator_ID(((X_DD_OrderLine)pO).getM_Locator_ID());
                mWMInOutBoundLine.setM_LocatorTo_ID(((X_DD_OrderLine)pO).getM_LocatorTo_ID());
            } else {
                mWMInOutBoundLine.setC_OrderLine_ID(n3);
                pO = new MOrderLine(Env.getCtx(), n3, string);
                mWMInOutBoundLine.setC_Order_ID(((X_C_OrderLine)pO).getC_Order_ID());
                mWMInOutBoundLine.setC_OrderLine_ID(((X_C_OrderLine)pO).getC_OrderLine_ID());
                mWMInOutBoundLine.setM_AttributeSetInstance_ID(((X_C_OrderLine)pO).getM_AttributeSetInstance_ID());
                mWMInOutBoundLine.setC_UOM_ID(mProduct.getC_UOM_ID());
                if (this.locatorId == null) {
                    this.locatorId = this.getDefaultLocator(((X_C_OrderLine)pO).getM_Warehouse_ID(), n4, ((X_C_OrderLine)pO).getM_AttributeSetInstance_ID(), bigDecimal3, string);
                }
                mWMInOutBoundLine.setM_LocatorTo_ID(this.locatorId);
            }
            mWMInOutBoundLine.setM_Product_ID(n4);
            mWMInOutBoundLine.setMovementQty(bigDecimal3);
            mWMInOutBoundLine.setPickedQty(bigDecimal3);
            bigDecimal = bigDecimal.add(bigDecimal4);
            bigDecimal2 = bigDecimal2.add(bigDecimal5);
            mWMInOutBoundLine.saveEx();
            ++n;
        }
        this.outBoundOrder.setWeight(bigDecimal);
        this.outBoundOrder.setVolume(bigDecimal2);
        this.outBoundOrder.saveEx();
        if (Util.isEmpty(this.documentAction)) {
            this.documentAction = "CO";
        }
        this.outBoundOrder.setDocAction(this.documentAction);
        this.outBoundOrder.processIt(this.documentAction);
        this.outBoundOrder.saveEx();
        optional = this.outBoundOrder.getProcessMsg();
        if (optional != null && this.outBoundOrder.getDocStatus().equals("IN")) {
            throw new AdempiereException((String)((Object)optional));
        }
        return Msg.parseTranslation(Env.getCtx(), "@Created@ = [" + this.outBoundOrder.getDocumentNo() + "] || @LineNo@ = [" + n + "]" + (String)(optional != null ? "\n@Errors@:" + (String)((Object)optional) : ""));
    }

    private int getDefaultLocator(int n, int n2, int n3, BigDecimal bigDecimal, String string) {
        int n4 = MStorage.getM_Locator_ID(n, n2, n3, bigDecimal, string);
        if (n4 > 0) {
            return n4;
        }
        MWarehouse mWarehouse = MWarehouse.get(Env.getCtx(), n);
        MLocator mLocator = MLocator.getDefault(mWarehouse);
        if (mLocator == null) {
            MProduct mProduct = MProduct.get(Env.getCtx(), n2);
            throw new AdempiereException("@M_Locator_ID@ @NotFound@ [@M_Product_ID@: " + mProduct.getValue() + " - " + mProduct.getName() + " @M_Warehouse_ID@: " + mWarehouse.getName() + "]");
        }
        return mLocator.getM_Locator_ID();
    }

    protected void loadDefaultValues() {
        this.uOMWeightId = this.getC_UOM_Weight_ID();
        this.uOMVolumeId = this.getC_UOM_Volume_ID();
        if (this.uOMWeightId > 0) {
            this.weightPrecision = MUOM.getPrecision(Env.getCtx(), this.uOMWeightId);
        }
        if (this.uOMVolumeId > 0) {
            this.volumePrecision = MUOM.getPrecision(Env.getCtx(), this.uOMVolumeId);
        }
    }

    protected int getC_UOM_Weight_ID() {
        return DB.getSQLValue(null, "SELECT ci.C_UOM_Weight_ID FROM AD_ClientInfo ci WHERE ci.AD_Client_ID = ?", this.clientId);
    }

    protected int getC_UOM_Volume_ID() {
        return DB.getSQLValue(null, "SELECT ci.C_UOM_Volume_ID FROM AD_ClientInfo ci WHERE ci.AD_Client_ID = ?", this.clientId);
    }

    protected KeyNamePair[] getDataDocumentType() {
        if (this.movementType == null) {
            return null;
        }
        String string = this.movementType.equals("DD_Order") ? "DOO" : "SOO";
        String string2 = MRole.getDefault().addAccessSQL("SELECT doc.C_DocType_ID, TRIM(doc.Name) FROM C_DocType doc WHERE doc.DocBaseType = '" + string + "' AND (doc.DocSubTypeSO IS NULL OR doc.DocSubTypeSO NOT IN('RM', 'OB')) ORDER BY doc.Name", "doc", true, true);
        return DB.getKeyNamePairs(null, string2, false, new Object[0]);
    }

    protected KeyNamePair[] getDataWarehouse() {
        String string = "SELECT w.M_Warehouse_ID, w.Name FROM M_Warehouse w WHERE w.IsActive = 'Y' AND w.AD_Org_ID = " + this.orgId + " ORDER BY w.Name";
        return DB.getKeyNamePairs(null, string, false, new Object[0]);
    }

    protected BigDecimal getQtyInTransit(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return Env.ZERO;
        }
        String string = "SELECT COALESCE(SUM(lc.MovementQty), 0) QtyLoc FROM WM_InOutBound c INNER JOIN WM_InOutBoundLine lc ON(lc.WM_InOutBound_ID = c.WM_InOutBound_ID) WHERE lc.M_Product_ID = ? AND lc.M_Warehouse_ID = ? AND c.DocStatus = 'CO' AND c.IsDelivered = 'N'";
        BigDecimal bigDecimal = DB.getSQLValueBD(null, string, n, n2);
        if (bigDecimal == null) {
            bigDecimal = Env.ZERO;
        }
        return bigDecimal;
    }

    public boolean existsSeqNo(IMiniTable iMiniTable, int n, int n2) {
        log.info("existsSeqNo");
        int n3 = iMiniTable.getRowCount();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue() || i == n || n2 != (n4 = ((Integer)iMiniTable.getValueAt(i, 9)).intValue())) continue;
            return true;
        }
        return false;
    }

    public String validStock(IMiniTable iMiniTable) {
        log.info("validStock");
        int n = iMiniTable.getRowCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = ((KeyNamePair)iMiniTable.getValueAt(i, 0)).getName();
            String string2 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getName();
            BigDecimal bigDecimal = (BigDecimal)iMiniTable.getValueAt(i, 3);
            BigDecimal bigDecimal2 = (BigDecimal)iMiniTable.getValueAt(i, 4);
            BigDecimal bigDecimal3 = (BigDecimal)iMiniTable.getValueAt(i, 5);
            BigDecimal bigDecimal4 = (BigDecimal)iMiniTable.getValueAt(i, 6);
            if (bigDecimal4.compareTo(Env.ZERO) >= 0) continue;
            if (stringBuffer.length() == 0) {
                stringBuffer.append("@QtyInsufficient@");
            }
            stringBuffer.append(Env.NL).append("*").append(string).append("[").append("@M_Warehouse_ID@=").append(string2).append(" @QtyAvailable@=").append(bigDecimal.subtract(bigDecimal2).doubleValue()).append(" @QtyToDeliver@=").append(bigDecimal3.doubleValue()).append(" @PickedQty@=").append(bigDecimal4.doubleValue()).append("]");
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    public void loadBuffer(IMiniTable iMiniTable) {
        log.info("Load Buffer");
        int n = iMiniTable.getRowCount();
        int n2 = 0;
        BigDecimal bigDecimal = Env.ZERO;
        Integer n3 = 0;
        this.m_BufferSelect = new Vector();
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue()) continue;
            n2 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getKey();
            bigDecimal = (BigDecimal)iMiniTable.getValueAt(i, 6);
            n3 = (Integer)iMiniTable.getValueAt(i, 9);
            this.m_BufferSelect.addElement(new BufferTableSelect(n2, bigDecimal, n3));
        }
    }

    private BufferTableSelect isSelect(int n) {
        log.info("Is Select " + n);
        if (this.m_BufferSelect != null) {
            for (int i = 0; i < this.m_BufferSelect.size(); ++i) {
                if (this.m_BufferSelect.get(i).getRecord_ID() != n) continue;
                return this.m_BufferSelect.get(i);
            }
        }
        return null;
    }

    protected void setValueFromBuffer(IMiniTable iMiniTable) {
        log.info("Set Value From Buffer");
        if (this.m_BufferSelect != null) {
            int n = iMiniTable.getRowCount();
            int n2 = 0;
            BufferTableSelect bufferTableSelect = null;
            for (int i = 0; i < n; ++i) {
                n2 = ((KeyNamePair)iMiniTable.getValueAt(i, 2)).getKey();
                bufferTableSelect = this.isSelect(n2);
                if (bufferTableSelect == null) continue;
                iMiniTable.setValueAt(true, i, 0);
                iMiniTable.setValueAt(bufferTableSelect.getQty(), i, 6);
                iMiniTable.setValueAt(bufferTableSelect.getSeqNo(), i, 9);
            }
        }
    }

    protected boolean moreOneSelect(IMiniTable iMiniTable) {
        int n = iMiniTable.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!((Boolean)iMiniTable.getValueAt(i, 0)).booleanValue() || ++n2 <= 1) continue;
            return true;
        }
        return false;
    }

    public class BufferTableSelect {
        private int recordId = 0;
        private BigDecimal qty = Env.ZERO;
        private Integer seqNo = 0;

        public BufferTableSelect(int n, BigDecimal bigDecimal, Integer n2) {
            this.recordId = n;
            this.qty = bigDecimal;
            this.seqNo = n2;
        }

        public void setRecord_ID(int n) {
            this.recordId = n;
        }

        public int getRecord_ID() {
            return this.recordId;
        }

        public void setQty(BigDecimal bigDecimal) {
            this.qty = bigDecimal;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setSeqNo(Integer n) {
            this.seqNo = n;
        }

        public Integer getSeqNo() {
            return this.seqNo;
        }

        public String toString() {
            return "Record_ID = " + this.recordId + " qty = " + this.qty + "seqNo = " + this.seqNo;
        }
    }
}

