/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.util.support.IAppSupport;

public class AppSupportHandler {
    private static AppSupportHandler appSupportHandler = null;
    private Map<Integer, IAppSupport> appSupportGeneratorMap = new HashMap<Integer, IAppSupport>();
    private static final CLogger logger = CLogger.getCLogger(AppSupportHandler.class);

    public static AppSupportHandler getInstance() {
        if (appSupportHandler == null) {
            appSupportHandler = new AppSupportHandler();
        }
        return appSupportHandler;
    }

    private AppSupportHandler() {
    }

    public IAppSupport getAppSupport(MADAppRegistration registration) throws Exception {
        if (registration == null) {
            return null;
        }
        if (!this.appSupportGeneratorMap.containsKey(registration.getAD_AppSupport_ID())) {
            this.loadClass(registration.getAD_AppRegistration_ID(), registration.getAD_AppSupport_ID());
            return this.appSupportGeneratorMap.get(registration.getAD_AppSupport_ID());
        }
        IAppSupport supportedApplication = this.appSupportGeneratorMap.get(registration.getAD_AppSupport_ID());
        supportedApplication.setAppRegistrationId(registration.getAD_AppRegistration_ID());
        return supportedApplication;
    }

    private String getClassname(int appSupportId) {
        MADAppSupport definition = MADAppSupport.getById(Env.getCtx(), appSupportId, null);
        if (definition == null) {
            return null;
        }
        return definition.getClassname();
    }

    private Class<?> getHandlerClass(int appSupportId) {
        String className = this.getClassname(appSupportId);
        if (Util.isEmpty(className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            if (IAppSupport.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != IAppSupport.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + className);
                return clazz;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Loading class Error" + e.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + className);
        return null;
    }

    private void loadClass(int appRegistrationId, int appSupportId) throws Exception {
        Class<?> clazz = this.getHandlerClass(appSupportId);
        IAppSupport generator = null;
        if (clazz == null) {
            logger.log(Level.SEVERE, "Class not found, Using Standard Class");
            generator = null;
            throw new Exception("Class for connection not found");
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        generator = (IAppSupport)constructor.newInstance(new Object[0]);
        generator.setAppRegistrationId(appRegistrationId);
        this.appSupportGeneratorMap.put(appSupportId, generator);
    }
}

