/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.FunctionalDocsForProcess;
import org.spin.util.docs.FunctionalDocsForWindow;
import org.spin.util.docs.IIndex;
import org.spin.util.docs.TableTextConverter;

public class FunctionalDocsForSmartBrowse
extends AbstractDocumentationSource {
    private MBrowse smartBrowse;
    public static final String SUB_FOLDER_NAME = "smart-browse";
    public static final String FOLDER_NAME = "functional-guide" + File.separator + "smart-browse";

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter, PO source) {
        List<MBrowseField> browseField;
        String internalReference;
        this.smartBrowse = (MBrowse)source;
        textConverter.addHeaderIndexName((this.getFolderName() + "/" + this.getDocumentName()).toLowerCase());
        textConverter.addSection(this.smartBrowse.getName());
        textConverter.newLine();
        if (!Util.isEmpty(this.smartBrowse.getDescription())) {
            textConverter.addText(this.smartBrowse.getDescription());
            textConverter.newLine();
        }
        if (!Util.isEmpty(this.smartBrowse.getHelp())) {
            textConverter.addSubSection("Help");
            textConverter.addText(this.smartBrowse.getHelp());
            textConverter.newLine();
        }
        if (this.smartBrowse.isBetaFunctionality()) {
            textConverter.addNote(this.getFeature("IsBetaFunctionality"));
        }
        if (this.smartBrowse.getAD_Window_ID() != 0) {
            String name = this.smartBrowse.getAD_Window().getName();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForWindow.FOLDER_NAME + File.separator + "window-" + this.getValidValue(name);
            textConverter.addSeeAlso(name, internalReference.toLowerCase());
            textConverter.newLine();
        }
        if (this.smartBrowse.getAD_Process_ID() != 0) {
            MProcess process = (MProcess)this.smartBrowse.getAD_Process();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForProcess.FOLDER_NAME + File.separator + "process-" + this.getValidValue(process.getValue());
            textConverter.addSeeAlso(process.getName(), internalReference.toLowerCase());
            textConverter.newLine();
        }
        StringBuffer note = new StringBuffer();
        if (this.smartBrowse.isUpdateable()) {
            note.append(this.getFeature("IsUpdateable"));
        }
        if (this.smartBrowse.isDeleteable()) {
            if (note.length() > 0) {
                note.append(Env.NL);
            }
            note.append(this.getFeature("IsDeleteable"));
        }
        if (this.smartBrowse.isSelectedByDefault()) {
            if (note.length() > 0) {
                note.append(Env.NL);
            }
            note.append(this.getFeature("IsSelectedByDefault"));
        }
        if (this.smartBrowse.isCollapsibleByDefault()) {
            if (note.length() > 0) {
                note.append(Env.NL);
            }
            note.append(this.getFeature("IsCollapsibleByDefault"));
        }
        if (this.smartBrowse.isExecutedQueryByDefault()) {
            if (note.length() > 0) {
                note.append(Env.NL);
            }
            note.append(this.getFeature("IsExecutedQueryByDefault"));
        }
        if (this.smartBrowse.isShowTotal()) {
            if (note.length() > 0) {
                note.append(Env.NL);
            }
            note.append(this.getFeature("IsShowTotal"));
        }
        if (note.length() > 0) {
            textConverter.addNote(note.toString());
        }
        if ((browseField = this.smartBrowse.getFields()) != null && browseField.size() > 0) {
            textConverter.addSubSection("Fields");
            TableTextConverter fieldTable = new TableTextConverter();
            ArrayList<String> row = new ArrayList<String>();
            row.add("Name");
            row.add("Description");
            row.add("Displayed");
            row.add("Query Criteria");
            row.add("Order By");
            row.add("Read Only");
            row.add("Mandatory");
            fieldTable.addRow(row);
            for (MBrowseField field : browseField) {
                if (!field.isDisplayed() && !field.isQueryCriteria()) continue;
                row = new ArrayList();
                row.add(field.getName());
                row.add(field.getDescription());
                row.add(field.isDisplayed() ? "Yes" : "No");
                row.add(field.isQueryCriteria() ? "Yes" : "No");
                row.add(field.isOrderBy() ? "Yes" : "No");
                row.add(field.isReadOnly() ? "Yes" : "No");
                row.add(field.isMandatory() ? "Yes" : "No");
                fieldTable.addRow(row);
            }
            textConverter.addTable(fieldTable);
        }
        return true;
    }

    @Override
    public boolean addIndex(AbstractTextConverter indexConverter, PO source) {
        this.smartBrowse = (MBrowse)source;
        ((IIndex)((Object)indexConverter)).addIndex(this.smartBrowse.getName(), this.getDocumentName().toLowerCase(), this.getFolderName(), 0);
        return true;
    }

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter) {
        return false;
    }

    @Override
    public String getFolderName() {
        return FOLDER_NAME;
    }

    @Override
    public String getDocumentName() {
        if (this.smartBrowse != null) {
            return this.getValidValue("smart-browse-" + this.smartBrowse.getValue());
        }
        return null;
    }
}

