/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MADToken;
import org.spin.model.MADTokenDefinition;
import org.spin.util.ITokenGenerator;

public class TokenGenerator
implements ITokenGenerator {
    protected static SecureRandom random = new SecureRandom();
    private String token;
    private MADToken passReset;

    @Override
    public String generateToken(String tokenType, int userId) {
        long longToken = Math.abs(random.nextLong());
        String random = Long.toString(longToken, 16);
        this.token = random + userId;
        this.passReset = new MADToken(Env.getCtx(), 0, null);
        this.passReset.setTokenType(tokenType);
        this.passReset.setTokenType("TPA");
        if (this.passReset.getAD_TokenDefinition_ID() <= 0) {
            throw new AdempiereException("@AD_TokenDefinition_ID@ @NotFound@");
        }
        MADTokenDefinition definition = MADTokenDefinition.getById(Env.getCtx(), this.passReset.getAD_TokenDefinition_ID(), null);
        if (definition.isHasExpireDate()) {
            BigDecimal expirationTime = Optional.ofNullable(definition.getExpirationTime()).orElse(new BigDecimal(300000));
            this.passReset.setExpireDate(new Timestamp(System.currentTimeMillis() + expirationTime.longValue()));
        }
        this.passReset.setTokenValue(this.token);
        this.passReset.setAD_User_ID(userId);
        this.passReset.saveEx();
        return this.token;
    }

    @Override
    public boolean validateToken(String token, int userId) {
        MADToken passReset = (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ? AND AD_User_ID = ?", null).setParameters(token, userId).first();
        Timestamp current = new Timestamp(System.currentTimeMillis());
        return passReset != null && passReset.getExpireDate().compareTo(current) > 0;
    }

    @Override
    public MADToken getToken() {
        return this.passReset;
    }

    @Override
    public String getTokenValue() {
        return this.token;
    }
}

