/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.UUID;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;
import org.spin.model.MADToken;
import org.spin.model.MADTokenDefinition;
import org.spin.util.IThirdPartyAccessGenerator;

public class ThirdPartyAccess
implements IThirdPartyAccessGenerator {
    private MADToken token = null;
    private String userTokenValue = null;

    @Override
    public String generateToken(String tokenType, int userId) {
        return this.generateToken(userId, 0);
    }

    @Override
    public boolean validateToken(String token, int userId) {
        return false;
    }

    @Override
    public MADToken getToken() {
        return this.token;
    }

    @Override
    public String getTokenValue() {
        return this.userTokenValue;
    }

    @Override
    public String generateToken(int userId, int roleId) {
        if (userId < 0) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (roleId < 0) {
            throw new AdempiereException("@AD_Role_ID@ @NotFound@");
        }
        MADToken token = new MADToken(Env.getCtx(), 0, null);
        token.setTokenType("TPA");
        if (token.getAD_TokenDefinition_ID() <= 0) {
            throw new AdempiereException("@AD_TokenDefinition_ID@ @NotFound@");
        }
        MADTokenDefinition definition = MADTokenDefinition.getById(Env.getCtx(), token.getAD_TokenDefinition_ID(), null);
        String tokenValue = null;
        this.userTokenValue = null;
        try {
            String value = UUID.randomUUID().toString();
            byte[] saltValue = new byte[8];
            this.userTokenValue = SecureEngine.encrypt(value);
            tokenValue = SecureEngine.getSHA512Hash(1000, this.userTokenValue, saltValue);
        }
        catch (NoSuchAlgorithmException e) {
            new AdempiereException(e);
        }
        catch (UnsupportedEncodingException e) {
            new AdempiereException(e);
        }
        if (Util.isEmpty(tokenValue)) {
            throw new AdempiereException("@TokenValue@ @NotFound@");
        }
        if (definition.isHasExpireDate()) {
            BigDecimal expirationTime = Optional.ofNullable(definition.getExpirationTime()).orElse(new BigDecimal(300000));
            token.setExpireDate(new Timestamp(System.currentTimeMillis() + expirationTime.longValue()));
        }
        token.setTokenValue(tokenValue);
        token.setAD_User_ID(userId);
        token.setAD_Role_ID(roleId);
        token.saveEx();
        return this.userTokenValue;
    }

    @Override
    public boolean validateToken(String tokenValue) {
        String encryptedValue = null;
        try {
            byte[] saltValue = new byte[8];
            encryptedValue = SecureEngine.getSHA512Hash(1000, tokenValue, saltValue);
        }
        catch (NoSuchAlgorithmException e) {
            new AdempiereException(e);
        }
        catch (UnsupportedEncodingException e) {
            new AdempiereException(e);
        }
        this.token = this.getToken(encryptedValue);
        if (this.token == null || this.token.getAD_Token_ID() <= 0) {
            return false;
        }
        MADTokenDefinition definition = MADTokenDefinition.getById(Env.getCtx(), this.token.getAD_TokenDefinition_ID(), null);
        if (definition.isHasExpireDate()) {
            Timestamp current = new Timestamp(System.currentTimeMillis());
            return this.token != null && this.token.getExpireDate().compareTo(current) > 0;
        }
        return true;
    }

    private MADToken getToken(String encryptedValue) {
        return (MADToken)new Query(Env.getCtx(), "AD_Token", "TokenValue = ? AND EXISTS(SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_User_ID = AD_Token.AD_User_ID AND ur.AD_Role_ID = AD_Token.AD_Role_ID AND ur.IsActive = 'Y') AND EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = AD_Token.AD_User_ID AND u.IsActive = 'Y' AND u.IsLoginUser = 'Y') AND EXISTS(SELECT 1 FROM AD_Role r WHERE r.AD_Role_ID = AD_Token.AD_Role_ID AND r.IsActive = 'Y')", null).setParameters(encryptedValue).setOnlyActiveRecords(true).first();
    }
}

