/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.Optional;
import org.compiere.model.MEntityType;
import org.compiere.model.MRule;

public class RuleEngineUtil {
    public static String getClassName(MRule rule) {
        if (rule == null || rule.getAD_Rule_ID() <= 0) {
            return null;
        }
        return rule.getValue().replaceAll("[+^: &\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "_");
    }

    public static String getPackageName(MRule rule) {
        if (rule == null || rule.getAD_Rule_ID() <= 0) {
            return null;
        }
        MEntityType entityType = MEntityType.get(rule.getCtx(), rule.getEntityType());
        String packageName = Optional.ofNullable(entityType.getModelPackage()).orElse("org.spin.model");
        int index = packageName.lastIndexOf(".");
        packageName = packageName.substring(0, index);
        return packageName + ".engine";
    }

    public static String getCompleteClassName(MRule rule) {
        String packageName = RuleEngineUtil.getPackageName(rule);
        if (packageName == null) {
            return null;
        }
        String className = RuleEngineUtil.getClassName(rule);
        if (className == null) {
            return null;
        }
        return packageName + "." + className;
    }
}

