/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;
import org.spin.util.TokenGeneratorHandler;

public class GeneratePassword {
    private StringBuffer msg = new StringBuffer();
    private Properties context;

    public String doIt(String userName) {
        List<MUser> users = MUser.getUsers(this.context, userName);
        users.stream().filter(user -> user.isActive() && user.isLoginUser()).forEach(user -> {
            try {
                this.msg.append(this.generateToken((MUser)user));
            }
            catch (Exception e) {
                this.msg.append(e.getLocalizedMessage());
            }
        });
        return this.msg.toString();
    }

    public GeneratePassword(Properties context) {
        if (context == null) {
            throw new AdempiereException("Context is Mandatory");
        }
        this.context = context;
    }

    public String generateToken(MUser user) throws Exception {
        if (user == null) {
            throw new AdempiereUserError("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty(user.getEMail())) {
            throw new AdempiereUserError("@AD_User_ID@ - @Email@ @NotFound@");
        }
        MClient client = MClient.get(user.getCtx(), user.getAD_Client_ID());
        MClientInfo clientInfo = client.getInfo();
        TokenGeneratorHandler.getInstance().generateToken("URL", user.getAD_User_ID());
        int mailTextId = clientInfo.getRestorePassword_MailText_ID();
        if (mailTextId <= 0) {
            throw new AdempiereUserError("@RestorePassword_MailText_ID@ @NotFound@");
        }
        MMailText text = new MMailText(this.context, mailTextId, null);
        text.setPO(TokenGeneratorHandler.getInstance().getToken("URL"));
        text.setUser(user);
        String message = text.getMailText(true);
        Trx.run(transactionName -> {
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.context).withTransactionName(transactionName);
            notifier.clearMessage().withApplicationType("EMA").addRecipient(user.getAD_User_ID(), user.getEMail()).withText(message).withDescription(text.getMailHeader());
            notifier.addToQueue();
        });
        return user.getName() + ": @Ok@";
    }
}

