/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHLog;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;

public abstract class AbstractWithholdingSetting {
    private MWHSetting setting;
    private MWHDefinition withholdingDefinition;
    private HashMap<String, Object> parameters = new HashMap();
    private HashMap<String, Object> returnValues = new HashMap();
    private Properties context;
    private String transactionName;
    private StringBuffer processLog = new StringBuffer();
    private StringBuffer processDescription = new StringBuffer();
    private BigDecimal baseAmount;
    private BigDecimal withholdingAmount;
    private BigDecimal withholdingRate;
    private DocAction document;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public AbstractWithholdingSetting(MWHSetting setting) {
        this.setting = setting;
        this.context = setting.getCtx();
        this.baseAmount = Env.ZERO;
        this.withholdingRate = Env.ZERO;
        this.withholdingAmount = Env.ZERO;
    }

    public Properties getContext() {
        return this.context;
    }

    private void setContext(Properties context) {
        this.context = context;
    }

    public void setDocument(DocAction document) {
        this.document = document;
        this.setTransactionName(document.get_TrxName());
        this.setContext(document.getCtx());
        this.clearValues();
    }

    public DocAction getDocument() {
        return this.document;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    protected void addLog(String message) {
        if (this.processLog.length() > 0) {
            this.processLog.append(Env.NL);
        }
        this.processLog.append("- ").append(message);
    }

    public String getProcessLog() {
        if (this.processLog.length() > 0) {
            return this.processLog.toString();
        }
        return null;
    }

    protected void addDescription(String description) {
        if (this.processDescription.length() > 0) {
            this.processDescription.append(Env.NL);
        }
        this.processDescription.append(description);
    }

    public String getProcessDescription() {
        if (this.processDescription.length() > 0) {
            return this.processDescription.toString();
        }
        return null;
    }

    public void setWithholdingDefinition(MWHDefinition withholdingDefinition) {
        this.withholdingDefinition = withholdingDefinition;
    }

    public MWHDefinition getDefinition() {
        return this.withholdingDefinition;
    }

    public MWHSetting getSetting() {
        return this.setting;
    }

    public void setParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void setParameters(HashMap<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public int getParameterAsInt(String key) {
        Object parameter = this.getParameter(key);
        if (parameter != null && parameter instanceof Integer) {
            return (Integer)parameter;
        }
        return 0;
    }

    public BigDecimal getParameterAsBigDecimal(String key) {
        Object parameter = this.getParameter(key);
        if (parameter != null && parameter instanceof BigDecimal) {
            return (BigDecimal)parameter;
        }
        return Env.ZERO;
    }

    public void setReturnValue(String key, Object value) {
        this.returnValues.put(key, value);
    }

    public Object getReturnValue(String key) {
        return this.returnValues.get(key);
    }

    public HashMap<String, Object> getReturnValues() {
        return this.returnValues;
    }

    public BigDecimal getWithholdingAmount() {
        return this.withholdingAmount;
    }

    public void setWithholdingAmount(BigDecimal withholdingAmount) {
        this.withholdingAmount = withholdingAmount;
    }

    public BigDecimal getWithholdingRate() {
        return this.getWithholdingRate(false);
    }

    public BigDecimal getWithholdingRate(boolean converted) {
        if (converted) {
            return this.withholdingRate.divide(Env.ONEHUNDRED);
        }
        return this.withholdingRate;
    }

    public void setWithholdingRate(BigDecimal withholdingRate) {
        this.withholdingRate = withholdingRate;
    }

    public void addWithholdingAmount(BigDecimal withholdingAmount) {
        this.withholdingAmount = this.withholdingAmount.add(withholdingAmount);
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void addBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = this.baseAmount.add(baseAmount);
    }

    public abstract boolean isValid();

    public abstract String run();

    protected void saveResult() {
        try {
            if (this.getWithholdingAmount() != null && this.getWithholdingAmount().compareTo(Env.ZERO) > 0) {
                this.createWithholding();
            } else {
                this.createLog();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.clearValues();
        }
    }

    private void createWithholding() {
        MWHWithholding withholding = new MWHWithholding(this.getContext(), 0, this.getTransactionName());
        withholding.setDateDoc(new Timestamp(System.currentTimeMillis()));
        withholding.setA_Base_Amount(this.getBaseAmount());
        withholding.setWithholdingAmt(this.getWithholdingAmount());
        withholding.setWithholdingRate(this.getWithholdingRate());
        withholding.setWH_Definition_ID(this.getDefinition().getWH_Definition_ID());
        withholding.setWH_Setting_ID(this.getSetting().getWH_Setting_ID());
        withholding.setC_DocType_ID();
        if (this.document != null) {
            if (this.document instanceof MInvoice) {
                withholding.setSourceInvoice_ID(this.document.get_ID());
                withholding.setC_BPartner_ID(((MInvoice)this.document).getC_BPartner_ID());
            } else if (this.document instanceof MOrder) {
                withholding.setSourceOrder_ID(this.document.get_ID());
                withholding.setC_BPartner_ID(((MOrder)this.document).getC_BPartner_ID());
            }
        }
        if (!Util.isEmpty(this.getProcessDescription())) {
            withholding.setDescription(Msg.parseTranslation(this.getContext(), this.getProcessDescription()));
        }
        this.getReturnValues().entrySet().forEach(value -> {
            if (withholding.get_ColumnIndex((String)value.getKey()) > 0 && value.getValue() != null) {
                withholding.set_ValueOfColumn((String)value.getKey(), value.getValue());
            }
        });
        withholding.setDocStatus("DR");
        withholding.saveEx();
        if (!withholding.processIt("CO")) {
            throw new AdempiereException(withholding.getProcessMsg());
        }
        withholding.saveEx();
    }

    private void clearValues() {
        this.baseAmount = Env.ZERO;
        this.withholdingRate = Env.ZERO;
        this.withholdingAmount = Env.ZERO;
        this.returnValues = new HashMap();
        this.processLog = new StringBuffer();
        this.processDescription = new StringBuffer();
    }

    private void createLog() {
        if (Util.isEmpty(this.getProcessLog())) {
            return;
        }
        MWHLog log = new MWHLog(this.getContext(), 0, this.getTransactionName());
        log.setWH_Definition_ID(this.getDefinition().getWH_Definition_ID());
        log.setWH_Setting_ID(this.getSetting().getWH_Setting_ID());
        log.setComments(Msg.parseTranslation(this.getContext(), this.getProcessLog()));
        this.getReturnValues().entrySet().forEach(value -> {
            if (log.get_ColumnIndex((String)value.getKey()) > 0 && value.getValue() != null) {
                log.set_ValueOfColumn((String)value.getKey(), value.getValue());
            }
        });
        log.saveEx();
    }
}

