/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tar.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.util.Util;
import org.spin.tar.model.MHRIncidence;
import org.spin.tar.model.MHRShiftIncidence;
import org.spin.tar.process.CreateExpenseReportFromIncidenceAbstract;

public class CreateExpenseReportFromIncidence
extends CreateExpenseReportFromIncidenceAbstract {
    private MTimeExpense expenseReport = null;
    private int currentBPartnerId = 0;
    private int currentContractId = 0;

    @Override
    protected String doIt() throws Exception {
        int n = 0;
        for (Integer n2 : this.getSelectionKeys()) {
            MHRIncidence mHRIncidence = new MHRIncidence(this.getCtx(), n2, this.get_TrxName());
            MHRShiftIncidence mHRShiftIncidence = new MHRShiftIncidence(this.getCtx(), mHRIncidence.getHR_ShiftIncidence_ID(), this.get_TrxName());
            if (!mHRIncidence.getDocStatus().equals("CO")) continue;
            int n3 = mHRIncidence.getC_BPartner_ID();
            int n4 = mHRIncidence.get_ValueAsInt("S_Contract_ID");
            int n5 = mHRIncidence.get_ValueAsInt("S_ContractLine_ID");
            if (this.expenseReport == null || this.currentBPartnerId != n3 || this.currentContractId != n4) {
                this.currentContractId = n4;
                this.currentBPartnerId = n3;
                this.processDocument();
                this.createExpenseReport();
            }
            BigDecimal bigDecimal = this.getSelectionAsBigDecimal(n2, "HI_Qty");
            MTimeExpenseLine mTimeExpenseLine = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
            mTimeExpenseLine.setS_TimeExpense_ID(this.expenseReport.getS_TimeExpense_ID());
            mTimeExpenseLine.setDateExpense(this.getDateReport());
            mTimeExpenseLine.setIsTimeReport(true);
            boolean bl = Util.isEmpty(this.getIsInvoiced()) ? mHRShiftIncidence.isInvoiced() : this.getIsInvoiced().equals("Y");
            mTimeExpenseLine.setIsInvoiced(bl);
            if (mHRShiftIncidence.getM_Product_ID() != 0) {
                mTimeExpenseLine.setM_Product_ID(mHRShiftIncidence.getM_Product_ID());
            }
            mTimeExpenseLine.setQty(bigDecimal);
            mTimeExpenseLine.setC_BPartner_ID(this.currentBPartnerId);
            if (n5 > 0) {
                mTimeExpenseLine.set_ValueOfColumn("S_ContractLine_ID", (Object)n5);
            }
            mTimeExpenseLine.saveEx();
            mHRIncidence.setS_TimeExpense_ID(this.expenseReport.getS_TimeExpense_ID());
            mHRIncidence.setS_TimeExpenseLine_ID(mTimeExpenseLine.getS_TimeExpenseLine_ID());
            mHRIncidence.saveEx();
            ++n;
        }
        this.processDocument();
        return "@Created@ " + n;
    }

    private void processDocument() {
        if (this.expenseReport == null) {
            return;
        }
        if (!this.expenseReport.processIt(this.getDocAction())) {
            throw new AdempiereException("@Error@ " + this.expenseReport.getProcessMsg());
        }
        this.expenseReport.saveEx();
        this.addLog(this.expenseReport.getS_TimeExpense_ID(), null, null, this.expenseReport.toString());
    }

    private void createExpenseReport() {
        this.expenseReport = new MTimeExpense(this.getCtx(), 0, this.get_TrxName());
        this.expenseReport.setDocStatus("DR");
        this.expenseReport.setDocAction("CO");
        this.expenseReport.setC_BPartner_ID(this.currentBPartnerId);
        this.expenseReport.setDateReport(this.getDateReport());
        this.expenseReport.setM_Warehouse_ID(this.getWarehouseId());
        this.expenseReport.setM_PriceList_ID(this.getPriceListId());
        if (this.currentContractId > 0) {
            this.expenseReport.set_ValueOfColumn("S_Contract_ID", (Object)this.currentContractId);
        }
        this.expenseReport.saveEx();
    }
}

