/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.compiere.model.MCountry;
import org.compiere.model.MPriceList;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.spin.store.util.support.elasticsearch.ElasticSearch;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;

public class TaxCategory
implements IPersistenceWrapper {
    Map<String, Object> map = new HashMap<String, Object>();
    private MTaxCategory taxCategory;
    private List<MTax> taxes;
    private MStore webStore;

    public static TaxCategory newInstance() {
        return new TaxCategory();
    }

    public TaxCategory withTaxCategory(MTaxCategory mTaxCategory) {
        this.taxCategory = mTaxCategory;
        return this;
    }

    private TaxCategory() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.loadTaxes();
        this.map = new HashMap<String, Object>();
        this.map.put("id", this.taxCategory.getC_TaxCategory_ID());
        this.map.put("code", this.taxCategory.getName());
        this.map.put("label", this.taxCategory.getName());
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.taxes.forEach(mTax -> {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", mTax.getC_Tax_ID());
            hashMap.put("code", mTax.getTaxIndicator());
            hashMap.put("rate", mTax.getRate().doubleValue());
            hashMap.put("tax_postcode", "*");
            if (mTax.getC_Country_ID() != 0) {
                hashMap.put("tax_country_id", MCountry.get(this.taxCategory.getCtx(), mTax.getC_Country_ID()).getCountryCode());
            }
            arrayList2.add(hashMap);
            arrayList.add(mTax.getC_Tax_ID());
        });
        MPriceList mPriceList = MPriceList.get(this.taxCategory.getCtx(), this.webStore.getM_PriceList_ID(), this.taxCategory.get_TrxName());
        this.map.put("calculate_subtotal", mPriceList.isTaxIncluded());
        this.map.put("tax_rate_ids", arrayList);
        this.map.put("rates", arrayList2);
        this.map.put("is_active", this.taxCategory.isActive());
        this.map.put("created_at", ElasticSearch.convertedDate(this.taxCategory.getCreated().getTime()));
        this.map.put("updated_at", ElasticSearch.convertedDate(this.taxCategory.getUpdated().getTime()));
        return this.map;
    }

    private void loadTaxes() {
        if (this.taxes == null) {
            this.taxes = Arrays.asList(MTax.getAll(this.taxCategory.getCtx())).stream().filter(mTax -> mTax.getC_TaxCategory_ID() == this.taxCategory.getC_TaxCategory_ID()).filter(mTax -> mTax.isSalesTax() || mTax.getSOPOType().equals("S") || mTax.getSOPOType().equals("B")).collect(Collectors.toList());
        }
    }

    @Override
    public boolean isValid() {
        this.loadTaxes();
        return this.taxes != null && this.taxes.size() > 0;
    }

    @Override
    public String getKeyValue() {
        if (this.taxCategory == null) {
            return "";
        }
        return String.valueOf(this.taxCategory.get_ID());
    }

    @Override
    public String getCatalogName() {
        return "taxrule";
    }

    @Override
    public IPersistenceWrapper withWebStoreId(int n) {
        if (n > 0) {
            this.webStore = MStore.get(this.taxCategory.getCtx(), n);
        }
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        return null;
    }
}

