/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util.support.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.compiere.util.CLogger;
import org.spin.store.model.MWCategory;
import org.spin.store.util.support.elasticsearch.ElasticSearch;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;

public class Category
implements IPersistenceWrapper {
    Map<String, Object> map = new HashMap<String, Object>();
    private MWCategory category;
    private List<Integer> parents;
    private static CLogger log = CLogger.getCLogger(Category.class);

    public static Category newInstance() {
        return new Category();
    }

    public Category withCategoy(MWCategory mWCategory) {
        this.category = mWCategory;
        return this;
    }

    private Category() {
    }

    @Override
    public Map<String, Object> getMap() {
        this.map = new HashMap<String, Object>();
        if (Optional.ofNullable(this.category).isPresent()) {
            this.map.put("id", this.category.get_ID());
            this.map.put("name", this.category.getName());
            this.map.put("url_key", this.getURLKey(this.category, true));
            this.map.put("slug", this.getURLKey(this.category, true));
            this.map.put("path", this.getPath());
            this.map.put("url_path", this.getURLPath());
            this.map.put("position", this.getLevel());
            Map<String, Object> map = this.getChild(this.category);
            int n = 0;
            if (map.containsKey("children_data")) {
                List list = (List)map.get("children_data");
                this.map.put("children_data", map.get("children_data"));
                n = list.size();
            }
            this.map.put("children_count", n);
            if (this.category.getW_Category_Parent_ID() != 0) {
                this.map.put("parent_id", this.category.getW_Category_Parent_ID());
            }
            this.map.put("level", this.getLevel());
            this.map.put("product_count", this.category.getProductCount());
            this.map.put("is_active", this.category.isActive() && this.category.isWebStoreFeatured());
            this.map.put("created_at", ElasticSearch.convertedDate(this.category.getCreated().getTime()));
            this.map.put("updated_at", ElasticSearch.convertedDate(this.category.getUpdated().getTime()));
        }
        return this.map;
    }

    private void loadParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<Integer>();
            this.parents.add(this.category.getW_Category_ID());
            this.loadParents(this.category);
            Collections.reverse(this.parents);
        }
    }

    private void loadParents(MWCategory mWCategory) {
        MWCategory mWCategory2;
        if (mWCategory.getW_Category_Parent_ID() != 0 && (mWCategory2 = (MWCategory)mWCategory.getW_Category_Parent()) != null) {
            if (!this.parents.contains(mWCategory2.getW_Category_ID())) {
                this.parents.add(mWCategory2.getW_Category_ID());
                this.loadParents(mWCategory2);
            } else {
                log.warning("Possible recursive call: " + mWCategory.getValue() + " - " + mWCategory.getName());
            }
        }
    }

    public String getURLKey(boolean bl) {
        return this.getURLKey(this.category, bl);
    }

    private String getURLKey(MWCategory mWCategory, boolean bl) {
        Object object = this.getValidValue(mWCategory.getName());
        if (bl) {
            object = (String)object + "-" + String.valueOf(mWCategory.getW_Category_ID());
        }
        return object;
    }

    private String getValidValue(String string) {
        return string.trim().toLowerCase().replaceAll(" ", "-").replaceAll("[+^:,.&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()/]", "");
    }

    public int getLevel() {
        this.loadParents();
        int n = this.parents.size() + 2;
        if (this.category.getW_Category_Parent_ID() == 0) {
            n = 2;
        }
        return n;
    }

    public String getURLPath() {
        this.loadParents();
        StringBuffer stringBuffer = new StringBuffer();
        this.parents.forEach(n -> {
            MWCategory mWCategory = MWCategory.getById(this.category.getCtx(), n, this.category.get_TrxName());
            if (stringBuffer.length() > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(this.getURLKey(mWCategory, n.intValue() == this.category.getW_Category_ID()));
        });
        return stringBuffer.toString();
    }

    public String getPath() {
        this.loadParents();
        StringBuffer stringBuffer = new StringBuffer();
        this.parents.forEach(n -> {
            MWCategory mWCategory = MWCategory.getById(this.category.getCtx(), n, this.category.get_TrxName());
            if (stringBuffer.length() > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(mWCategory.getW_Category_ID());
        });
        return stringBuffer.toString();
    }

    private Map<String, Object> getChild(MWCategory mWCategory2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList arrayList = new ArrayList();
        mWCategory2.getChildList().forEach(mWCategory -> {
            Map<String, Object> map = Category.newInstance().withCategoy((MWCategory)mWCategory).getMap();
            arrayList.add(map);
        });
        hashMap.put("children_data", arrayList);
        return hashMap;
    }

    @Override
    public String getKeyValue() {
        if (this.category == null) {
            return "";
        }
        return String.valueOf(this.category.get_ID());
    }

    @Override
    public String getCatalogName() {
        return "category";
    }

    @Override
    public boolean isValid() {
        return this.category != null;
    }

    @Override
    public IPersistenceWrapper withWebStoreId(int n) {
        return this;
    }

    @Override
    public Map<String, Object> getMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", "date");
        hashMap.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("type", "date");
        hashMap2.put("format", "yyyy-MM-dd hh:mm:ss");
        HashMap hashMap3 = new HashMap();
        hashMap3.put("created_at", hashMap);
        hashMap3.put("updated_at", hashMap2);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("type", "keyword");
        hashMap3.put("slug", hashMap4);
        HashMap<String, String> hashMap5 = new HashMap<String, String>();
        hashMap5.put("type", "keyword");
        hashMap3.put("url_path", hashMap5);
        HashMap<String, String> hashMap6 = new HashMap<String, String>();
        hashMap6.put("type", "keyword");
        hashMap3.put("url_key", hashMap6);
        HashMap<String, Object> hashMap7 = new HashMap<String, Object>();
        hashMap7.put("properties", hashMap3);
        return hashMap7;
    }
}

