/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_W_Basket;
import org.adempiere.core.domains.models.X_W_BasketLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MPackage;
import org.compiere.model.MPackageLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class VueStoreFrontUtil {
    public static final String COLUMNNAME_CacheServerProvider_ID = "CacheServerProvider_ID";
    public static final String COLUMNNAME_CustomerRole_ID = "CustomerRole_ID";
    public static final String COLUMNNAME_C_TemplateBPartner_ID = "C_TemplateBPartner_ID";
    public static final String COLUMNNAME_C_Tax_ID = "C_Tax_ID";
    public static final String COLUMNNAME_DeliveryViaRule = "DeliveryViaRule";
    public static final String COLUMNNAME_FreightCostRule = "FreightCostRule";
    public static final String COLUMNNAME_LineDiscount = "LineDiscount";
    public static final String COLUMNNAME_LineDiscountAmt = "LineDiscountAmt";
    public static final String COLUMNNAME_LineListAmt = "LineListAmt";
    public static final String COLUMNNAME_LineNetAmt = "LineNetAmt";
    public static final String COLUMNNAME_LineTotalAmt = "LineTotalAmt";
    public static final String COLUMNNAME_M_FreightCategory_ID = "M_FreightCategory_ID";
    public static final String COLUMNNAME_M_Shipper_ID = "M_Shipper_ID";
    public static final String COLUMNNAME_M_Warehouse_ID = "M_Warehouse_ID";
    public static final String COLUMNNAME_PriceList = "PriceList";
    public static final String COLUMNNAME_TaxAmt = "TaxAmt";
    public static final String COLUMNNAME_LastName = "LastName";
    public static final String COLUMNNAME_IsDefaultShipping = "IsDefaultShipping";
    public static final String COLUMNNAME_IsDefaultBilling = "IsDefaultBilling";

    public static MStore getDefaultStore(int n) {
        List<MStore> list = Arrays.asList(MStore.getOfClient(MClient.get(Env.getCtx())));
        AtomicInteger atomicInteger = new AtomicInteger(n);
        if (n == 0) {
            atomicInteger.set(Env.getAD_Org_ID(Env.getCtx()));
        }
        AtomicReference atomicReference = new AtomicReference();
        list.stream().filter(mStore -> mStore.getAD_Org_ID() == atomicInteger.get()).findFirst().ifPresent(mStore -> atomicReference.set(mStore));
        if (atomicReference.get() == null) {
            list.stream().findFirst().ifPresent(mStore -> atomicReference.set(mStore));
        }
        return (MStore)atomicReference.get();
    }

    public static BigDecimal getPriceStd(MProduct mProduct, int n) {
        MProductPricing mProductPricing = VueStoreFrontUtil.getProductPricing(mProduct, n);
        if (mProductPricing == null) {
            return Env.ZERO;
        }
        return mProductPricing.getPriceStd().setScale(mProductPricing.getPrecision());
    }

    public static BigDecimal getPriceList(MProduct mProduct, int n) {
        MProductPricing mProductPricing = VueStoreFrontUtil.getProductPricing(mProduct, n);
        if (mProductPricing == null) {
            return Env.ZERO;
        }
        return mProductPricing.getPriceList().setScale(mProductPricing.getPrecision());
    }

    public static MProductPricing getProductPricing(MProduct mProduct, int n) {
        MPriceList mPriceList = MPriceList.get(mProduct.getCtx(), n, mProduct.get_TrxName());
        Timestamp timestamp = TimeUtil.getDay(System.currentTimeMillis());
        MProductPricing mProductPricing = new MProductPricing(mProduct.getM_Product_ID(), 0, Env.ZERO, true, mProduct.get_TrxName());
        mProductPricing.setM_PriceList_ID(mPriceList.getM_PriceList_ID());
        mProductPricing.setPriceDate(timestamp);
        return mProductPricing;
    }

    public static MTax getTax(int n) {
        Optional<MTax> optional = Arrays.asList(MTax.getAll(Env.getCtx())).stream().filter(mTax -> mTax.getC_TaxCategory_ID() == n && (mTax.isSalesTax() || !Util.isEmpty(mTax.getSOPOType()) && (mTax.getSOPOType().equals("B") || mTax.getSOPOType().equals("S")))).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static BigDecimal getTaxRate(int n) {
        MTax mTax = VueStoreFrontUtil.getTax(n);
        BigDecimal bigDecimal = Env.ZERO;
        if (mTax == null) {
            return bigDecimal;
        }
        return mTax.getRate();
    }

    public static void setBasketLineDefaultValues(X_W_BasketLine x_W_BasketLine) {
        if (x_W_BasketLine == null) {
            return;
        }
        MStore mStore = VueStoreFrontUtil.getDefaultStore(x_W_BasketLine.getAD_Org_ID());
        MProduct mProduct = MProduct.get(x_W_BasketLine.getCtx(), x_W_BasketLine.getM_Product_ID());
        MTax mTax = VueStoreFrontUtil.getTax(mProduct.getC_TaxCategory_ID());
        BigDecimal bigDecimal = x_W_BasketLine.getQty();
        MProductPricing mProductPricing = VueStoreFrontUtil.getProductPricing(mProduct, mStore.getM_PriceList_ID());
        BigDecimal bigDecimal2 = mProductPricing.getPriceList().setScale(mProductPricing.getPrecision());
        BigDecimal bigDecimal3 = mProductPricing.getPriceStd().setScale(mProductPricing.getPrecision());
        BigDecimal bigDecimal4 = mProductPricing.getDiscount();
        BigDecimal bigDecimal5 = bigDecimal2.multiply(bigDecimal).setScale(mProductPricing.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal5.multiply(bigDecimal4).divide(Env.ONEHUNDRED, RoundingMode.HALF_UP).setScale(mProductPricing.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal bigDecimal7 = bigDecimal3.multiply(bigDecimal).setScale(mProductPricing.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal bigDecimal8 = bigDecimal7.multiply(mTax.getRate()).divide(Env.ONEHUNDRED, RoundingMode.HALF_UP);
        BigDecimal bigDecimal9 = bigDecimal7.add(bigDecimal8);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_M_Warehouse_ID, (Object)mStore.getM_Warehouse_ID());
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_PriceList, (Object)bigDecimal2);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_LineDiscount, (Object)bigDecimal4);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_LineDiscountAmt, (Object)bigDecimal6);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_LineListAmt, (Object)bigDecimal5);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_LineNetAmt, (Object)bigDecimal7);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_TaxAmt, (Object)bigDecimal8);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_LineTotalAmt, (Object)bigDecimal9);
        x_W_BasketLine.set_ValueOfColumn(COLUMNNAME_C_Tax_ID, (Object)mTax.getC_Tax_ID());
    }

    public static List<MPackage> getPackagesFromBasket(Properties properties, int n, String string) {
        return new Query(properties, "M_Package", "W_Basket_ID = ?", string).setParameters(n).list();
    }

    public static void deletePackageLineFromBasketLine(Properties properties, int n, String string) {
        List<MPackageLine> list = new Query(Env.getCtx(), "M_PackageLine", "W_BasketLine_ID = ?", string).setParameters(n).list();
        list.forEach(mPackageLine -> mPackageLine.deleteEx(true));
    }

    public static void deletePackageFromBasket(Properties properties, int n, String string) {
        List<MPackage> list = new Query(Env.getCtx(), "M_Package", "W_Basket_ID = ?", string).setParameters(n).list();
        list.forEach(mPackage -> mPackage.deleteEx(true));
    }

    public static List<MPackage> createPackagesFromBasket(Properties properties, int n, String string) {
        X_W_Basket x_W_Basket = new X_W_Basket(properties, n, string);
        List<MPackage> list = VueStoreFrontUtil.getPackagesFromBasket(properties, n, string);
        if (x_W_Basket.getC_BPartner_ID() <= 0) {
            return list;
        }
        MBPartner mBPartner = MBPartner.get(properties, x_W_Basket.getC_BPartner_ID());
        List<MBPartnerLocation> list2 = Arrays.asList(mBPartner.getLocations(true));
        Optional optional = Optional.of(list2.stream().filter(mBPartnerLocation -> mBPartnerLocation.isShipTo()).findFirst()).orElse(list2.stream().findFirst());
        if (list == null) {
            list = new ArrayList<MPackage>();
        }
        if (x_W_Basket.getC_BPartner_ID() <= 0 || !optional.isPresent()) {
            return list;
        }
        MStore mStore = VueStoreFrontUtil.getDefaultStore(x_W_Basket.getAD_Org_ID());
        if (mStore == null) {
            throw new AdempiereException("@W_Store_ID@ @NotFound@");
        }
        HashMap hashMap = new HashMap();
        list.forEach(mPackage -> {
            String string = mPackage.getM_Warehouse_ID() + "|" + mPackage.getDeliveryViaRule() + "|" + mPackage.getFreightCostRule() + "|" + mPackage.getM_FreightCategory_ID() + "|" + mPackage.getM_Shipper_ID();
            hashMap.put(string, mPackage);
        });
        List<X_W_BasketLine> list3 = new Query(Env.getCtx(), "W_BasketLine", "W_Basket_ID = ? AND M_Shipper_ID IS NOT NULL", string).setParameters(n).list();
        list3.forEach(x_W_BasketLine -> {
            String string2 = x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_Warehouse_ID) + "|" + x_W_BasketLine.get_ValueAsString(COLUMNNAME_DeliveryViaRule) + "|" + x_W_BasketLine.get_ValueAsString(COLUMNNAME_FreightCostRule) + "|" + x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID) + "|" + x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID);
            MPackage mPackage = (MPackage)hashMap.get(string2);
            if (mPackage == null) {
                mPackage = new MPackage(properties, 0, string);
            }
            if (x_W_BasketLine.getAD_Org_ID() > 0) {
                mPackage.setAD_Org_ID(x_W_BasketLine.getAD_Org_ID());
            } else {
                mPackage.setAD_Org_ID(mStore.getAD_Org_ID());
            }
            mPackage.setM_Warehouse_ID(x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_Warehouse_ID));
            mPackage.setDateDoc(new Timestamp(System.currentTimeMillis()));
            if (x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID) > 0) {
                mPackage.setM_Shipper_ID(x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_Shipper_ID));
            }
            mPackage.setC_BPartner_ID(x_W_Basket.getC_BPartner_ID());
            mPackage.setC_BPartner_Location_ID(((MBPartnerLocation)optional.get()).getC_BPartner_Location_ID());
            mPackage.setDeliveryViaRule(x_W_BasketLine.get_ValueAsString(COLUMNNAME_DeliveryViaRule));
            if (!Util.isEmpty(x_W_BasketLine.get_ValueAsString(COLUMNNAME_FreightCostRule))) {
                mPackage.setFreightCostRule(x_W_BasketLine.get_ValueAsString(COLUMNNAME_FreightCostRule));
            }
            if (x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID) > 0) {
                mPackage.setM_FreightCategory_ID(x_W_BasketLine.get_ValueAsInt(COLUMNNAME_M_FreightCategory_ID));
            }
            mPackage.set_ValueOfColumn("W_Basket_ID", (Object)x_W_Basket.getW_Basket_ID());
            Optional<Integer> optional2 = Optional.of(MDocType.getDocType("MMK", mPackage.getAD_Org_ID()));
            if (optional2.isPresent()) {
                mPackage.setC_DocType_ID(optional2.get());
            }
            mPackage.setSalesRep_ID(mStore.getSalesRep_ID());
            mPackage.saveEx(string);
            List<MPackageLine> list = mPackage.getLines(true);
            Optional<MPackageLine> optional3 = list.stream().filter(mPackageLine -> mPackageLine.get_ValueAsInt("W_BasketLine_ID") == x_W_BasketLine.getW_BasketLine_ID()).findFirst();
            MPackageLine mPackageLine2 = optional3.orElse(new MPackageLine(mPackage));
            MProduct mProduct = MProduct.get(properties, x_W_BasketLine.getM_Product_ID());
            mPackageLine2.set_ValueOfColumn("W_BasketLine_ID", (Object)x_W_BasketLine.getW_BasketLine_ID());
            mPackageLine2.setQty(x_W_BasketLine.getQty());
            mPackageLine2.setWeight(Optional.ofNullable(mProduct.getWeight()).orElse(Env.ZERO).multiply(x_W_BasketLine.getQty()));
            mPackageLine2.setVolume(Optional.ofNullable(mProduct.getVolume()).orElse(Env.ZERO).multiply(x_W_BasketLine.getQty()));
            mPackageLine2.setDescription(Msg.parseTranslation(properties, "@Created@ @from@ @W_Basket_ID@: (" + x_W_BasketLine.getW_Basket_ID() + ") - " + x_W_BasketLine.getLine() + ": " + x_W_BasketLine.getProduct()));
            mPackageLine2.saveEx(string);
            hashMap.put(string2, mPackage);
        });
        return list;
    }

    public static MBPartner getTemplate(Properties properties, int n, String string) {
        MBPartner mBPartner = MBPartner.get(properties, n);
        if (mBPartner == null) {
            mBPartner = new MBPartner(properties, 0, null);
        }
        MBPartner mBPartner2 = new MBPartner(properties, 0, string);
        PO.copyValues(mBPartner, mBPartner2);
        mBPartner2.setTaxID("");
        mBPartner2.setValue("");
        mBPartner2.setName("");
        mBPartner2.setName2(null);
        mBPartner2.setDUNS("");
        mBPartner2.setFirstSale(null);
        mBPartner2.setSO_CreditLimit(Env.ZERO);
        mBPartner2.setSO_CreditUsed(Env.ZERO);
        mBPartner2.setTotalOpenBalance(Env.ZERO);
        mBPartner2.setActualLifeTimeValue(Env.ZERO);
        mBPartner2.setPotentialLifeTimeValue(Env.ZERO);
        mBPartner2.setAcqusitionCost(Env.ZERO);
        mBPartner2.setShareOfCustomer(0);
        mBPartner2.setSalesVolume(0);
        return mBPartner2;
    }
}

