/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MStore;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.store.support.IExternalCache;
import org.spin.store.util.support.elasticsearch.IPersistenceWrapper;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class ElasticSearchHelper {
    private static Map<Integer, ElasticSearchHelper> instances;
    private MStore webStore;
    private boolean isValid = false;
    private IExternalCache externalCache;

    public static ElasticSearchHelper getInstance(MStore mStore) {
        int n = 0;
        if (mStore != null) {
            n = mStore.getW_Store_ID();
        }
        if (instances == null) {
            instances = new HashMap<Integer, ElasticSearchHelper>();
            instances.put(n, new ElasticSearchHelper(mStore));
        }
        return instances.get(n);
    }

    public static ElasticSearchHelper getInstance() {
        List<MStore> list = Arrays.asList(MStore.getOfClient(MClient.get(Env.getCtx())));
        AtomicReference atomicReference = new AtomicReference();
        if (list != null && list.size() > 0) {
            list.forEach(mStore -> {
                if (atomicReference.get() == null) {
                    atomicReference.set(mStore);
                }
            });
        }
        return ElasticSearchHelper.getInstance((MStore)atomicReference.get());
    }

    private ElasticSearchHelper(MStore mStore) {
        this.webStore = mStore;
    }

    private boolean isValid() {
        boolean bl = this.isValid = this.webStore != null;
        if (!this.isValid) {
            return false;
        }
        try {
            this.isValid = this.externalCache != null;
            int n = this.webStore.get_ValueAsInt("CacheServerProvider_ID");
            if (this.isValid && this.externalCache.getCacheId() == n) {
                return true;
            }
            if (n == 0) {
                throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
            }
            IAppSupport iAppSupport = AppSupportHandler.getInstance().getAppSupport(MADAppRegistration.getById(Env.getCtx(), n, null));
            if (iAppSupport == null) {
                throw new AdempiereException("@CacheServerProvider_ID@ @NotFound@");
            }
            if (!IExternalCache.class.isAssignableFrom(iAppSupport.getClass())) {
                throw new AdempiereException("@CacheServerProvider_ID@ @Invalid@");
            }
            this.externalCache = (IExternalCache)((Object)iAppSupport);
            this.externalCache.withWebStore(this.webStore);
            this.isValid = true;
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this.isValid;
    }

    public final MStore getWebStore() {
        return this.webStore;
    }

    public final ElasticSearchHelper withWebStore(MStore mStore) {
        this.webStore = mStore;
        return this;
    }

    public final ElasticSearchHelper withWebStoreId(int n) {
        if (n <= 0) {
            return this;
        }
        this.webStore = MStore.get(Env.getCtx(), n);
        return this;
    }

    public final ElasticSearchHelper withWebContext(String string) {
        if (Util.isEmpty(string)) {
            return this;
        }
        this.webStore = MStore.get(Env.getCtx(), string);
        return this;
    }

    public ElasticSearchHelper index(IPersistenceWrapper iPersistenceWrapper) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.index(iPersistenceWrapper.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper update(IPersistenceWrapper iPersistenceWrapper) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.update(iPersistenceWrapper.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper delete(IPersistenceWrapper iPersistenceWrapper) {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.delete(iPersistenceWrapper.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this;
    }

    public boolean exist(IPersistenceWrapper iPersistenceWrapper) {
        if (!this.isValid()) {
            return false;
        }
        try {
            return this.externalCache.exist(iPersistenceWrapper.withWebStoreId(this.webStore.getW_Store_ID()));
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
    }

    public ElasticSearchHelper connect() {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.connect();
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this;
    }

    public ElasticSearchHelper close() {
        if (!this.isValid()) {
            return this;
        }
        try {
            this.externalCache.close();
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return this;
    }
}

