/*
 * Decompiled with CFR 0.152.
 */
package org.spin.store.process;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.MProduct;
import org.compiere.model.MTaxCategory;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.spin.store.model.MWCategory;
import org.spin.store.process.ExportCatalogAbstract;
import org.spin.store.util.ElasticSearchHelper;
import org.spin.store.util.support.elasticsearch.Attribute;
import org.spin.store.util.support.elasticsearch.Category;
import org.spin.store.util.support.elasticsearch.Product;
import org.spin.store.util.support.elasticsearch.TaxCategory;

public class ExportCatalog
extends ExportCatalogAbstract {
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        try {
            KeyNamePair[] keyNamePairArray;
            AtomicInteger atomicInteger;
            ElasticSearchHelper.getInstance().withWebStoreId(this.getStoreId()).connect();
            if (this.isExportProduct()) {
                atomicInteger = new AtomicInteger();
                keyNamePairArray = DB.getKeyNamePairs("SELECT M_Product_ID, Name FROM M_Product WHERE AD_Client_ID = ? AND IsActive = 'Y' AND IsWebStoreFeatured = 'Y'", false, this.getAD_Client_ID());
                Arrays.asList(keyNamePairArray).forEach(keyNamePair -> {
                    try {
                        MProduct mProduct = MProduct.get(this.getCtx(), keyNamePair.getKey());
                        ElasticSearchHelper.getInstance().index(Product.newInstance().withProduct(mProduct));
                        this.addLog(keyNamePair.getName() + ": @Ok@");
                        atomicInteger.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception exception) {
                        this.log.warning("Error: " + exception.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + keyNamePair.getName() + ": " + exception.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_Product_ID@: " + atomicInteger.get());
            }
            if (this.isExportProductCategory()) {
                atomicInteger = new AtomicInteger();
                keyNamePairArray = DB.getKeyNamePairs("SELECT W_Category_ID, Name FROM W_Category WHERE AD_Client_ID = ? AND IsActive = 'Y'", false, this.getAD_Client_ID());
                Arrays.asList(keyNamePairArray).forEach(keyNamePair -> {
                    try {
                        MWCategory mWCategory = MWCategory.getById(this.getCtx(), keyNamePair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(Category.newInstance().withCategoy(mWCategory));
                        this.addLog(keyNamePair.getName() + ": @Ok@");
                        atomicInteger.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception exception) {
                        this.log.warning("Error: " + exception.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + keyNamePair.getName() + ": " + exception.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@W_Category_ID@: " + atomicInteger);
            }
            if (this.isExportProductAttribute()) {
                atomicInteger = new AtomicInteger();
                keyNamePairArray = DB.getKeyNamePairs("SELECT M_Attribute_ID, Name FROM M_Attribute WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM M_AttributeValue av WHERE av.M_Attribute_ID = M_Attribute.M_Attribute_ID)", false, this.getAD_Client_ID());
                Arrays.asList(keyNamePairArray).forEach(keyNamePair -> {
                    try {
                        MAttribute mAttribute = new MAttribute(this.getCtx(), keyNamePair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(Attribute.newInstance().withAttribute(mAttribute));
                        this.addLog(keyNamePair.getName() + ": @Ok@");
                        atomicInteger.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception exception) {
                        this.log.warning("Error: " + exception.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + keyNamePair.getName() + ": " + exception.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@M_AttributeSet_ID@: " + atomicInteger);
            }
            if (this.isExportTax()) {
                atomicInteger = new AtomicInteger();
                keyNamePairArray = DB.getKeyNamePairs("SELECT C_TaxCategory_ID, Name FROM C_TaxCategory WHERE AD_Client_ID = ? AND IsActive = 'Y' AND EXISTS(SELECT 1 FROM C_Tax t WHERE t.C_TaxCategory_ID = C_TaxCategory.C_TaxCategory_ID AND (t.IsSalesTax = 'Y' OR t.SOPOType IN('S', 'B')))", false, this.getAD_Client_ID());
                Arrays.asList(keyNamePairArray).forEach(keyNamePair -> {
                    try {
                        MTaxCategory mTaxCategory = new MTaxCategory(this.getCtx(), keyNamePair.getKey(), this.get_TrxName());
                        ElasticSearchHelper.getInstance().index(TaxCategory.newInstance().withTaxCategory(mTaxCategory));
                        this.addLog(keyNamePair.getName() + ": @Ok@");
                        atomicInteger.incrementAndGet();
                        this.created.incrementAndGet();
                    }
                    catch (Exception exception) {
                        this.log.warning("Error: " + exception.getLocalizedMessage());
                        this.addLog("@ErrorProcessingFile@ " + keyNamePair.getName() + ": " + exception.getLocalizedMessage());
                        this.errors.incrementAndGet();
                    }
                });
                this.addLog("@C_TaxCategory_ID@: " + atomicInteger);
            }
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        finally {
            ElasticSearchHelper.getInstance().close();
        }
        return "@Created@: " + this.created.get() + " - @Errors@: " + this.errors.get();
    }
}

