/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcess;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.queue.process.FlushSystemQueue;
import org.spin.util.ISetupDefinition;

public class QueueSetup
implements ISetupDefinition {
    private static final String SETUP_DESCRIPTION = "(*Created from Setup Automatically*)";

    @Override
    public String doIt(Properties context, String transactionName) {
        this.createDefaultNotifiers(context, transactionName);
        this.createSchedule(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createDefaultNotifiers(Properties context, String transactionName) {
        MADAppRegistration notesSender;
        MADAppRegistration emailSender = MADAppRegistration.getByApplicationType(context, "EMA", transactionName);
        if (emailSender == null || emailSender.getAD_AppRegistration_ID() <= 0) {
            MADAppSupport emailSupport = MADAppSupport.getByApplicationType(context, "EMA", transactionName);
            if (emailSupport == null || emailSupport.getAD_AppSupport_ID() <= 0) {
                throw new AdempiereException("@AD_AppSupport_ID@ @EMail@ @NotFound@");
            }
            emailSender = new MADAppRegistration(context, 0, transactionName);
            emailSender.setValue("EMail");
            emailSender.setApplicationType("EMA");
            emailSender.setAD_AppSupport_ID(emailSupport.getAD_AppSupport_ID());
            emailSender.setName("Default EMail Sender");
            emailSender.setVersionNo("1.0");
            emailSender.setHost("localhost");
            emailSender.setPort(0);
            emailSender.saveEx();
        }
        if ((notesSender = MADAppRegistration.getByApplicationType(context, "NTE", transactionName)) == null || notesSender.getAD_AppRegistration_ID() <= 0) {
            MADAppSupport notesSupport = MADAppSupport.getByApplicationType(context, "NTE", transactionName);
            if (notesSupport == null || notesSupport.getAD_AppSupport_ID() <= 0) {
                throw new AdempiereException("@AD_AppSupport_ID@ @Note@ @NotFound@");
            }
            notesSender = new MADAppRegistration(context, 0, transactionName);
            notesSender.setValue("Notes");
            notesSender.setApplicationType("NTE");
            notesSender.setAD_AppSupport_ID(notesSupport.getAD_AppSupport_ID());
            notesSender.setName("Default Notes Sender");
            notesSender.setVersionNo("1.0");
            notesSender.setHost("localhost");
            notesSender.setPort(0);
            notesSender.saveEx();
        }
    }

    private void createSchedule(Properties context, String transactionName) {
        new Query(context, "AD_Scheduler", "AD_Process_ID = ?", transactionName).setParameters(FlushSystemQueue.getProcessId()).setClient_ID().list().forEach(scheduler -> scheduler.delete(true));
        MScheduler scheduler2 = new MScheduler(context, 0, transactionName);
        scheduler2.setAD_Org_ID(0);
        scheduler2.setName(FlushSystemQueue.getProcessName());
        scheduler2.setDescription(SETUP_DESCRIPTION);
        scheduler2.setAD_Process_ID(FlushSystemQueue.getProcessId());
        scheduler2.setSupervisor_ID(Env.getAD_User_ID(context));
        scheduler2.setFrequencyType("M");
        scheduler2.setFrequency(5);
        scheduler2.setKeepLogDays(7);
        scheduler2.setDateNextRun(TimeUtil.addMinutess(TimeUtil.getDay(System.currentTimeMillis()), scheduler2.getFrequency()));
        scheduler2.saveEx();
        MProcess process = MProcess.get(context, FlushSystemQueue.getProcessId());
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("BatchsToProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("10");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("RecordsByBatch")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("100");
            schedulerParameter.saveEx();
        });
        process.getParametersAsList().stream().filter(parameter -> parameter.getColumnName().equals("IsDeleteAfterProcess")).findFirst().ifPresent(parameter -> {
            MSchedulerPara schedulerParameter = new MSchedulerPara(context, 0, transactionName);
            schedulerParameter.setAD_Org_ID(0);
            schedulerParameter.setAD_Scheduler_ID(scheduler2.getAD_Scheduler_ID());
            schedulerParameter.setAD_Process_Para_ID(parameter.getAD_Process_Para_ID());
            schedulerParameter.setParameterDefault("N");
            schedulerParameter.saveEx();
        });
    }
}

