/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.telegram.setup;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.spin.model.MADAppRegistration;
import org.spin.model.MADAppSupport;
import org.spin.queue.notification.telegram.support.Telegram;
import org.spin.util.ISetupDefinition;

public class Deploy
implements ISetupDefinition {
    @Override
    public String doIt(Properties properties, String string) {
        this.createRegistration(properties, string);
        this.createSystemConfigHost(properties, string);
        this.createSystemConfigCode(properties, string);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private void createRegistration(Properties properties, String string) {
        MADAppRegistration mADAppRegistration = (MADAppRegistration)new Query(properties, "AD_AppRegistration", "EXISTS(SELECT 1 FROM AD_AppSupport s WHERE s.AD_AppSupport_ID = AD_AppRegistration.AD_AppSupport_ID AND s.ApplicationType = ?AND s.IsActive = 'Y'AND s.Classname = ?)", string).setParameters("STG", Telegram.class.getName()).setClient_ID().first();
        if (mADAppRegistration != null && mADAppRegistration.getAD_AppRegistration_ID() > 0) {
            return;
        }
        MADAppSupport mADAppSupport = (MADAppSupport)new Query(properties, "AD_AppSupport", "Classname = ?", string).setParameters(Telegram.class.getName()).first();
        if (mADAppSupport == null) {
            throw new AdempiereException("@AD_AppSupport_ID@ @NotFound@");
        }
        mADAppRegistration = new MADAppRegistration(properties, 0, string);
        mADAppRegistration.setApplicationType(mADAppSupport.getApplicationType());
        mADAppRegistration.setAD_AppSupport_ID(mADAppSupport.getAD_AppSupport_ID());
        mADAppRegistration.setAD_Org_ID(0);
        mADAppRegistration.setValue("Custom-Telegram-Sender");
        mADAppRegistration.setName("Custom Telegram Sender");
        mADAppRegistration.setVersionNo("1.0");
        mADAppRegistration.setHost("localhost");
        mADAppRegistration.setPort(0);
        mADAppRegistration.setTimeout(0);
        mADAppRegistration.saveEx();
        mADAppRegistration.setUUID("(*AutomaticSetup*)");
        mADAppRegistration.setIsDirectLoad(true);
        mADAppRegistration.saveEx();
    }

    private void createSystemConfigHost(Properties properties, String string) {
        MSysConfig mSysConfig = new MSysConfig(properties, 0, string);
        mSysConfig.setName("CLIENT_HOST");
        mSysConfig.setDescription("Host for current client or tenant");
        mSysConfig.setEntityType("ECA34");
        mSysConfig.setConfigurationLevel("C");
        mSysConfig.setAD_Org_ID(0);
        mSysConfig.setValue("https://localhost");
        mSysConfig.saveEx();
        mSysConfig.setUUID("(*AutomaticSetup*)");
        mSysConfig.setIsDirectLoad(true);
        mSysConfig.saveEx();
    }

    private void createSystemConfigCode(Properties properties, String string) {
        MSysConfig mSysConfig = new MSysConfig(properties, 0, string);
        mSysConfig.setName("CLIENT_CODE");
        mSysConfig.setDescription("Client Code or identification");
        mSysConfig.setEntityType("ECA34");
        mSysConfig.setConfigurationLevel("C");
        mSysConfig.setAD_Org_ID(0);
        mSysConfig.setValue("localhost");
        mSysConfig.saveEx();
        mSysConfig.setUUID("(*AutomaticSetup*)");
        mSysConfig.setIsDirectLoad(true);
        mSysConfig.saveEx();
    }
}

