/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.discord.util;

import java.util.Arrays;
import java.util.Optional;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.util.Util;
import org.spin.queue.notification.discord.util.IDiscordMessage;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;

public class BaseMessage
implements IDiscordMessage {
    public static MessageAction createBaseMessage(JDA jDA, String string, String string2) {
        if (jDA == null) {
            throw new AdempiereException("@Connection@ @IsMandatory@");
        }
        if (Util.isEmpty(string)) {
            throw new AdempiereException("@Message@ @IsMandatory@");
        }
        if (Util.isEmpty(string2)) {
            throw new AdempiereException("@Channel@ @IsMandatory@");
        }
        TextChannel textChannel = BaseMessage.getChannel(jDA, string2);
        return textChannel.sendMessage((CharSequence)string);
    }

    private static TextChannel getChannel(JDA jDA, String string) {
        if (string.matches("[+-]?\\d*(\\.\\d+)?")) {
            return jDA.getTextChannelById(string);
        }
        Optional optional = jDA.getTextChannelsByName(string, true).stream().findFirst();
        if (optional.isPresent()) {
            return (TextChannel)optional.get();
        }
        throw new AdempiereException("@Channel@ @IsMandatory@");
    }

    @Override
    public MessageAction createAndGetMessage(JDA jDA, MADNotificationQueue mADNotificationQueue, MADNotificationRecipient mADNotificationRecipient) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!Util.isEmpty(mADNotificationQueue.getDescription())) {
            stringBuilder.append("**").append(mADNotificationQueue.getDescription().trim()).append("**").append("\n");
        }
        if (!Util.isEmpty(mADNotificationQueue.getText())) {
            stringBuilder.append(mADNotificationQueue.getText());
        }
        MessageAction messageAction = BaseMessage.createBaseMessage(jDA, stringBuilder.toString(), mADNotificationRecipient.getAccountName());
        MAttachment mAttachment = mADNotificationQueue.getAttachment();
        if (mAttachment != null && mAttachment.getAD_Attachment_ID() > 0) {
            Arrays.asList(mAttachment.getEntries()).forEach(mAttachmentEntry -> messageAction.addFile(mAttachmentEntry.getFile(), new AttachmentOption[0]));
        }
        return messageAction;
    }
}

