/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.util.Env;
import org.spin.process.WithholdingSendAbstract;

public class WithholdingSend
extends WithholdingSendAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        AtomicReference<Integer> result = new AtomicReference<Integer>();
        result.set(0);
        if (this.getMailTextId() == 0) {
            throw new AdempiereException("@Invalid@ @R_MailTex_ID@");
        }
        if (!this.isSelection()) {
            ArrayList<Object> params = new ArrayList<Object>();
            Object whereClause = "DocStatus IN (?,?) ";
            params.add("CO");
            params.add("CL");
            whereClause = (String)whereClause + "AND EXISTS(SELECT 1 FROM WH_Withholding wh INNER JOIN WH_Setting whs ON (wh.WH_Setting_ID = whs.WH_Setting_ID) WHERE wh.C_Invoice_ID = C_Invoice.C_Invoice_ID ";
            if (this.getTypeId() != 0) {
                whereClause = (String)whereClause + "AND whs.WH_Type_ID = ? ";
                params.add(this.getTypeId());
            }
            whereClause = (String)whereClause + ") ";
            if (this.getBPartnerId() != 0) {
                whereClause = (String)whereClause + "AND C_BPartner_ID = ? ";
                params.add(this.getBPartnerId());
            }
            if (!this.getIsSOTrx().equals("")) {
                whereClause = (String)whereClause + "AND IsSOTrx = ? ";
                params.add(this.getIsSOTrx());
            }
            whereClause = (String)whereClause + "AND DateInvoiced >= ? ";
            if (this.getDateDoc() != null) {
                params.add(this.getDateDoc());
            } else {
                params.add(Env.getContextAsDate(this.getCtx(), "@#Date@"));
            }
            whereClause = (String)whereClause + "AND DateInvoiced <= ? ";
            if (this.getDateDocTo() != null) {
                params.add(this.getDateDocTo());
            } else {
                params.add(Env.getContextAsDate(this.getCtx(), "@#Date@"));
            }
            new Query(this.getCtx(), "C_Invoice", (String)whereClause, this.get_TrxName()).setParameters(params).list().forEach(invoice -> result.set((Integer)result.get() + this.sendInvoiceEmail(invoice.get_ID(), this.getMailTextId())));
        } else {
            this.getSelectionKeys().forEach(invoiceID -> result.set((Integer)result.get() + this.sendInvoiceEmail((int)invoiceID, this.getMailTextId())));
        }
        return "@EMail@ @Sent@ " + result.get();
    }

    private int sendInvoiceEmail(int Record_ID, int MailText_ID) {
        MInvoice invoice = new MInvoice(this.getCtx(), Record_ID, this.get_TrxName());
        MUser to = (MUser)invoice.getAD_User();
        MUser from = MUser.get(this.getCtx(), this.getAD_User_ID());
        if (to == null || to != null && to.get_ID() == 0) {
            to = Arrays.asList(MUser.getOfBPartner(this.getCtx(), invoice.getC_BPartner_ID(), this.get_TrxName())).stream().filter(user -> user.getC_BPartner_Location_ID() == invoice.getC_BPartner_Location_ID()).findFirst().orElse(null);
        }
        if (to != null && to.get_ID() != 0) {
            ReportEngine re = ReportEngine.get(this.getCtx(), 2, invoice.get_ID());
            File attachment = re.getPDF();
            MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
            MMailText template = new MMailText(this.getCtx(), MailText_ID, this.get_TrxName());
            template.setPO(invoice);
            template.setBPartner(invoice.getC_BPartner_ID());
            template.setUser(this.getAD_User_ID());
            if (client.sendEMail(from, to, template.getMailHeader(), template.getMailText(true), attachment, template.isHtml())) {
                this.addLog("@EMail@ @Sent@ @to@ " + to.getName());
                return 1;
            }
            return 0;
        }
        this.addLog("@NotFound@ @AD_User_ID@ -> @C_BPartner_ID@ " + invoice.getC_BPartner().getName() + " @DocumentNo@ " + invoice.getDocumentNo());
        return 0;
    }
}

