/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MAllocInvoice;
import org.openup.core.utils.POGroupingProcessor;
import org.openup.core.utils.Utils;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;
import org.spin.model.X_WH_Withholding;
import org.spin.process.Withholding;
import org.spin.process.WithholdingGenerateAbstract;

public class WithholdingGenerate
extends WithholdingGenerateAbstract {
    private ArrayList<Withholding> withholdingDocList = new ArrayList();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List mwhWithholdings;
        if (this.isSelection()) {
            mwhWithholdings = this.getSelectionValues().keySet().stream().map(stringObjectLinkedHashMap -> new MWHWithholding(this.getCtx(), (int)stringObjectLinkedHashMap, this.get_TrxName())).collect(Collectors.toList());
        } else {
            StringBuffer whereClause = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            whereClause.append("AD_Client_ID = ? ");
            params.add(this.getAD_Client_ID());
            whereClause.append("AND DocStatus IN (?,?) ");
            params.add("CO");
            params.add("CL");
            if (this.getParameterAsInt("AD_Org_ID") > 0) {
                whereClause.append(" AND AD_Org_ID = ? ");
                params.add(this.getParameterAsInt("AD_Org_ID"));
            }
            if (this.getParameterAsInt("C_BPartner_ID") > 0) {
                whereClause.append(" AND C_BPartner_ID = ? ");
                params.add(this.getParameterAsInt("C_BPartner_ID"));
            }
            if (this.getParameterAsInt("C_Invoice_ID") > 0) {
                whereClause.append(" AND SourceInvoice_ID = ? ");
                params.add(this.getParameterAsInt("C_Invoice_ID"));
            }
            if (this.getParameterAsInt("WH_Type_ID") > 0) {
                whereClause.append(" AND EXISTS (SELECT 1 FROM WH_Definition whd WHERE whd.WH_Definition_ID = WH_Withholding.WH_Definition_ID AND whd.WH_Type_ID = ?) ");
                params.add(this.getParameterAsInt("WH_Type_ID"));
            }
            MPeriod currentPeriod = MPeriod.get(this.getCtx(), this.getParameterAsTimestamp("DateDoc"), Env.getAD_Org_ID(this.getCtx()));
            SimpleDateFormat sdf = Utils.getSQLSDF();
            whereClause.append(" AND DateDoc BETWEEN '" + sdf.format(currentPeriod.getStartDate()) + "' AND '" + sdf.format(currentPeriod.getEndDate()) + "'");
            mwhWithholdings = new Query(this.getCtx(), "WH_Withholding", whereClause.toString(), this.get_TrxName()).setParameters(params).list();
        }
        new POGroupingProcessor().addPO(mwhWithholdings).addCriteria("whDef", X_WH_Withholding::getWH_Definition_ID).addCriteria("cbp", X_WH_Withholding::getC_BPartner_ID).addCriteria("cli", PO::getAD_Client_ID).addCriteria("org", PO::getAD_Org_ID).processGrupedObjects((mwhWGroupedParams, mwhWithholdingsGrouped) -> {
            boolean needsToBeGenerated = false;
            MWHDefinition mwhDefinition = new MWHDefinition(this.getCtx(), (Integer)mwhWGroupedParams.get("whDef"), this.get_TrxName());
            BigDecimal maxAmt = (BigDecimal)mwhDefinition.get_Value("MaxAmt");
            if (mwhDefinition.get_ValueAsInt("C_Currency_ID") > 0 && maxAmt.compareTo(Env.ZERO) > 0) {
                Calendar c = Calendar.getInstance();
                c.setTime(this.getDateDoc());
                c.add(2, -1);
                Timestamp lastMonth = new Timestamp(c.getTimeInMillis());
                BigDecimal minAmtAllowed = MConversionRate.convert(this.getCtx(), maxAmt, mwhDefinition.get_ValueAsInt("C_Currency_ID"), 142, lastMonth, 115, this.getAD_Client_ID(), Env.getAD_Org_ID(this.getCtx()));
                List allWh = new Query(this.getCtx(), "WH_Withholding", "AD_Org_ID=? AND C_BPartner_ID=? AND WH_Definition_ID=? AND DocStatus IN ('CO', 'CL')", this.get_TrxName()).setParameters(mwhWGroupedParams.get("org"), mwhWGroupedParams.get("cbp"), mwhWGroupedParams.get("whDef")).list();
                BigDecimal groupedAmt = allWh.stream().map(mwhWithholding -> {
                    int currentBaseCur_id = mwhWithholding.getSourceInvoice().getC_Currency_ID();
                    BigDecimal currentBaseAmt = mwhWithholding.getA_Base_Amount();
                    Timestamp dateInvoiced = mwhWithholding.getSourceInvoice().getDateInvoiced();
                    BigDecimal convertedAmt = MConversionRate.convert(this.getCtx(), currentBaseAmt, currentBaseCur_id, 142, dateInvoiced, 114, this.getAD_Client_ID(), Env.getAD_Org_ID(this.getCtx()));
                    return convertedAmt;
                }).reduce(Env.ZERO, BigDecimal::add);
                needsToBeGenerated = minAmtAllowed.compareTo(groupedAmt) <= 0;
            } else {
                needsToBeGenerated = true;
            }
            if (needsToBeGenerated) {
                for (MWHWithholding mwhWithholding2 : mwhWithholdingsGrouped) {
                    this.generateWHDoc(mwhWithholding2);
                }
            }
        });
        this.processWHDoc();
        return "@OK@";
    }

    private void generateWHDoc(MWHWithholding withholding) {
        MInvoice whDoc;
        if (!withholding.isProcessed() || withholding.get_ValueAsBoolean("IsSimulation")) {
            return;
        }
        if (withholding.getC_Invoice_ID() > 0 && (whDoc = (MInvoice)withholding.getC_Invoice()) != null && (whDoc.getDocStatus().equals("CO") || whDoc.getDocStatus().equals("CL") || whDoc.getDocStatus().equals("IP") || whDoc.getDocStatus().equals("IN"))) {
            this.addLog("@DocumentNo@ : " + whDoc.getDocumentNo() + " | @IsGenerated@ | @DocStatus@ : " + whDoc.getDocStatusName());
            return;
        }
        AtomicReference invoiceTo = new AtomicReference();
        AtomicReference invoiceLineTo = new AtomicReference();
        AtomicReference<Integer> Curr_WH_Definition_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_WH_Setting_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_C_BPartner_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_C_DocType_ID = new AtomicReference<Integer>();
        AtomicReference<Integer> Curr_AD_Org_ID = new AtomicReference<Integer>();
        if (withholding.get_ID() > 0) {
            Curr_WH_Definition_ID.set(withholding.getWH_Definition_ID());
            Curr_WH_Setting_ID.set(withholding.getWH_Setting_ID());
            Curr_C_BPartner_ID.set(withholding.getC_BPartner_ID());
            Curr_C_DocType_ID.set(withholding.getWHDocType());
            Curr_AD_Org_ID.set(withholding.getAD_Org_ID());
            invoiceTo.set(Optional.empty());
            invoiceLineTo.set(Optional.empty());
            MWHDefinition whDefinition = (MWHDefinition)withholding.getWH_Definition();
            MWHSetting whSetting = (MWHSetting)withholding.getWH_Setting();
            MInvoice invoiceFrom = (MInvoice)withholding.getSourceInvoice();
            Optional<Withholding> withholldingDoc = Optional.empty();
            if (!withholding.isManual()) {
                withholldingDoc = this.withholdingDocList.stream().filter(wh -> wh.getC_BPartner_ID() == ((Integer)Curr_C_BPartner_ID.get()).intValue() && wh.getAD_Org_ID() == ((Integer)Curr_AD_Org_ID.get()).intValue() && wh.getWH_Definition_ID() == ((Integer)Curr_WH_Definition_ID.get()).intValue() && wh.getWH_Setting_ID() == ((Integer)Curr_WH_Setting_ID.get()).intValue() && wh.getC_DocType_ID() == ((Integer)Curr_C_DocType_ID.get()).intValue()).findFirst();
            }
            if (!withholldingDoc.isPresent()) {
                withholldingDoc = Optional.ofNullable(new Withholding(withholding.getAD_Org_ID(), withholding.getWH_Definition_ID(), withholding.getWH_Setting_ID(), withholding.getC_BPartner_ID(), withholding.getWHDocType(), this));
            }
            withholldingDoc.ifPresent(whDocument -> {
                if (!whDocument.getInvoice().isPresent()) {
                    MInvoice invoice2 = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                    invoiceTo.set(Optional.ofNullable(invoice2));
                    whDocument.setInvoice(invoice2);
                } else {
                    invoiceTo.set(whDocument.getInvoice());
                }
                ((Optional)invoiceTo.get()).ifPresent(invoice -> {
                    if (invoice.get_ID() == 0) {
                        if (withholding.isManual()) {
                            invoice.setDocumentNo(withholding.getDocumentNo());
                        }
                        invoice.setAD_Org_ID(invoiceFrom.getAD_Org_ID());
                        invoice.setC_BPartner_ID(invoiceFrom.getC_BPartner_ID());
                        invoice.setC_BPartner_Location_ID(invoiceFrom.getC_BPartner_Location_ID());
                        invoice.setM_PriceList_ID(invoiceFrom.getM_PriceList_ID());
                        invoice.setIsSOTrx(invoiceFrom.isSOTrx());
                        invoice.setDateInvoiced(this.getParameterAsTimestamp("DateDoc"));
                        invoice.setDateAcct(this.getParameterAsTimestamp("DateDoc"));
                        int C_DocType_ID = (Integer)Curr_C_DocType_ID.get();
                        if (C_DocType_ID <= 0) {
                            throw new AdempiereException("@NotFound@ @WithholdingDebitDocType_ID@");
                        }
                        invoice.setC_DocTypeTarget_ID(C_DocType_ID);
                        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
                        invoice.setC_Currency_ID(142);
                        invoice.saveEx();
                    }
                    invoiceLineTo.set(Optional.ofNullable(new MInvoiceLine((MInvoice)invoice)));
                    ((Optional)invoiceLineTo.get()).ifPresent(invoiceLine -> {
                        if (whSetting.getC_Charge_ID() > 0) {
                            invoiceLine.setC_Charge_ID(whSetting.getC_Charge_ID());
                        } else if (whDefinition.getC_Charge_ID() > 0) {
                            invoiceLine.setC_Charge_ID(whDefinition.getC_Charge_ID());
                        } else {
                            throw new AdempiereException("@NotFound@ @C_Charge_ID@");
                        }
                        invoiceLine.setQty(Env.ONE);
                        int currentBaseCur_id = invoiceFrom.getC_Currency_ID();
                        Timestamp dateInvoiced = invoiceFrom.getDateInvoiced();
                        BigDecimal convertedAmt = MConversionRate.convert(this.getCtx(), withholding.getWithholdingAmt(), currentBaseCur_id, 142, dateInvoiced, invoiceFrom.getC_ConversionType_ID(), this.getAD_Client_ID(), Env.getAD_Org_ID(this.getCtx()));
                        invoiceLine.setPrice(convertedAmt);
                        BigDecimal convertedABaseAmt = MConversionRate.convert(this.getCtx(), withholding.getA_Base_Amount(), currentBaseCur_id, 142, dateInvoiced, invoiceFrom.getC_ConversionType_ID(), this.getAD_Client_ID(), Env.getAD_Org_ID(this.getCtx()));
                        invoiceLine.set_ValueOfColumn("RRAmt", (Object)Optional.ofNullable(convertedABaseAmt).orElse(Env.ZERO).abs());
                        invoiceLine.set_ValueOfColumn("WH_Definition_ID", (Object)whDefinition.get_ID());
                        try {
                            invoiceLine.setC_Tax_ID(MTax.getForTaxIndicator(this.getCtx(), "1", this.get_TrxName()).get_ID());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        invoiceLine.saveEx();
                        withholding.setC_Invoice_ID(invoiceLine.getC_Invoice_ID());
                        withholding.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
                        withholding.saveEx();
                        MAllocInvoice alloc = MAllocInvoice.getByInvoice(this.getCtx(), invoiceFrom.get_ID(), invoice.get_ID(), this.get_TrxName());
                        if (alloc == null) {
                            alloc = new MAllocInvoice(this.getCtx(), 0, this.get_TrxName());
                            alloc.setC_Invoice_ID(invoice.get_ID());
                            alloc.setC_AllocInvoice_ID(invoiceFrom.get_ID());
                            BigDecimal amtInvOpen = DB.getSQLValueBDEx(this.get_TrxName(), "select invoiceopen(" + invoiceFrom.get_ID() + ", null)", new Object[0]);
                            if (invoiceFrom.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                                amtInvOpen = MConversionRate.convert(this.getCtx(), amtInvOpen, invoiceFrom.getC_Currency_ID(), invoice.getC_Currency_ID(), dateInvoiced, invoiceFrom.getC_ConversionType_ID(), this.getAD_Client_ID(), Env.getAD_Org_ID(this.getCtx()));
                            }
                            alloc.setOpenAmt(amtInvOpen);
                            alloc.setAmtToAllocate(convertedAmt);
                        } else {
                            alloc.setAmtToAllocate(alloc.getAmtToAllocate().add(convertedAmt));
                        }
                        alloc.setFromProcess(true);
                        alloc.saveEx();
                    });
                    if (whDocument.getInvoice() == null) {
                        whDocument.setInvoice((MInvoice)invoice);
                    }
                    whDocument.addWithHolding(withholding);
                });
                this.withholdingDocList.add((Withholding)whDocument);
            });
        }
    }

    private void processWHDoc() {
        this.withholdingDocList.stream().forEach(withholding -> withholding.process(this.getDocAction()));
    }
}

