/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.ArrayList;
import java.util.Optional;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.spin.model.MWHWithholding;

class Withholding {
    private int AD_Org_ID = 0;
    private int WH_Definition_ID = 0;
    private int WH_Setting_ID = 0;
    private int C_BPartner_ID = 0;
    private int C_DocType_ID = 0;
    private MInvoice invoice = null;
    private MInvoiceLine invoiceLine = null;
    private ArrayList<MWHWithholding> withholding = new ArrayList();
    private SvrProcess process = null;

    public Withholding(int AD_Org_ID, int WH_Definition_ID, int WH_Setting_ID, int C_BPartner_ID, int C_DocType_ID, SvrProcess process) {
        this.AD_Org_ID = AD_Org_ID;
        this.WH_Definition_ID = WH_Definition_ID;
        this.WH_Setting_ID = WH_Setting_ID;
        this.C_BPartner_ID = C_BPartner_ID;
        this.C_DocType_ID = C_DocType_ID;
        this.process = process;
    }

    public int getAD_Org_ID() {
        return this.AD_Org_ID;
    }

    public int getWH_Definition_ID() {
        return this.WH_Definition_ID;
    }

    public int getWH_Setting_ID() {
        return this.WH_Setting_ID;
    }

    public int getC_BPartner_ID() {
        return this.C_BPartner_ID;
    }

    public Optional<MInvoice> getInvoice() {
        return Optional.ofNullable(this.invoice);
    }

    public ArrayList<MWHWithholding> getWithholding() {
        return this.withholding;
    }

    public void setInvoice(MInvoice invoice) {
        this.invoice = invoice;
    }

    public MInvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(MInvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public void addWithHolding(MWHWithholding withholding) {
        this.withholding.add(withholding);
    }

    public void process(String docAction) {
        int loginedOrg = Env.getAD_Org_ID(this.invoice.getCtx());
        if (this.invoice != null && !this.invoice.isProcessed()) {
            if (loginedOrg == this.invoice.getAD_Org_ID()) {
                try {
                    Trx.run(this.invoice.get_TrxName(), trxLocal -> {
                        this.invoice.set_TrxName(trxLocal);
                        this.invoice.processIt(docAction);
                        this.invoice.saveEx();
                        if (this.process != null) {
                            this.process.addLog("@DocumentNo@ : " + this.invoice.getDocumentNo());
                        }
                    });
                }
                catch (Exception e) {
                    this.process.addLog("@Error@ @DocumentNo@ : " + this.invoice.getDocumentNo() + " - " + e.getMessage());
                }
            } else {
                this.process.addLog("@Error@ @DocumentNo@ " + this.invoice.getDocumentNo() + " - No pertenece a la organizaci\u00f3n con la que se inici\u00f3 sesi\u00f3n");
            }
        }
    }

    public int getC_DocType_ID() {
        return this.C_DocType_ID;
    }

    public void setC_DocType_ID(int c_DocType_ID) {
        this.C_DocType_ID = c_DocType_ID;
    }
}

