/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRevenueRecognition;
import org.compiere.model.MRevenueRecognitionPlan;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.javatuples.Pair;
import org.openup.core.model.MProjectProgressLog;
import org.openup.core.utils.Utils;
import org.spin.process.RevenueRecognitionRunAbstract;

public class RevenueRecognitionRun
extends RevenueRecognitionRunAbstract {
    @Override
    protected String doIt() throws Exception {
        long startTime = System.currentTimeMillis();
        Timestamp processDate = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(this.getDateDoc().toString()).getTime());
        String sqlSelectFrom = "SELECT c.S_Contract_ID, c.DocumentNo, o.C_Project_ID, p.Value, plan.C_RevenueRecognition_Plan_ID, o.C_Order_ID\nFROM C_RevenueRecognition_Plan plan\nJOIN C_OrderLine ol ON plan.C_OrderLine_ID=ol.C_OrderLine_ID\nJOIN C_Order o ON ol.C_Order_ID=o.C_Order_ID\nLEFT JOIN C_Project p ON o.C_Project_ID=p.C_Project_ID\nLEFT JOIN S_Contract c ON p.S_Contract_ID=c.S_Contract_ID\n";
        Object sqlWhere = "WHERE o.DocStatus IN ('CO', 'CL') AND p.Processed=?\n";
        ArrayList<Comparable<Boolean>> params = new ArrayList<Comparable<Boolean>>();
        params.add(Boolean.valueOf(false));
        if (this.getRevenueRecognitionId() > 0) {
            sqlWhere = (String)sqlWhere + " AND C_RevenueRecognition_ID=? ";
            params.add(Integer.valueOf(this.getRevenueRecognitionId()));
        }
        if (this.getContractId() > 0) {
            sqlWhere = (String)sqlWhere + " AND o.S_Contract_ID=?\n";
            params.add(Integer.valueOf(this.getContractId()));
        }
        if (this.getProjectId() > 0) {
            sqlWhere = (String)sqlWhere + " AND o.C_Project_ID=?\n";
            params.add(Integer.valueOf(this.getProjectId()));
        }
        if (this.getOrgId() > 0) {
            sqlWhere = (String)sqlWhere + " AND p.AD_Org_ID=?\n";
            params.add(Integer.valueOf(this.getOrgId()));
        }
        if (!this.isForce()) {
            sqlWhere = (String)sqlWhere + " AND (plan.LastRun IS NULL OR plan.LastRun < ?)\n";
            params.add(new Timestamp(processDate.getTime()));
        }
        ArrayList revenueRecognitionPlanIds = new ArrayList();
        String sql = sqlSelectFrom + (String)sqlWhere + "\n ORDER BY o.C_Project_ID DESC";
        Trx.run(trxName -> {
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                Object rrps = null;
                int currentProject = -2;
                pstmt = DB.prepareStatement(sql, trxName);
                DB.setParameters((PreparedStatement)pstmt, params);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    Dto dto = new Dto();
                    dto.contractId = rs.getInt("S_Contract_ID");
                    dto.contractDocumentNo = rs.getBigDecimal("DocumentNo");
                    dto.projectId = rs.getInt("C_Project_ID");
                    dto.projectValue = rs.getString("Value");
                    dto.planId = rs.getInt("C_RevenueRecognition_Plan_ID");
                    dto.orderId = rs.getInt("C_Order_ID");
                    revenueRecognitionPlanIds.add(dto);
                }
            }
            catch (Exception e) {
                try {
                    this.addLog("@C_RevenueRecognition_Plan@ @not.found@");
                    throw new AdempiereException(e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
        });
        AtomicInteger processedProjects = new AtomicInteger();
        AtomicLong runCreated = new AtomicLong();
        long totalContracts = revenueRecognitionPlanIds.stream().map(dto -> dto.contractId).distinct().count();
        long totalProjects = revenueRecognitionPlanIds.stream().map(dto -> dto.projectId).distinct().count();
        long totalPlans = revenueRecognitionPlanIds.stream().map(dto -> dto.planId).distinct().count();
        this.addLog("@Count@ - @S_Contract_ID@ " + totalContracts + " - @C_Project_ID@ " + totalProjects + " - @C_RevenueRecognition_Plan_ID@ " + totalPlans);
        revenueRecognitionPlanIds.stream().collect(Collectors.groupingBy(dto -> new Pair<Integer, BigDecimal>(Integer.valueOf(dto.contractId), dto.contractDocumentNo))).forEach((contractPair, rrpDtosByContract) -> {
            long totalProjectsByContract = rrpDtosByContract.stream().map(dto -> dto.projectId).distinct().count();
            long totalOrderByContract = rrpDtosByContract.stream().map(dto -> dto.orderId).distinct().count();
            long totalPlansByContract = rrpDtosByContract.stream().map(dto -> dto.planId).distinct().count();
            this.addLog("@S_Contract_ID@ " + contractPair.getValue1() + " - #@C_Project_ID@ " + totalProjectsByContract + " - #@C_Order_ID@ " + totalOrderByContract + " - #@C_RevenueRecognition_Plan_ID@ " + totalPlansByContract);
            rrpDtosByContract.stream().collect(Collectors.groupingBy(dto -> new Pair<Integer, String>(Integer.valueOf(dto.projectId), dto.projectValue))).forEach((projectPair, rrpDtosByProject) -> {
                long totalOrderByProject = rrpDtosByProject.stream().map(dto -> dto.orderId).distinct().count();
                long totalPlansByProject = rrpDtosByProject.stream().map(dto -> dto.planId).distinct().count();
                String msgProjectLog = " | @C_Project_ID@ " + projectPair.getValue1() + " - @C_Order_ID@ " + totalOrderByProject + " - @C_RevenueRecognition_Plan_ID@ " + totalPlansByProject + " | ";
                try {
                    Trx.run(currentTrxName -> rrpDtosByProject.forEach(rrpDto -> {
                        MRevenueRecognitionPlan revenuePlan = new MRevenueRecognitionPlan(this.getCtx(), rrpDto.planId, currentTrxName);
                        MOrderLine orderLine = new MOrderLine(this.getCtx(), revenuePlan.get_ValueAsInt("C_OrderLine_ID"), currentTrxName);
                        MOrder order = orderLine.getParent();
                        boolean doRevenueRecognitionRun = true;
                        try {
                            doRevenueRecognitionRun = !order.getC_Project().isProcessed();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (doRevenueRecognitionRun) {
                            this.createReversal(revenuePlan, processDate, currentTrxName);
                            if (order.getC_Project_ID() != 0) {
                                new Query(this.getCtx(), "C_ProjectProgressLog", "C_Project_ID = ?", currentTrxName).setParameters(order.getC_Project_ID()).list().forEach(projectProgressLog -> {
                                    MRevenueRecognitionRun revenueRun = new MRevenueRecognitionRun(this.getCtx(), 0, currentTrxName);
                                    revenueRun.setAD_Org_ID(order.getAD_Org_ID());
                                    revenueRun.setC_RevenueRecognition_Plan_ID(revenuePlan.getC_RevenueRecognition_Plan_ID());
                                    BigDecimal recognizedAmount = revenuePlan.getTotalAmt();
                                    String progressType = "";
                                    try {
                                        progressType = ((MRevenueRecognition)revenuePlan.getC_RevenueRecognition()).get_ValueAsString("RevenueRecognitionType");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    BigDecimal progressPercentage = null;
                                    MProjectProgressLog mProjectProgressLog = null;
                                    if ("L".equalsIgnoreCase(progressType)) {
                                        mProjectProgressLog = (MProjectProgressLog)new Query(this.getCtx(), "C_ProjectProgressLog", "C_Project_ID=?", this.getTableName()).setParameters(order.getC_Project_ID()).first();
                                        progressPercentage = (BigDecimal)mProjectProgressLog.get_Value("ProgressPercentWO");
                                    } else if ("P".equalsIgnoreCase(progressType)) {
                                        String sqlQuery = "EXISTS (\n\tSELECT 1\n\tFROM C_InvoiceLine il\n\tWHERE C_Invoice.C_Invoice_ID=il.C_Invoice_ID\n\tAND il.C_OrderLine_ID = ?\n)\nAND IsPaid='Y'";
                                        boolean existsPaidInvoice = new Query(this.getCtx(), "C_Invoice", sqlQuery, this.get_TrxName()).setParameters(orderLine.get_ID()).match();
                                        BigDecimal bigDecimal = progressPercentage = existsPaidInvoice ? Env.ONEHUNDRED : Env.ZERO;
                                    }
                                    if (recognizedAmount != null && progressPercentage != null) {
                                        BigDecimal currencyRate;
                                        recognizedAmount = recognizedAmount.multiply(progressPercentage);
                                        recognizedAmount = recognizedAmount.divide(Env.ONEHUNDRED, MathContext.DECIMAL128);
                                        revenueRun.setRecognizedAmt(recognizedAmount);
                                        if (mProjectProgressLog != null) {
                                            revenueRun.set_ValueOfColumn("C_ProjectProgressLog_ID", (Object)projectProgressLog.get_ID());
                                        }
                                        revenueRun.set_ValueOfColumn("DateDoc", (Object)processDate);
                                        if (revenuePlan.get_ValueAsBoolean("IsInvoiced")) {
                                            currencyRate = (BigDecimal)revenuePlan.get_Value("CurrencyRate");
                                        } else {
                                            currencyRate = MConversionRate.getRate(order.getC_Currency_ID(), Utils.getAcctCurrency(order.getCtx()), processDate, order.getC_ConversionType_ID(), this.getAD_Client_ID(), order.getAD_Org_ID());
                                            if (currencyRate == null || currencyRate.compareTo(Env.ZERO) == 0) {
                                                throw new AdempiereException("@CurrencyConversion@ @not.found@: @C_Order_ID@ " + order.getDocumentNo() + " - @DateDoc@ " + processDate);
                                            }
                                        }
                                        revenueRun.set_ValueOfColumn("CurrencyRate", (Object)currencyRate);
                                        BigDecimal recognizedAmtAcct = recognizedAmount.multiply(currencyRate);
                                        revenueRun.set_ValueOfColumn("RecognizedAmtAcct", (Object)recognizedAmtAcct);
                                        revenueRun.saveEx();
                                        runCreated.addAndGet(1L);
                                    }
                                });
                                revenuePlan.set_ValueOfColumn("LastRun", (Object)processDate);
                                revenuePlan.updateRecognizedAmount();
                            }
                        }
                    }));
                    this.addLog("OK" + msgProjectLog + "@ProcessOK@");
                    processedProjects.addAndGet(1);
                }
                catch (Exception e) {
                    this.addLog("@Error@" + msgProjectLog + e.getMessage());
                    e.printStackTrace();
                }
            });
        });
        long durationTime = System.currentTimeMillis() - startTime;
        return "@C_RevenueRecognition_Run_ID@ @Created@: " + runCreated + " - @C_Project_ID@ " + processedProjects + "/" + totalProjects + " - " + DurationFormatUtils.formatDuration(durationTime, "HH:mm:ss");
    }

    private void createReversal(MRevenueRecognitionPlan revenuePlan, Timestamp processDate, String trxName) {
        MRevenueRecognitionRun revenueRun = (MRevenueRecognitionRun)new Query(this.getCtx(), "C_RevenueRecognition_Run", "C_RevenueRecognition_Plan_ID = ?", trxName).setParameters(revenuePlan.getC_RevenueRecognition_Plan_ID()).setOrderBy("C_RevenueRecognition_Run.C_RevenueRecognition_Run_ID DESC").first();
        if (revenueRun != null && revenueRun.get_ID() > 0) {
            MRevenueRecognitionRun reverse = new MRevenueRecognitionRun(this.getCtx(), 0, trxName);
            PO.copyValues(revenueRun, reverse);
            reverse.setGL_Journal_ID(-1);
            reverse.setAD_Org_ID(revenueRun.getAD_Org_ID());
            reverse.setGL_JournalBatch_ID(-1);
            reverse.setC_RevenueRecognition_Batch_ID(-1);
            reverse.setRecognizedAmt(reverse.getRecognizedAmt().negate());
            reverse.setDateDoc(processDate);
            try {
                reverse.set_ValueOfColumn("CurrencyRate", revenueRun.get_Value("CurrencyRate"));
                reverse.set_ValueOfColumn("RecognizedAmtAcct", (Object)((BigDecimal)revenueRun.get_Value("RecognizedAmtAcct")).negate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            reverse.saveEx();
        }
    }

    private class Dto {
        private int contractId;
        private BigDecimal contractDocumentNo;
        private int projectId;
        private String projectValue;
        private int planId;
        private int orderId;

        private Dto() {
        }
    }
}

