/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_C_RfQLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.util.Util;
import org.spin.process.RFQCreateFromRequisitionAbstract;

public class RFQCreateFromRequisition
extends RFQCreateFromRequisitionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger created = new AtomicInteger();
        AtomicInteger line = new AtomicInteger(10);
        MRfQ requestForQuotation = new MRfQ(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        Optional<MRfQLine> lineToEvaluate = Arrays.asList(requestForQuotation.getLines()).stream().sorted(Comparator.comparing(X_C_RfQLine::getLine).reversed()).findFirst();
        if (lineToEvaluate.isPresent()) {
            line.set(lineToEvaluate.get().getLine() + 10);
        }
        this.getSelectionKeys().forEach(key -> {
            MRequisitionLine requisitionLine = new MRequisitionLine(this.getCtx(), this.getSelectionAsInt((int)key, "RL_M_RequisitionLine_ID"), this.get_TrxName());
            MRfQLine requiestForQuotationLine = new MRfQLine(requestForQuotation);
            requiestForQuotationLine.setLine(line.getAndAdd(10));
            requiestForQuotationLine.setM_Product_ID(requisitionLine.getM_Product_ID());
            if (!Util.isEmpty(requisitionLine.getDescription())) {
                requiestForQuotationLine.setDescription(requisitionLine.getDescription());
            }
            if (requisitionLine.getM_AttributeSetInstance_ID() != 0) {
                requiestForQuotationLine.setM_AttributeSetInstance_ID(requisitionLine.getM_AttributeSetInstance_ID());
            }
            requiestForQuotationLine.saveEx();
            MRfQLineQty requestForQuotationLineQuantity = new MRfQLineQty(requiestForQuotationLine);
            requestForQuotationLineQuantity.setQty(requisitionLine.getQty());
            requestForQuotationLineQuantity.setC_UOM_ID(requisitionLine.getC_UOM_ID());
            requestForQuotationLineQuantity.setIsPurchaseQty(true);
            requestForQuotationLineQuantity.saveEx(this.get_TrxName());
            requisitionLine.setC_RfQLine_ID(requestForQuotationLineQuantity.getC_RfQLine_ID());
            requisitionLine.saveEx();
        });
        return "@Created@ " + created;
    }
}

