/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.util.Env;
import org.spin.process.CreateExpenseReportFromProjectAbstract;

public class CreateExpenseReportFromProject
extends CreateExpenseReportFromProjectAbstract {
    private MTimeExpense expenseReport = null;
    private StringBuffer result = new StringBuffer();
    private int created = 0;

    @Override
    protected String doIt() throws Exception {
        for (Integer key : this.getSelectionKeys()) {
            BigDecimal priceActual;
            int orderLineId = this.getSelectionAsInt(key, "SOL_C_OrderLine_ID");
            int linkOrderLineId = this.getSelectionAsInt(key, "SOL_Link_OrderLine_ID");
            int expenseProductId = this.getSelectionAsInt(key, "SOL_M_Product_ID");
            boolean isReleaseOrderBalance = this.getSelectionAsBoolean(key, "SOL_IsReleaseOrderBalance");
            BigDecimal qty = this.getSelectionAsBigDecimal(key, "SOL_QtyToDeliver");
            MOrderLine orderLine = new MOrderLine(this.getCtx(), orderLineId, this.get_TrxName());
            if (!orderLine.getC_Order().isSOTrx()) {
                linkOrderLineId = this.getSelectionAsInt(key, "SOL_C_OrderLine_ID");
                orderLineId = this.getSelectionAsInt(key, "SOL_Link_OrderLine_ID");
                orderLine = orderLineId > 0 ? new MOrderLine(this.getCtx(), orderLineId, this.get_TrxName()) : new MOrderLine(this.getCtx(), linkOrderLineId, this.get_TrxName());
            }
            if (isReleaseOrderBalance) {
                BigDecimal qtyDelivered = orderLine.getQtyDelivered();
                BigDecimal qtyOrdered = orderLine.getQtyOrdered();
                if (qtyDelivered == null) {
                    qtyDelivered = Env.ZERO;
                }
                BigDecimal qtyAvailable = qtyOrdered.subtract(qtyDelivered);
                orderLine.set_ValueOfColumn("ReleasedQty", (Object)qtyAvailable.subtract(qty));
                orderLine.saveEx();
            }
            if (qty.compareTo(Env.ZERO) == 0) {
                orderLine.setQtyLostSales(orderLine.getQtyReserved());
                orderLine.setQtyReserved(Env.ZERO);
                orderLine.saveEx();
            }
            MOrder order = orderLine.getParent();
            if (this.expenseReport == null) {
                this.processDocument();
                this.createExpenseReport(order);
            }
            if ((priceActual = this.getSelectionAsBigDecimal(key, "SOL_PriceActual")) == null || priceActual == Env.ZERO) {
                priceActual = orderLine.getPriceActual();
            }
            MTimeExpenseLine expenseLine = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
            expenseLine.setS_TimeExpense_ID(this.expenseReport.getS_TimeExpense_ID());
            expenseLine.setDateExpense(this.getDateReport());
            expenseLine.setIsTimeReport(false);
            expenseLine.setIsInvoiced(false);
            expenseLine.setC_Currency_ID(this.expenseReport.getC_Currency_ID());
            expenseLine.setM_Product_ID(expenseProductId);
            expenseLine.setQty(qty);
            expenseLine.setExpenseAmt(priceActual);
            if (order.get_ValueAsInt("S_Contract_ID") > 0) {
                expenseLine.set_ValueOfColumn("S_ContractLine_ID", (Object)order.get_ValueAsInt("S_Contract_ID"));
            }
            if (order.getC_Project_ID() > 0) {
                expenseLine.setC_Project_ID(order.getC_Project_ID());
            }
            expenseLine.setC_OrderLine_ID(orderLineId);
            if (orderLine.getC_ProjectPhase_ID() > 0) {
                expenseLine.setC_ProjectPhase_ID(orderLine.getC_ProjectPhase_ID());
            }
            if (orderLine.getC_ProjectTask_ID() > 0) {
                expenseLine.setC_ProjectTask_ID(orderLine.getC_ProjectTask_ID());
            }
            if (linkOrderLineId > 0) {
                MOrderLine linkOrderLine = new MOrderLine(this.getCtx(), linkOrderLineId, this.get_TrxName());
                MOrder linkOrder = linkOrderLine.getParent();
                if (!linkOrder.getDocStatus().equals("CO")) {
                    throw new AdempiereException("@Link_OrderLine_ID@ @InvoiceCreateDocNotCompleted@");
                }
                if (isReleaseOrderBalance) {
                    BigDecimal qtyDelivered = linkOrderLine.getQtyDelivered();
                    BigDecimal qtyOrdered = linkOrderLine.getQtyOrdered();
                    if (qtyDelivered == null) {
                        qtyDelivered = Env.ZERO;
                    }
                    BigDecimal qtyAvailable = qtyOrdered.subtract(qtyDelivered);
                    linkOrderLine.set_ValueOfColumn("ReleasedQty", (Object)qtyAvailable.subtract(qty));
                    linkOrderLine.saveEx();
                }
                expenseLine.set_ValueOfColumn("Link_OrderLine_ID", (Object)linkOrderLineId);
            }
            expenseLine.saveEx();
        }
        this.processDocument();
        return this.getDocumentResult();
    }

    private void processDocument() {
        if (this.expenseReport == null) {
            return;
        }
        if (!this.expenseReport.processIt(this.getDocAction())) {
            throw new AdempiereException("@Error@ " + this.expenseReport.getProcessMsg());
        }
        this.expenseReport.saveEx();
        this.addDocumentResult(this.expenseReport.getDocumentNo());
        this.addLog(this.expenseReport.getS_TimeExpense_ID(), null, null, this.expenseReport.toString());
    }

    private void createExpenseReport(MOrder order) {
        this.expenseReport = new MTimeExpense(this.getCtx(), 0, this.get_TrxName());
        this.expenseReport.setDocStatus("DR");
        this.expenseReport.setDocAction("CO");
        this.expenseReport.setC_BPartner_ID(order.getC_BPartner_ID());
        this.expenseReport.set_ValueOfColumn("Bill_BPartner_ID", (Object)order.getBill_BPartner_ID());
        this.expenseReport.setDateReport(this.getDateReport());
        this.expenseReport.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.expenseReport.setM_PriceList_ID(order.getM_PriceList_ID());
        if (order.get_ValueAsInt("S_Contract_ID") > 0) {
            this.expenseReport.set_ValueOfColumn("S_Contract_ID", (Object)order.get_ValueAsInt("S_Contract_ID"));
        }
        this.expenseReport.set_ValueOfColumn("IsNotGenerateReceipt", (Object)this.getIsNotGenerateReceipt());
        this.expenseReport.set_ValueOfColumn("IsNotGenerateDelivery", (Object)this.getIsNotGenerateDelivery());
        this.expenseReport.saveEx();
    }

    private void addDocumentResult(String documentNo) {
        ++this.created;
        if (this.result.length() > 0) {
            this.result.append(", ");
        }
        this.result.append(documentNo);
    }

    private String getDocumentResult() {
        String returnMessage = "@Created@: " + this.created;
        if (this.result.length() > 0) {
            returnMessage = "@Created@: " + this.created + " [" + this.result + "]";
        }
        return returnMessage;
    }
}

