/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import com.eevolution.model.I_S_Contract;
import com.eevolution.model.MSContract;
import com.eevolution.model.X_S_Contract;
import java.util.ArrayList;
import org.adempiere.core.domains.models.I_C_Project;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MDocType;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.spin.process.CreateCommissionFromContractAbstract;

public class CreateCommissionFromContract
extends CreateCommissionFromContractAbstract {
    private StringBuffer result = new StringBuffer();
    private int created = 0;

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() <= 0) {
            this.generateCommissionForAll();
        } else if (this.getTable_ID() == I_S_Contract.Table_ID) {
            this.generateCommissionForContract(new MSContract(this.getCtx(), this.getRecord_ID(), this.get_TrxName()));
        } else if (this.getTable_ID() == I_C_Project.Table_ID) {
            this.generateCommissionForProject(new MProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName()));
        }
        return this.getDocumentResult();
    }

    private void generateCommissionForAll() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        String whereClause = "DocStatus = ?";
        parameters.add("CO");
        if (this.getBPartnerId() > 0) {
            whereClause = " AND C_BPartner_ID = ?";
            parameters.add(this.getBPartnerId());
        }
        new Query(this.getCtx(), "S_Contract", whereClause, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("DateDoc").list().forEach(contract -> this.generateCommissionForContract((X_S_Contract)contract));
    }

    private void generateCommissionForContract(X_S_Contract contract) {
        new Query(this.getCtx(), "C_Project", "S_Contract_ID = ?", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(contract.getS_Contract_ID()).setOrderBy("DateStart").list().forEach(project -> this.generateCommissionForProject((MProject)project));
    }

    private void generateCommissionForProject(MProject project) {
        X_S_Contract contract = new X_S_Contract(this.getCtx(), project.get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
        new Query(this.getCtx(), "C_Commission", "C_CommissionType_ID = ? ", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getCommissionTypeId()).list().forEach(commissionDefinition -> {
            if (this.getDocTypeId() <= 0) {
                this.setDocTypeId(MDocType.getDocType("SOC", project.getAD_Org_ID()));
            }
            MCommissionRun commissionRun = new MCommissionRun((MCommission)commissionDefinition);
            commissionRun.setDateDoc(this.getDateDoc());
            commissionRun.setC_DocType_ID(this.getDocTypeId());
            commissionRun.setDescription(Msg.parseTranslation(this.getCtx(), "@Generate@: @S_Contract_ID@ - " + contract.getDocumentNo() + " @C_Project_ID@: " + project.getValue()));
            commissionRun.setAD_Org_ID(project.getAD_Org_ID());
            commissionRun.set_ValueOfColumn("S_Contract_ID", (Object)contract.getS_Contract_ID());
            commissionRun.set_ValueOfColumn("C_Project_ID", (Object)project.getC_Project_ID());
            commissionRun.set_ValueOfColumn("C_Currency_ID", (Object)project.getC_Currency_ID());
            commissionRun.addFilterValues("S_Contract_ID", contract.getS_Contract_ID());
            commissionRun.addFilterValues("C_Project_ID", project.getC_Project_ID());
            commissionRun.saveEx();
            commissionRun.setDocStatus("DR");
            if (!commissionRun.processIt("CO")) {
                throw new AdempiereException(commissionRun.getProcessMsg());
            }
            this.addDocumentResult(commissionRun.getDocumentNo());
            this.addLog(commissionRun.getC_CommissionRun_ID(), null, null, "@C_Project_ID@: " + project.getValue() + " @C_CommissionRun_ID@: " + commissionRun.getDocumentNo() + " @Created@");
        });
    }

    private void addDocumentResult(String documentNo) {
        ++this.created;
        if (this.result.length() > 0) {
            this.result.append(", ");
        }
        this.result.append(documentNo);
    }

    private String getDocumentResult() {
        String returnMessage = "@Created@: " + this.created;
        if (this.result.length() > 0) {
            returnMessage = "@Created@: " + this.created + " [" + this.result + "]";
        }
        return returnMessage;
    }
}

