/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.process.CreateAPInvoiceFromSalesDropShipmentAbstract;

public class CreateAPInvoiceFromSalesDropShipment
extends CreateAPInvoiceFromSalesDropShipmentAbstract {
    private AtomicInteger created = new AtomicInteger();
    private Map<Integer, MInvoiceLine> invoiceLines = new HashMap<Integer, MInvoiceLine>();
    private MInvoice invoice;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.invoice.isProcessed()) {
            throw new AdempiereException("@C_Invoice_ID@ @Processed@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().forEach(salesInvoiceLineId -> {
            int purchaseOrderLineId = this.getSelectionAsInt((int)salesInvoiceLineId, "POL_C_OrderLine_ID");
            MInvoiceLine salesInvoiceLine = new MInvoiceLine(this.getCtx(), (int)salesInvoiceLineId, this.get_TrxName());
            MOrderLine salesOrderLine = (MOrderLine)salesInvoiceLine.getC_OrderLine();
            MOrderLine purchaseOrderLine = new MOrderLine(this.getCtx(), purchaseOrderLineId, this.get_TrxName());
            String whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID = M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
            MInOutLine[] inOutLines = MInOutLine.getOfOrderLine(Env.getCtx(), purchaseOrderLineId, whereClause, this.get_TrxName());
            this.log.fine("Receipt Lines with OrderLine = #" + inOutLines.length);
            MInOutLine inOutLine = Arrays.stream(inOutLines).filter(ioLine -> ioLine != null && ioLine.getMovementQty().compareTo(salesInvoiceLine.getQtyInvoiced()) == 0).findFirst().orElseGet(() -> inOutLines.length > 0 ? inOutLines[0] : null);
            MInvoiceLine invoiceLine = this.invoiceLines.get(purchaseOrderLineId);
            BigDecimal qtyEntered = Env.ZERO;
            BigDecimal qtyInvoiced = Env.ZERO;
            int uOMId = purchaseOrderLine.getC_UOM_ID();
            if (invoiceLine == null) {
                invoiceLine = new MInvoiceLine(this.invoice);
                if (inOutLine != null) {
                    invoiceLine.setShipLine(inOutLine);
                } else {
                    invoiceLine.setOrderLine(purchaseOrderLine);
                }
                qtyInvoiced = salesInvoiceLine.getQtyInvoiced();
                invoiceLine.addDescription(Msg.parseTranslation(this.getCtx(), "@Created@ @from@ @C_Invoice_ID@ ") + salesInvoiceLine.getParent().getDocumentNo());
                this.invoiceLines.put(purchaseOrderLineId, invoiceLine);
            } else {
                qtyInvoiced = invoiceLine.getQtyInvoiced().add(salesInvoiceLine.getQtyInvoiced());
                invoiceLine.addDescription(salesInvoiceLine.getParent().getDocumentNo());
            }
            MProduct product = MProduct.get(Env.getCtx(), invoiceLine.getM_Product_ID());
            if (uOMId != product.getC_UOM_ID()) {
                MUOM orderUom = MUOM.get(this.getCtx(), uOMId);
                qtyEntered = MUOMConversion.convertProductFrom(this.getCtx(), product.getM_Product_ID(), uOMId, qtyInvoiced);
                if (qtyEntered == null) {
                    qtyEntered = qtyInvoiced;
                }
                qtyEntered = qtyEntered.setScale(orderUom.getStdPrecision(), 5);
            } else {
                qtyEntered = qtyInvoiced;
            }
            invoiceLine.setQtyEntered(qtyEntered);
            invoiceLine.setQtyInvoiced(qtyInvoiced);
            invoiceLine.setC_UOM_ID(uOMId);
            invoiceLine.saveEx();
            salesOrderLine.setLink_OrderLine_ID(purchaseOrderLineId);
            salesOrderLine.addDescription(Msg.parseTranslation(this.getCtx(), "@POReference@ ") + purchaseOrderLine.getParent().getDocumentNo());
            salesOrderLine.saveEx();
            this.created.getAndIncrement();
        });
        return "@Created@ " + this.created;
    }
}

