/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MTab;
import org.compiere.model.MWindow;
import org.compiere.model.MWindowAccess;
import org.compiere.model.Query;
import org.spin.process.CopyWindowFromRoleAbstract;

public class CopyWindowFromRole
extends CopyWindowFromRoleAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@AD_Role_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        AtomicInteger windowAdded = new AtomicInteger(0);
        AtomicInteger processAdded = new AtomicInteger(0);
        this.getSelectionKeys().stream().filter(windowId -> windowId > 0).filter(windowId -> !this.isExistsWindow((int)windowId)).forEach(windowId -> {
            MWindow window = MWindow.get(this.getCtx(), windowId);
            this.addWindowAccess(window, windowAdded);
            if (this.isDependentEntities()) {
                Arrays.asList(window.getTabs(false, this.get_TrxName())).forEach(tab -> this.getDependentProcesses((MTab)tab).stream().filter(process -> !this.isExistsProcess(process.getAD_Process_ID())).forEach(process -> this.addProcessAccess((MProcess)process, processAdded)));
            }
        });
        return "@AD_Window_ID@ @Added@ " + windowAdded.get() + ", @AD_Process_ID@ @Added@ " + processAdded.get();
    }

    private List<MProcess> getDependentProcesses(MTab tab) {
        return new Query(this.getCtx(), "AD_Process", "EXISTS(SELECT 1 FROM AD_Table_Process pa \t\t\t\tWHERE pa.AD_Process_ID = AD_Process.AD_Process_ID \t\t\t\tAND pa.AD_Table_ID = ?) OR EXISTS(SELECT 1 FROM AD_Field f \t\t\t\t\tINNER JOIN AD_Column c ON(c.AD_Column_ID = f.AD_Column_ID) \t\t\t\t\tWHERE c.AD_Process_ID = AD_Process.AD_Process_ID \t\t\t\t\tAND f.AD_Tab_ID = ?)", this.get_TrxName()).setParameters(tab.getAD_Table_ID(), tab.getAD_Tab_ID()).list();
    }

    private void addWindowAccess(MWindow window, AtomicInteger processAdded) {
        Optional.ofNullable(window).ifPresent(windowToAdd -> {
            MWindowAccess access = new MWindowAccess((MWindow)windowToAdd, this.getRecord_ID());
            access.setIsReadWrite(this.isReadWrite());
            access.saveEx();
            processAdded.getAndAdd(1);
        });
    }

    private void addProcessAccess(MProcess process, AtomicInteger processAdded) {
        Optional.ofNullable(process).ifPresent(processToAdd -> {
            MProcessAccess access = new MProcessAccess((MProcess)processToAdd, this.getRecord_ID());
            access.setIsReadWrite(this.isReadWrite());
            access.saveEx();
            processAdded.getAndAdd(1);
        });
    }

    private boolean isExistsWindow(int windowId) {
        return new Query(this.getCtx(), "AD_Window_Access", "AD_Window_ID = ? AND AD_Role_ID= ?", this.get_TrxName()).setParameters(windowId, this.getRecord_ID()).match();
    }

    private boolean isExistsProcess(int windowId) {
        return new Query(this.getCtx(), "AD_Process_Access", "AD_Process_ID = ? AND AD_Role_ID= ?", this.get_TrxName()).setParameters(windowId, this.getRecord_ID()).match();
    }
}

