/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.model.MWHWithholding;
import org.spin.util.WithholdingEngine;

public class Withholding
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(Withholding.class);
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        String error = null;
        if (po.get_TableName().equals("C_Invoice")) {
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isReversal()) {
                error = WithholdingEngine.get().fireDocValidate(invoice, timing);
            }
            if (!(timing != 5 && timing != 6 && timing != 2 || invoice.isReversal())) {
                StringBuffer errorMessage = new StringBuffer();
                List<MWHWithholding> withholdingList = MWHWithholding.getWithholdingFromInvoice(invoice.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName());
                withholdingList.stream().filter(withholding -> withholding.getDocStatus().equals("CO") && withholding.getC_Invoice_ID() != 0).forEach(withholding -> {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(Env.NL);
                    }
                    errorMessage.append("@WH_Withholding_ID@ ").append(withholding.getDocumentNo()).append(" @C_Invoice_ID@ ").append(withholding.getC_Invoice().getDocumentNo());
                });
                if (errorMessage.length() > 0) {
                    throw new AdempiereException("@WithholdingReferenceError@: " + errorMessage);
                }
                withholdingList.stream().filter(withholding -> withholding.getDocStatus().equals("CO")).forEach(withholding -> {
                    if (!withholding.processIt("VO")) {
                        throw new AdempiereException(withholding.getProcessMsg());
                    }
                    withholding.saveEx();
                });
            }
        }
        return error;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        return null;
    }
}

