/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MWHSetting;
import org.spin.model.X_WH_Type;

public class MWHType
extends X_WH_Type {
    private static final long serialVersionUID = -7050562622116465459L;
    private static CCache<Integer, MWHType> typeCacheIds = new CCache("WH_Type", 30);
    private static CCache<String, MWHType> typeCacheValues = new CCache("WH_Type", 30);
    private static CCache<String, List<MWHSetting>> wihholdingSettingCacheValues = new CCache("WH_Type", 30);
    private List<MWHSetting> settingList = null;

    public MWHType(Properties ctx, int WH_Type_ID, String trxName) {
        super(ctx, WH_Type_ID, trxName);
    }

    public MWHType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MWHType getById(Properties ctx, int typeId, String trxName) {
        if (typeId <= 0) {
            return null;
        }
        MWHType type = typeCacheIds.get(typeId);
        if (type != null && type.get_ID() > 0) {
            return type;
        }
        type = (MWHType)new Query(ctx, "WH_Type", "WH_Type_ID=?", trxName).setClient_ID().setParameters(typeId).first();
        if (type != null && type.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + type.getValue();
            typeCacheValues.put(key, type);
            typeCacheIds.put(type.get_ID(), type);
        }
        return type;
    }

    public static MWHType getByValue(Properties ctx, String typeValue, String trxName) {
        int clientId;
        String key;
        MWHType type;
        if (typeValue == null) {
            return null;
        }
        if (typeCacheValues.size() == 0) {
            MWHType.getAll(ctx, true, trxName);
        }
        if ((type = typeCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + typeValue)) != null && type.get_ID() > 0) {
            return type;
        }
        type = (MWHType)new Query(ctx, "WH_Type", "Value=?", trxName).setClient_ID().setParameters(typeValue).first();
        if (type != null && type.get_ID() > 0) {
            typeCacheValues.put(key, type);
            typeCacheIds.put(type.get_ID(), type);
        }
        return type;
    }

    public static List<MWHType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || typeCacheIds.size() > 0) {
            List<MWHType> typeList = new Query(Env.getCtx(), "WH_Type", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + setting.getValue();
                typeCacheIds.put(setting.getWH_Type_ID(), (MWHType)setting);
                typeCacheValues.put(key, (MWHType)setting);
            });
            return typeList;
        }
        List<MWHType> typeList = typeCacheIds.entrySet().stream().map(type -> (MWHType)type.getValue()).collect(Collectors.toList());
        return typeList;
    }

    public List<MWHSetting> getSettingList() {
        if (this.settingList == null) {
            this.settingList = new Query(this.getCtx(), "WH_Setting", "WH_Type_ID = ?", this.get_TrxName()).setParameters(this.getWH_Type_ID()).setOnlyActiveRecords(true).setClient_ID().list();
        }
        return this.settingList;
    }

    private List<MWHSetting> getApplicability(String eventType, int tableId, String eventModelValidator) {
        String key = this.getWH_Type_ID() + "|" + eventType + "|" + tableId + "|" + (Util.isEmpty(eventModelValidator) ? "" : eventModelValidator);
        List<MWHSetting> applicabilityList = wihholdingSettingCacheValues.get(key);
        if (applicabilityList != null) {
            return applicabilityList;
        }
        StringBuffer whereClause = new StringBuffer("WH_Type_ID = ?");
        ArrayList<Object> params = new ArrayList<Object>();
        whereClause.append(" AND ").append("EventType = ?");
        params.add(this.getWH_Type_ID());
        params.add(eventType);
        if (tableId > 0) {
            whereClause.append(" AND ").append("AD_Table_ID = ?");
            params.add(tableId);
        }
        if (tableId > 0) {
            whereClause.append(" AND ").append("EventModelValidator = ?");
            params.add(eventModelValidator);
        }
        applicabilityList = new Query(this.getCtx(), "WH_Setting", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(params).setOnlyActiveRecords(true).list();
        wihholdingSettingCacheValues.put(key, applicabilityList);
        return applicabilityList;
    }

    public List<MWHSetting> getApplicability(String eventType) {
        return this.getApplicability(eventType, 0, null);
    }

    public List<MWHSetting> getApplicability(String tableName, String eventModelValidator) {
        if (Util.isEmpty(tableName)) {
            return new ArrayList<MWHSetting>();
        }
        MTable table = MTable.get(this.getCtx(), tableName);
        return this.getApplicability("E", table.getAD_Table_ID(), eventModelValidator);
    }

    @Override
    public String toString() {
        return "MWHType [getName()=" + this.getName() + ", getValue()=" + this.getValue() + ", getWH_Type_ID()=" + this.getWH_Type_ID() + "]";
    }
}

