/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_AppSupport;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.model.MADAppSupportPara;

public class MADAppSupport
extends X_AD_AppSupport {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADAppSupport> definitionCacheIds = new CCache("AD_AppSupport", 30);
    private static CCache<String, MADAppSupport> definitionCacheValues = new CCache("AD_AppSupport", 30);
    private List<MADAppSupportPara> defaultParametersList;

    public MADAppSupport(Properties ctx, int AD_AppSupport_ID, String trxName) {
        super(ctx, AD_AppSupport_ID, trxName);
    }

    public MADAppSupport(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADAppSupport getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MADAppSupport definition = definitionCacheIds.get(definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADAppSupport)new Query(ctx, "AD_AppSupport", "AD_AppSupport_ID=?", trxName).setParameters(definitionId).first();
        if (definition != null && definition.get_ID() > 0) {
            String key = definition.getValue();
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static MADAppSupport getByApplicationType(Properties ctx, String applicationType, String trxName) {
        String key;
        MADAppSupport definition;
        if (applicationType == null) {
            return null;
        }
        if (definitionCacheValues.size() == 0) {
            MADAppSupport.getAll(ctx, true, trxName);
        }
        if ((definition = definitionCacheValues.get(key = applicationType)) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADAppSupport)new Query(ctx, "AD_AppSupport", "ApplicationType=?", trxName).setParameters(applicationType).setOrderBy("IsDefault, Value").first();
        if (definition != null && definition.get_ID() > 0) {
            definitionCacheValues.put(key, definition);
            definitionCacheIds.put(definition.get_ID(), definition);
        }
        return definition;
    }

    public static List<MADAppSupport> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || definitionCacheIds.size() > 0) {
            List<MADAppSupport> definitionList = new Query(Env.getCtx(), "AD_AppSupport", null, trxName).setOrderBy("Value").list();
            definitionList.stream().forEach(definition -> {
                String key = definition.getValue();
                definitionCacheIds.put(definition.getAD_AppSupport_ID(), (MADAppSupport)definition);
                definitionCacheValues.put(key, (MADAppSupport)definition);
            });
            return definitionList;
        }
        List<MADAppSupport> definitionList = definitionCacheIds.entrySet().stream().map(activity -> (MADAppSupport)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    public List<MADAppSupportPara> getDefaultParametersList() {
        if (this.defaultParametersList == null) {
            this.defaultParametersList = new Query(this.getCtx(), "AD_AppSupport_Para", "AD_AppSupport_ID = ?", this.get_TrxName()).setParameters(this.getAD_AppSupport_ID()).setOnlyActiveRecords(true).list();
        }
        return this.defaultParametersList;
    }

    @Override
    public String toString() {
        return "MADAppSupport [getAD_AppSupport_ID()=" + this.getAD_AppSupport_ID() + ", getClassname()=" + this.getClassname() + ", getName()=" + this.getName() + ", getApplicationType()=" + this.getApplicationType() + ", getValue()=" + this.getValue() + "]";
    }
}

