/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.I_C_BPartner;
import org.adempiere.core.domains.models.I_C_CommissionRun;
import org.adempiere.core.domains.models.I_R_Request;
import org.adempiere.core.domains.models.X_C_CommissionSalesRep;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MCommissionType;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MImage;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MStatus;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MTree;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.OrderPOCreateAbstract;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.process.CommissionOrderCreateAbstract;

public class AgencyValidator
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
        }
        engine.addModelChange("C_Project", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_CommissionLine", this);
        engine.addModelChange("C_ProjectTask", this);
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("R_Request", this);
        engine.addModelChange("C_RfQLineQty", this);
        engine.addModelChange("C_RfQResponse", this);
        engine.addModelChange("AD_Attachment", this);
        engine.addModelChange("R_Request", this);
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("S_TimeExpense", this);
        engine.addDocValidate("S_TimeExpense", this);
        engine.addDocValidate("S_Contract", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_CommissionRun", this);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String modelChange(PO po, int type) throws Exception {
        this.log.info(po.get_TableName() + " Type: " + type);
        if (type != 1 && type != 2) return null;
        if (po instanceof MRequest) {
            request = (MRequest)po;
            if (request.getR_RequestType_ID() != 0 && (requestType = new MRequestType(request.getCtx(), request.getR_RequestType_ID(), request.get_TrxName())).get_ValueAsBoolean("IsApproved") && (status = new MStatus(request.getCtx(), request.get_ValueAsInt("R_Status_ID"), request.get_TrxName())).isClosed() && !status.isFinalClose()) {
                if (!request.get_ValueAsBoolean("IsApproved1")) throw new AdempiereException(Msg.getMsg(Env.getCtx(), "NotApproved1"));
                if (!request.get_ValueAsBoolean("IsApproved2")) {
                    throw new AdempiereException(Msg.getMsg(Env.getCtx(), "NotApproved2"));
                }
            }
        } else if (po instanceof MRfQLineQty) {
            lineQuantity = (MRfQLineQty)po;
            line = MRfQLine.get(lineQuantity.getCtx(), lineQuantity.getC_RfQLine_ID(), lineQuantity.get_TrxName());
            if (line.get_ValueAsInt("C_Project_ID") > 0 || line.get_ValueAsInt("C_ProjectTask_ID") > 0 || line.get_ValueAsInt("C_ProjectPhase_ID") > 0) {
                lineQuantity.setIsOfferQty(true);
                lineQuantity.setIsPurchaseQty(true);
            }
            if (lineQuantity.is_ValueChanged("BestResponseAmt")) {
                sql = "select coalesce(q.margin,0) from c_rfqresponselineqty q join c_rfqresponseline l on q.c_rfqresponseline_id = l.c_rfqresponseline_id join c_rfqresponse h on l.c_rfqresponse_id = h.c_rfqresponse_id where h.isselectedwinner = 'Y' and c_rfqlineqty_id = " + lineQuantity.get_ID();
                margin = DB.getSQLValueBDEx(lineQuantity.get_TrxName(), sql, new Object[0]);
                if (margin != null && margin.compareTo(Env.ZERO) > 0) {
                    lineQuantity.setMargin(margin);
                }
            }
        } else if (po instanceof MRfQResponse) {
            response = (MRfQResponse)po;
            if (response.is_ValueChanged("IsComplete") && response.isComplete() && response.getPdfAttachment() == null) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "AttachmentNotFound"));
            }
        } else if (po instanceof MAttachment) {
            messageList = new ArrayList<String>();
            messageToSend = new StringBuffer();
            attachment = (MAttachment)po;
            if (attachment.getAD_Table_ID() == I_R_Request.Table_ID) {
                entries = attachment.getEntries();
                request = new MRequest(attachment.getCtx(), attachment.getRecord_ID(), attachment.get_TrxName());
                entryToAdd = new ArrayList<MAttachmentEntry>();
                if (entries != null) {
                    requestAttachment = request.getAttachment(true);
                    requestEntries = null;
                    if (requestAttachment != null && requestAttachment.getAD_Attachment_ID() > 0) {
                        requestEntries = requestAttachment.getEntries();
                    }
                    for (MAttachmentEntry entry : entries) {
                        if (requestEntries == null) {
                            entryToAdd.add(entry);
                            continue;
                        }
                        existsEntry = false;
                        for (MAttachmentEntry attachmentEntry : requestEntries) {
                            if (!attachmentEntry.getName().equals(entry.getName())) continue;
                            existsEntry = true;
                            break;
                        }
                        if (existsEntry) continue;
                        entryToAdd.add(entry);
                    }
                    for (MAttachmentEntry entry : entryToAdd) {
                        update = new MRequestUpdate(request);
                        message = "@File@ @Added@: ";
                        if (entry.isGraphic()) {
                            image = new MImage(attachment.getCtx(), 0, attachment.get_TrxName());
                            image.setBinaryData(entry.getData());
                            image.setName(entry.getName());
                            image.saveEx();
                            update.set_ValueOfColumn("AD_Image_ID", (Object)image.getAD_Image_ID());
                            message = "@AD_Image_ID@ @Added@: ";
                        }
                        translatedMessage = Msg.parseTranslation(attachment.getCtx(), message) + entry.getName();
                        update.setResult(translatedMessage);
                        update.saveEx();
                        updateAttachment = update.createAttachment();
                        updateAttachment.addEntry(entry);
                        updateAttachment.addTextMsg(translatedMessage);
                        updateAttachment.saveEx();
                        if (messageToSend.length() > 0) {
                            messageToSend.append(Env.NL);
                        }
                        messageToSend.append(translatedMessage);
                    }
                    if (messageToSend.length() > 0) {
                        messageList.add("Result");
                        request.setResult(messageToSend.toString());
                        request.sendNotices(messageList, "ATNAN");
                    }
                }
            }
        } else if (po instanceof MOrder) {
            order = (MOrder)po;
            bPartner = (MBPartner)order.getC_BPartner();
            if (bPartner.get_ValueAsBoolean("IsMandatoryOrderReference") && order.get_ValueAsBoolean("IsAllowToInvoice") && order.isSOTrx() && (order.getLink_Order_ID() <= 0 || Util.isEmpty(order.getPOReference()))) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "LinkOrderNotFound"));
            }
        } else if (po instanceof MSContract && (contract = (MSContract)po).is_ValueChanged("M_PriceList_ID") && contract.getM_PriceList_ID() > 0) {
            priceList = MPriceList.get(contract.getCtx(), contract.getM_PriceList_ID(), contract.get_TrxName());
            contract.setC_Currency_ID(priceList.getC_Currency_ID());
        }
        if (type != 2) ** GOTO lbl147
        if (po instanceof MProject) {
            project = (MProject)po;
            if (!project.get_ValueAsBoolean("IsApprovedAttachment") || (projectAttachment = project.getAttachment(true)) != null && projectAttachment.getAD_Attachment_ID() > 0) return null;
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "AttachmentNotFound"));
        }
        if (po instanceof MOrderLine) {
            if (!po.is_ValueChanged("Link_OrderLine_ID")) return null;
            orderLine = (MOrderLine)po;
            projectPhaseId = orderLine.getC_ProjectPhase_ID();
            projectTaskId = orderLine.getC_ProjectTask_ID();
            if (orderLine.getLink_OrderLine_ID() <= 0 || !(order = orderLine.getParent()).isSOTrx() || (generatedOrder = (generatedOrderLine = (MOrderLine)orderLine.getLink_OrderLine()).getParent()).isProcessed()) return null;
            sourceDocumentType = MDocType.get(order.getCtx(), order.getC_DocTypeTarget_ID());
            if (sourceDocumentType.get_ValueAsBoolean("IsSetPOPriceFromSO")) {
                if (orderLine.getPriceList().compareTo(Env.ZERO) != 0) {
                    generatedOrderLine.setPriceEntered(orderLine.getPriceList());
                    generatedOrderLine.setPriceActual(orderLine.getPriceList());
                } else if (orderLine.getPriceList().compareTo(Env.ZERO) == 0) {
                    generatedOrderLine.setPriceEntered(orderLine.getPriceEntered());
                    generatedOrderLine.setPriceActual(orderLine.getPriceEntered());
                }
            }
            if (projectPhaseId > 0) {
                generatedOrderLine.setC_ProjectPhase_ID(projectPhaseId);
            } else if (projectTaskId > 0) {
                generatedOrderLine.setC_ProjectTask_ID(projectTaskId);
            }
            if (orderLine.getC_Campaign_ID() != 0) {
                generatedOrderLine.set_ValueOfColumn("C_Campaign_ID", (Object)orderLine.getC_Campaign_ID());
            }
            if (orderLine.getUser1_ID() != 0) {
                generatedOrderLine.set_ValueOfColumn("User1_ID", (Object)orderLine.getUser1_ID());
            }
            if (orderLine.getC_Project_ID() != 0) {
                generatedOrderLine.set_ValueOfColumn("C_Project_ID", (Object)orderLine.getC_Project_ID());
            }
            if (orderLine.get_ValueAsInt("CUST_MediaType_ID") != 0) {
                generatedOrderLine.set_ValueOfColumn("CUST_MediaType_ID", (Object)orderLine.get_ValueAsInt("CUST_MediaType_ID"));
            }
            generatedOrderLine.saveEx();
            return null;
        } else if (po instanceof MOrder) {
            order = (MOrder)po;
            if (po.is_ValueChanged("Link_Order_ID") && order.getLink_Order_ID() > 0 && order.isSOTrx()) {
                linkSourceOrder = (MOrder)order.getLink_Order();
                linkSourceOrder.setDateOrdered(order.getDateOrdered());
                linkSourceOrder.setDatePromised(order.getDatePromised());
                if (order.isDropShip()) {
                    linkSourceOrder.set_ValueOfColumn("IsDirectInvoice", (Object)order.get_ValueAsBoolean("IsDirectInvoice"));
                }
                linkSourceOrder.saveEx();
                this.copyCommissionFromFRQResponse(order.get_ValueAsInt("C_RfQ_ID"), linkSourceOrder);
            }
            if (order.getRef_Order_ID() <= 0 || order.isProcessed() || (sourceOrder = (MOrder)order.getRef_Order()).getC_Currency_ID() == order.getC_Currency_ID()) return null;
            currency = MCurrency.get(sourceOrder.getCtx(), sourceOrder.getC_Currency_ID());
            defaultPriceList = MPriceList.getDefault(sourceOrder.getCtx(), order.isSOTrx(), currency.getISO_Code());
            if (defaultPriceList == null) throw new IllegalArgumentException("@DefaultPriceListCurrencyNotFound@ (@C_Currency_ID@: " + currency.getISO_Code() + ")");
            order.setM_PriceList_ID(defaultPriceList.getM_PriceList_ID());
            return null;
        } else {
            if (!(po instanceof MProjectTask) || !(projectTask = (MProjectTask)po).get_ValueAsBoolean("IsCustomerApproved") || !projectTask.get_ValueAsBoolean("IsApprovedAttachment") || (projectTaskAttachment = projectTask.getAttachment(true)) != null && projectTaskAttachment.getAD_Attachment_ID() > 0) return null;
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "AttachmentNotFound"));
lbl147:
            // 1 sources

            if (type == 1) {
                if (po instanceof MCommissionLine) {
                    commissionLine = (MCommissionLine)po;
                    commission = (MCommission)commissionLine.getC_Commission();
                    if (commission == null || commissionLine.get_ValueAsInt("Vendor_ID") > 0 || commissionLine.get_ValueAsInt("C_Order_ID") <= 0) return null;
                    order = new MOrder(commission.getCtx(), commissionLine.get_ValueAsInt("C_Order_ID"), commission.get_TrxName());
                    commissionLine.set_ValueOfColumn("Vendor_ID", (Object)order.getC_BPartner_ID());
                    return null;
                } else if (po instanceof MOrderLine) {
                    orderLine = (MOrderLine)po;
                    order = new MOrder(orderLine.getCtx(), orderLine.getC_Order_ID(), orderLine.get_TrxName());
                    docType = (MDocType)order.getC_DocTypeTarget();
                    projectPhaseId = orderLine.getC_ProjectPhase_ID();
                    projectTaskId = orderLine.getC_ProjectTask_ID();
                    if (projectTaskId > 0) {
                        projectTask = new MProjectTask(orderLine.getCtx(), projectTaskId, orderLine.get_TrxName());
                        if (projectTask.getC_Campaign_ID() != 0) {
                            orderLine.set_ValueOfColumn("C_Campaign_ID", (Object)projectTask.getC_Campaign_ID());
                        }
                        if (order.getRef_Order_ID() > 0) {
                            if (projectTask.getUser1_ID() != 0) {
                                orderLine.set_ValueOfColumn("User1_ID", (Object)projectTask.getUser3_ID());
                            }
                            if (projectTask.getUser3_ID() != 0) {
                                orderLine.set_ValueOfColumn("User3_ID", (Object)projectTask.getUser1_ID());
                            }
                        } else {
                            if (projectTask.getUser1_ID() != 0) {
                                orderLine.set_ValueOfColumn("User1_ID", (Object)projectTask.getUser1_ID());
                            }
                            if (projectTask.getUser3_ID() != 0) {
                                orderLine.set_ValueOfColumn("User3_ID", (Object)projectTask.getUser3_ID());
                            }
                        }
                        if (projectTask.get_ValueAsInt("CUST_MediaType_ID") != 0) {
                            orderLine.set_ValueOfColumn("CUST_MediaType_ID", (Object)projectTask.get_ValueAsInt("CUST_MediaType_ID"));
                        }
                        if ((projectPhasefromTask = new MProjectPhase(orderLine.getCtx(), projectTask.getC_ProjectPhase_ID(), orderLine.get_TrxName())).getC_Project_ID() == 0) return null;
                        orderLine.set_ValueOfColumn("C_Project_ID", (Object)projectPhasefromTask.getC_Project_ID());
                        return null;
                    } else {
                        if (projectPhaseId <= 0) return null;
                        projectPhase = new MProjectPhase(orderLine.getCtx(), projectPhaseId, orderLine.get_TrxName());
                        if (projectPhase.getC_Campaign_ID() != 0) {
                            orderLine.set_ValueOfColumn("C_Campaign_ID", (Object)projectPhase.getC_Campaign_ID());
                        }
                        if (order.getRef_Order_ID() > 0) {
                            if (projectPhase.getUser1_ID() != 0) {
                                orderLine.set_ValueOfColumn("User1_ID", (Object)projectPhase.getUser3_ID());
                            }
                            if (projectPhase.getUser3_ID() != 0) {
                                orderLine.set_ValueOfColumn("User3_ID", (Object)projectPhase.getUser1_ID());
                            }
                        } else {
                            if (projectPhase.getUser1_ID() != 0) {
                                orderLine.set_ValueOfColumn("User1_ID", (Object)projectPhase.getUser1_ID());
                            }
                            if (projectPhase.getUser3_ID() != 0) {
                                orderLine.set_ValueOfColumn("User3_ID", (Object)projectPhase.getUser3_ID());
                            }
                        }
                        if (projectPhase.getC_Project_ID() != 0) {
                            orderLine.set_ValueOfColumn("C_Project_ID", (Object)projectPhase.getC_Project_ID());
                        }
                        if (projectPhase.get_ValueAsInt("CUST_MediaType_ID") == 0) return null;
                        orderLine.set_ValueOfColumn("CUST_MediaType_ID", (Object)projectPhase.get_ValueAsInt("CUST_MediaType_ID"));
                    }
                    return null;
                } else if (po instanceof MOrder) {
                    order = (MOrder)po;
                    docType = (MDocType)order.getC_DocTypeTarget();
                    orderprojectId = order.getC_Project_ID();
                    if (orderprojectId > 0 && order.getC_ConversionType_ID() <= 0) {
                        order.setC_ConversionType_ID(114);
                    }
                    if (!docType.get_ValueAsBoolean("IsSplitDocuments") && (serviceContractId = order.get_ValueAsInt("S_Contract_ID")) > 0 && (serviceContract = new MSContract(order.getCtx(), serviceContractId, order.get_TrxName())).getUser1_ID() > 0) {
                        order.setUser1_ID(serviceContract.getUser1_ID());
                    }
                    if (order.getRef_Order_ID() <= 0 || (refOrder = (MOrder)order.getRef_Order()).getUser3_ID() <= 0) return null;
                    order.setUser1_ID(refOrder.getUser3_ID());
                    order.setUser3_ID(refOrder.getUser1_ID());
                    return null;
                } else {
                    if (!(po instanceof MRequest)) return null;
                    mRequest = (MRequest)po;
                    mProject = null;
                    try {
                        if (mRequest.getC_Invoice_ID() > 0) {
                            mProject = (MProject)mRequest.getC_Invoice().getC_Project();
                        } else if (mRequest.getC_Order_ID() > 0) {
                            mProject = (MProject)mRequest.getC_Order().getC_Project();
                        } else if (mRequest.getC_InvoiceLine_ID() > 0) {
                            mProject = (MProject)mRequest.getC_InvoiceLine().getC_Invoice().getC_Project();
                        } else if (mRequest.getC_OrderLine_ID() > 0) {
                            mProject = (MProject)mRequest.getC_OrderLine().getC_Order().getC_Project();
                        }
                        if (mProject == null) return null;
                        mRequest.setC_Project_ID(mProject.get_ID());
                        return null;
                    }
                    catch (Exception orderprojectId) {}
                }
                return null;
            } else {
                if (type != 5 || !(po instanceof MBPartner) || !po.is_ValueChanged("BPartner_Parent_ID") || (treeId = MTree.getDefaultTreeIdFromTableId((bPartner = (MBPartner)po).getAD_Client_ID(), I_C_BPartner.Table_ID)) <= 0 || (node = MTree_NodeBP.get(tree = MTree.get(bPartner.getCtx(), treeId, null), bPartner.getC_BPartner_ID())) == null) return null;
                parentId = bPartner.getBPartner_Parent_ID();
                if (parentId < 0) {
                    parentId = 0;
                }
                node.setParent_ID(parentId);
                node.saveEx();
            }
        }
        return null;
    }

    private void copyCommissionFromFRQResponse(int rFQId, MOrder linkSourceOrder) {
        new Query(linkSourceOrder.getCtx(), "C_CommissionLine", "EXISTS(SELECT 1 FROM C_RfQResponse rr \t\tWHERE rr.C_RfQResponse_ID = C_CommissionLine.C_RfQResponse_ID \t\tAND rr.C_RfQ_ID = ? \t\tAND rr.IsSelectedWinner = 'Y' \t\tAND rr.IsComplete = 'Y')", linkSourceOrder.get_TrxName()).setParameters(rFQId).setOnlyActiveRecords(true).list().forEach(commissionLine -> {
            MCommissionLine lineToAdd = new MCommissionLine(commissionLine.getCtx(), 0, commissionLine.get_TrxName());
            PO.copyValues(commissionLine, lineToAdd);
            lineToAdd.set_ValueOfColumn("C_RfQResponse_ID", null);
            lineToAdd.set_ValueOfColumn("C_Order_ID", (Object)linkSourceOrder.getC_Order_ID());
            lineToAdd.saveEx();
        });
    }

    public static void updateCommissionRunForOrder(MOrder mOrder) {
        PO mCommissionType = null;
        try {
            mCommissionType = new MCommissionType(mOrder.getCtx(), ((MDocType)mOrder.getC_DocTypeTarget()).get_ValueAsInt("C_CommissionType_ID"), mOrder.get_TrxName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mCommissionType != null && mCommissionType.get_ID() > 0) {
            AgencyValidator.cancelingPreviousOrderCommissionRun(mOrder);
            AgencyValidator.createCommissionForOrder(mOrder, mCommissionType.get_ID(), true);
        }
    }

    public static void cancelingPreviousOrderCommissionRun(MOrder mOrder) {
        String whereClause = "C_Order_ID=? AND C_Invoice_ID IS NULL AND DocStatus=?";
        List mCommissionRuns = new Query(mOrder.getCtx(), "C_CommissionRun", whereClause, mOrder.get_TrxName()).setParameters(mOrder.get_ID(), "CO").list();
        for (MCommissionRun mCommissionRun : mCommissionRuns) {
            String whereClause2 = "C_CommissionRun_ID=? AND GrandTotal>0";
            MOrder commissionMOrder = (MOrder)new Query(mOrder.getCtx(), "C_Order", whereClause2, mOrder.get_TrxName()).setParameters(mCommissionRun.get_ID()).first();
            if (commissionMOrder != null && commissionMOrder.get_ID() > 0) {
                AgencyValidator.reverseCommissionOrder(commissionMOrder, commissionMOrder.getTotalLines().negate());
            }
            if (!mCommissionRun.processIt("CL")) {
                // empty if block
            }
            mCommissionRun.saveEx();
        }
    }

    private static Timestamp getCurrentDate() {
        Timestamp currentTimestamp = new Timestamp(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentTimestamp);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        currentTimestamp = new Timestamp(cal.getTimeInMillis());
        return currentTimestamp;
    }

    public static void reverseCommissionOrder(MOrder mOrder, BigDecimal reverseAmount) {
        Timestamp currentTimestamp = AgencyValidator.getCurrentDate();
        MOrder reverseOrder = new MOrder(mOrder.getCtx(), 0, mOrder.get_TrxName());
        PO.copyValues(mOrder, reverseOrder);
        reverseOrder.setDocumentNo(null);
        reverseOrder.setDateOrdered(currentTimestamp);
        reverseOrder.setDatePromised(currentTimestamp);
        reverseOrder.setPOReference(mOrder.getDocumentNo());
        reverseOrder.addDescription(Msg.parseTranslation(mOrder.getCtx(), "@Generated@ [@C_Order_ID@ " + mOrder.getDocumentNo()) + "]");
        reverseOrder.setDocStatus("DR");
        reverseOrder.setDocAction("CO");
        reverseOrder.setTotalLines(Env.ZERO);
        reverseOrder.setGrandTotal(Env.ZERO);
        reverseOrder.setIsSOTrx(mOrder.isSOTrx());
        reverseOrder.setRef_Order_ID(-1);
        reverseOrder.setIsDropShip(false);
        reverseOrder.setDropShip_BPartner_ID(0);
        reverseOrder.setDropShip_Location_ID(0);
        reverseOrder.setDropShip_User_ID(0);
        reverseOrder.set_ValueOfColumn("ConsumptionOrder_ID", null);
        reverseOrder.set_ValueOfColumn("PreOrder_ID", null);
        reverseOrder.saveEx();
        MOrderLine commissionOrderLine = mOrder.getLines(true, null)[0];
        MOrderLine reverseOrderLine = new MOrderLine(reverseOrder);
        PO.copyValues(commissionOrderLine, reverseOrderLine);
        reverseOrderLine.setOrder(reverseOrder);
        reverseOrderLine.setC_Order_ID(reverseOrder.getC_Order_ID());
        if (commissionOrderLine.getQtyOrdered().signum() < 0) {
            reverseOrderLine.setQty(Env.ONE.negate());
        } else {
            reverseOrderLine.setQty(Env.ONE);
        }
        reverseOrderLine.setPrice(reverseAmount);
        reverseOrderLine.setProcessed(true);
        reverseOrderLine.saveEx();
        reverseOrder.setDocStatus("CL");
        reverseOrder.setDocAction("--");
        reverseOrder.setProcessed(true);
        reverseOrder.calculateTaxTotal();
        reverseOrder.saveEx();
        reverseOrder.processIt("PO");
        mOrder.setDocStatus("CL");
        mOrder.saveEx();
    }

    @Override
    public String docValidate(PO po, int timing) {
        this.log.info(po.get_TableName() + " Timing: " + timing);
        if (po instanceof MOrder) {
            MOrder order2 = (MOrder)po;
            MDocType documentType = MDocType.get(order2.getCtx(), order2.getC_DocTypeTarget_ID());
            if (timing == 1) {
                MProject parentProject;
                if (order2.get_ValueAsInt("S_Contract_ID") <= 0 && order2.getC_Project_ID() > 0 && (parentProject = MProject.getById(order2.getCtx(), order2.getC_Project_ID(), order2.get_TrxName())).get_ValueAsInt("S_Contract_ID") > 0) {
                    order2.set_ValueOfColumn("S_Contract_ID", (Object)parentProject.get_ValueAsInt("S_Contract_ID"));
                    order2.saveEx();
                }
                if (order2.get_ValueAsInt("S_Contract_ID") > 0 && order2.getRef_Order_ID() <= 0) {
                    int user1Id;
                    if (order2.get_ValueAsInt("C_CommissionRun_ID") > 0) {
                        MCommissionRun commissionRun2 = new MCommissionRun(order2.getCtx(), order2.get_ValueAsInt("C_CommissionRun_ID"), order2.get_TrxName());
                        if (commissionRun2.get_ValueAsInt("S_Contract_ID") > 0) {
                            int user1Id2;
                            MSContract contract = new MSContract(order2.getCtx(), commissionRun2.get_ValueAsInt("S_Contract_ID"), order2.get_TrxName());
                            order2.setAD_Org_ID(contract.getAD_Org_ID());
                            if (contract.getUser1_ID() > 0) {
                                order2.setUser1_ID(contract.getUser1_ID());
                            }
                            if ((user1Id2 = DB.getSQLValue(order2.get_TrxName(), "SELECT p.User1_ID FROM S_ContractParties p WHERE S_Contract_ID = ? AND EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = p.AD_User_ID AND u.C_BPartner_ID = ?)", contract.getS_Contract_ID(), order2.getC_BPartner_ID())) > 0) {
                                order2.setUser3_ID(user1Id2);
                            }
                            order2.saveEx();
                        }
                        if (commissionRun2.get_ValueAsInt("C_Invoice_ID") != 0) {
                            order2.set_ValueOfColumn("IsAllowToInvoice", (Object)true);
                            if (Util.isEmpty(order2.getPOReference())) {
                                order2.setPOReference("-");
                            }
                            order2.saveEx();
                        }
                    } else if (!documentType.get_ValueAsBoolean("IsSplitDocuments") && (user1Id = DB.getSQLValue(order2.get_TrxName(), "SELECT p.User1_ID FROM S_ContractParties p WHERE S_Contract_ID = ? AND EXISTS(SELECT 1 FROM AD_User u WHERE u.AD_User_ID = p.AD_User_ID AND u.C_BPartner_ID = ?)", order2.get_ValueAsInt("S_Contract_ID"), order2.getC_BPartner_ID())) > 0) {
                        order2.setUser1_ID(user1Id);
                        order2.saveEx();
                    }
                }
                if (documentType.get_ValueAsBoolean("IsApprovedRequired")) {
                    if (!order2.get_ValueAsBoolean("IsCustomerApproved")) {
                        throw new AdempiereException(Msg.parseTranslation(Env.getCtx(), "@CustomerApprovedRequired@"));
                    }
                    MAttachment orderAttachment = order2.getAttachment(true);
                    if (orderAttachment == null || orderAttachment.getAD_Attachment_ID() <= 0) {
                        throw new AdempiereException(Msg.getMsg(Env.getCtx(), "AttachmentNotFound"));
                    }
                    if (!documentType.get_ValueAsBoolean("NoProjectRequired") && order2.getC_Project_ID() <= 0) {
                        throw new AdempiereException(Msg.parseTranslation(Env.getCtx(), "@C_Project_ID@ @NotFound@"));
                    }
                }
                if (documentType.get_ValueAsInt("C_CommissionType_ID") > 0) {
                    AgencyValidator.createCommissionForOrder(order2, documentType.get_ValueAsInt("C_CommissionType_ID"), false);
                }
            } else if (timing == 9) {
                if (order2.isSOTrx() && order2.isDropShip()) {
                    ProcessBuilder.create(order2.getCtx()).process(OrderPOCreateAbstract.getProcessId()).withParameter("C_Order_ID", order2.getC_Order_ID()).withParameter("Vendor_ID", order2.getDropShip_BPartner_ID()).withParameter("C_DocTypeDropShip_ID", documentType.get_ValueAsInt("C_DocTypeDropShip_ID")).withoutTransactionClose().execute(order2.get_TrxName());
                }
                if (documentType.get_ValueAsInt("C_CommissionType_ID") > 0) {
                    AgencyValidator.createCommissionForOrder(order2, documentType.get_ValueAsInt("C_CommissionType_ID"), true);
                }
                this.generateReverseAmount(order2);
            } else if (timing == 10) {
                new Query(order2.getCtx(), "C_CommissionRun", "C_Order_ID = ? AND C_Invoice_ID IS NULL AND DocStatus = 'CO'", order2.get_TrxName()).setOnlyActiveRecords(true).setParameters(order2.getC_Order_ID()).list().forEach(commissionRun -> {
                    if (!commissionRun.processIt("VO")) {
                        throw new AdempiereException(commissionRun.getProcessMsg());
                    }
                    commissionRun.saveEx();
                });
                new Query(order2.getCtx(), "C_Order", "ConsumptionOrder_ID = ? AND DocStatus = 'CO'", order2.get_TrxName()).setOnlyActiveRecords(true).setParameters(order2.getC_Order_ID()).list().forEach(reverseOrder -> {
                    if (!reverseOrder.processIt("VO")) {
                        throw new AdempiereException(reverseOrder.getProcessMsg());
                    }
                    reverseOrder.saveEx();
                });
                if (order2.isSOTrx()) {
                    new Query(order2.getCtx(), "C_Order", "C_Order_ID = ? AND DocStatus = 'CO'", order2.get_TrxName()).setOnlyActiveRecords(true).setParameters(order2.getLink_Order_ID()).list().forEach(reverseOrder -> {
                        if (!reverseOrder.processIt("VO")) {
                            throw new AdempiereException(reverseOrder.getProcessMsg());
                        }
                        reverseOrder.saveEx();
                    });
                }
            } else if (timing == 7) {
                if (order2.isSOTrx()) {
                    for (MOrderLine orderLine : order2.getLines()) {
                        BigDecimal priceEntered;
                        if (orderLine.getM_Product_ID() == 0) continue;
                        MPriceList priceList = new MPriceList(order2.getCtx(), order2.getM_PriceList_ID(), order2.get_TrxName());
                        MPriceListVersion priceListVersion = new MPriceListVersion(priceList.getCtx(), priceList.getM_PriceList_ID(), priceList.get_TrxName());
                        MProduct product = new MProduct(orderLine.getCtx(), orderLine.getM_Product_ID(), orderLine.get_TrxName());
                        MProductPrice productPrice = new MProductPrice(orderLine.getCtx(), priceListVersion.getM_PriceList_Version_ID(), product.getM_Product_ID(), orderLine.get_TrxName());
                        if (productPrice.get_ValueAsBoolean("IsIncludedContract") || orderLine.get_ValueAsBoolean("IsBonusProduct") || (priceEntered = orderLine.getPriceEntered()).compareTo(BigDecimal.ZERO) != 0) continue;
                        throw new AdempiereException(Msg.parseTranslation(Env.getCtx(), "@PriceEntereddontBeZero@"));
                    }
                }
            } else if (timing == 11) {
                AgencyValidator.updateCommissionRunForOrder(order2);
            }
        } else if (po instanceof MCommissionRun) {
            MCommissionRun commissionRun3 = (MCommissionRun)po;
            if (timing == 10) {
                new Query(commissionRun3.getCtx(), "C_Order", "C_CommissionRun_ID = ? AND DocStatus = 'CO'", commissionRun3.get_TrxName()).setOnlyActiveRecords(true).setParameters(commissionRun3.getC_CommissionRun_ID()).list().forEach(order -> {
                    if (!order.processIt("VO")) {
                        throw new AdempiereException(order.getProcessMsg());
                    }
                    order.saveEx();
                });
            }
        } else if (po instanceof MTimeExpense) {
            MTimeExpense expenseReport = (MTimeExpense)po;
            if (timing != 7 && timing == 9) {
                Hashtable<Integer, Hashtable<Integer, BigDecimal>> orders = new Hashtable<Integer, Hashtable<Integer, BigDecimal>>();
                for (MTimeExpenseLine line : expenseReport.getLines()) {
                    MOrderLine salesOrderLine;
                    int salesOrderLineId = line.getC_OrderLine_ID();
                    int linkOrderLineId = line.get_ValueAsInt("Link_OrderLine_ID");
                    if (salesOrderLineId <= 0 && linkOrderLineId <= 0 || line.getQty() == null || line.getQty().compareTo(Env.ZERO) <= 0) continue;
                    if (!expenseReport.get_ValueAsBoolean("IsNotGenerateDelivery") && salesOrderLineId > 0) {
                        salesOrderLine = new MOrderLine(expenseReport.getCtx(), salesOrderLineId, expenseReport.get_TrxName());
                        Hashtable<Integer, BigDecimal> salesOrderLines = (Hashtable<Integer, BigDecimal>)orders.get(salesOrderLine.getC_Order_ID());
                        if (salesOrderLines == null) {
                            salesOrderLines = new Hashtable<Integer, BigDecimal>();
                        }
                        salesOrderLines.put(salesOrderLine.getC_OrderLine_ID(), line.getQty());
                        orders.put(salesOrderLine.getC_Order_ID(), salesOrderLines);
                    }
                    if (expenseReport.get_ValueAsBoolean("IsNotGenerateReceipt") || linkOrderLineId <= 0) continue;
                    salesOrderLine = new MOrderLine(expenseReport.getCtx(), linkOrderLineId, expenseReport.get_TrxName());
                    Hashtable<Integer, BigDecimal> purchaseOrderLines = (Hashtable<Integer, BigDecimal>)orders.get(salesOrderLine.getC_Order_ID());
                    if (purchaseOrderLines == null) {
                        purchaseOrderLines = new Hashtable<Integer, BigDecimal>();
                    }
                    purchaseOrderLines.put(salesOrderLine.getC_OrderLine_ID(), line.getQty());
                    orders.put(salesOrderLine.getC_Order_ID(), purchaseOrderLines);
                }
                if (!expenseReport.get_ValueAsBoolean("IsFromReturn")) {
                    orders.entrySet().stream().forEach(orderSet -> this.generateInOutFromOrder(expenseReport, (Integer)orderSet.getKey(), (Hashtable)orderSet.getValue()));
                }
            }
        } else if (po instanceof MInvoice) {
            MInvoice invoice = (MInvoice)po;
            if (timing == 1) {
                MProject parentProject;
                if (invoice.get_ValueAsInt("S_Contract_ID") <= 0 && invoice.getC_Project_ID() > 0 && (parentProject = MProject.getById(invoice.getCtx(), invoice.getC_Project_ID(), invoice.get_TrxName())).get_ValueAsInt("S_Contract_ID") > 0) {
                    invoice.set_ValueOfColumn("S_Contract_ID", (Object)parentProject.get_ValueAsInt("S_Contract_ID"));
                    invoice.saveEx();
                }
                if (invoice.getC_Order_ID() > 0) {
                    MOrder order3 = (MOrder)invoice.getC_Order();
                    if (order3.get_ValueAsInt("C_ProjectPhase_ID") > 0) {
                        invoice.set_ValueOfColumn("C_ProjectPhase_ID", (Object)order3.get_ValueAsInt("C_ProjectPhase_ID"));
                    }
                    if (order3.get_ValueAsInt("C_ProjectTask_ID") > 0) {
                        invoice.set_ValueOfColumn("C_ProjectTask_ID", (Object)order3.get_ValueAsInt("C_ProjectTask_ID"));
                    }
                    invoice.saveEx();
                    if (invoice.isSOTrx()) {
                        MDocType docType = (MDocType)invoice.getC_DocTypeTarget();
                        if (!order3.get_ValueAsBoolean("IsAllowToInvoice") && !docType.getDocBaseType().equalsIgnoreCase("ARC")) {
                            throw new AdempiereException("@C_Order_ID@ " + order3.getDocumentNo() + " @IsAllowToInvoiceRequired@");
                        }
                    }
                }
            } else if (timing == 9) {
                MDocType documentType;
                if (!invoice.isReversal() && (documentType = MDocType.get(invoice.getCtx(), invoice.getC_DocTypeTarget_ID())).get_ValueAsInt("C_CommissionType_ID") > 0) {
                    AgencyValidator.createCommissionForInvoice(invoice, documentType.get_ValueAsInt("C_CommissionType_ID"), true);
                }
            } else if (timing == 13 || timing == 14 || timing == 10) {
                new Query(invoice.getCtx(), "C_CommissionRun", "C_Invoice_ID = ? AND DocStatus = 'CO'", invoice.get_TrxName()).setOnlyActiveRecords(true).setParameters(invoice.getC_Invoice_ID()).list().forEach(commissionRun -> {
                    if (!commissionRun.processIt("VO")) {
                        throw new AdempiereException(commissionRun.getProcessMsg());
                    }
                });
            }
        } else if (po instanceof MSContract && timing == 7) {
            BigDecimal sumPercent;
            MSContract serviceContract = (MSContract)po;
            String whereClause = "S_Contract_ID = ?";
            X_C_CommissionSalesRep salesRep = (X_C_CommissionSalesRep)new Query(po.getCtx(), "C_CommissionSalesRep", whereClause, po.get_TrxName()).setParameters(serviceContract.getS_Contract_ID()).setOnlyActiveRecords(true).first();
            if (salesRep != null && salesRep.getC_CommissionSalesRep_ID() > 0 && (sumPercent = new Query(po.getCtx(), "C_CommissionSalesRep", whereClause, po.get_TrxName()).setParameters(serviceContract.getS_Contract_ID()).sum("AmtMultiplier")).compareTo(Env.ONEHUNDRED) != 0) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "TotalPercentageIsNot100"));
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateInOutFromOrder(MTimeExpense expenseReport, int orderId, Hashtable<Integer, BigDecimal> lines) {
        MBPartner partner;
        MOrder order = new MOrder(expenseReport.getCtx(), orderId, expenseReport.get_TrxName());
        MInOut inOut = new MInOut(order, 0, expenseReport.getDateReport());
        if (!MPeriod.isOpen(inOut.getCtx(), expenseReport.getDateReport(), inOut.getC_DocType().getDocBaseType(), inOut.getAD_Org_ID())) {
            throw new AdempiereException("ERROR: Per\u00edodo cerrado para tipo de documento '" + inOut.getC_DocType().getName() + "'");
        }
        inOut.setM_Warehouse_ID(order.getM_Warehouse_ID());
        inOut.set_ValueOfColumn("S_TimeExpense_ID", (Object)expenseReport.get_ID());
        inOut.saveEx();
        AtomicReference<BigDecimal> totalOrdered = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> totalDelivered = new AtomicReference<BigDecimal>(Env.ZERO);
        lines.entrySet().stream().forEach(linesSet -> {
            MOrderLine orderLine = new MOrderLine(expenseReport.getCtx(), (Integer)linesSet.getKey(), expenseReport.get_TrxName());
            BigDecimal toDeliver = (BigDecimal)linesSet.getValue();
            MInOutLine inOutLine = new MInOutLine(inOut);
            inOutLine.setOrderLine(orderLine, 0, toDeliver);
            inOutLine.setQty(toDeliver);
            inOutLine.saveEx();
            totalOrdered.updateAndGet(amount -> amount.add(orderLine.getLineNetAmt()));
            totalDelivered.updateAndGet(amount -> amount.add(orderLine.getPriceActual().multiply(toDeliver)));
        });
        inOut.setDocStatus("DR");
        inOut.processIt("CO");
        inOut.saveEx();
        if (expenseReport.getAD_Org_ID() != 2000004 || !inOut.isSOTrx() || inOut.getAD_Org_ID() != 2000004 || (partner = inOut.getBPartner()).getAD_OrgBP_ID() == null) return;
        MOrder sOrder = (MOrder)inOut.getC_Order();
        String sql = "select c_order_id from c_order where ref_order_id = " + sOrder.get_ID() + " and issotrx = 'N' and docstatus in ('CO','CL')";
        int orderID = DB.getSQLValueEx(inOut.get_TrxName(), sql, new Object[0]);
        if (orderID <= 0) throw new AdempiereException("No se obtuvo orden de compra, completa o cerrada, para la orden de venta Nro. " + sOrder.getDocumentNo());
        MOrder pOrder = new MOrder(expenseReport.getCtx(), orderID, expenseReport.get_TrxName());
        sql = "select c_order_id from c_order where link_order_id = " + orderID + " and docstatus in ('CO','CL')";
        orderID = DB.getSQLValueEx(inOut.get_TrxName(), sql, new Object[0]);
        if (orderID <= 0) throw new AdempiereException("No se obtuvo orden de venta, completa o cerrada, para la orden de compra Nro. " + pOrder.getDocumentNo());
        this.createDeliveryFromSO(inOut, orderID, inOut.get_ValueAsInt("S_TimeExpense_ID"));
    }

    private void createDeliveryFromSO(MInOut inout, int orderID, int expenseID) {
        MInOut inoutHdr = null;
        MOrder order = new MOrder(inout.getCtx(), orderID, inout.get_TrxName());
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine oLine = lines[i];
            if (inoutHdr == null) {
                inoutHdr = new MInOut(order, 0, inout.getMovementDate());
                inoutHdr.setAD_Org_ID(order.getAD_Org_ID());
                inoutHdr.setC_BPartner_ID(order.getC_BPartner_ID());
                inoutHdr.set_ValueOfColumn("S_TimeExpense_ID", (Object)expenseID);
                inoutHdr.saveEx();
            }
            MInOutLine inoutLine = new MInOutLine(inoutHdr);
            inoutLine.setC_OrderLine_ID(oLine.get_ID());
            inoutLine.setM_Product_ID(oLine.getM_Product_ID());
            inoutLine.setC_UOM_ID(oLine.getC_UOM_ID());
            inoutLine.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            inoutLine.setM_Warehouse_ID(oLine.getM_Warehouse_ID());
            MWarehouse warehouse = (MWarehouse)oLine.getM_Warehouse();
            inoutLine.setM_Locator_ID(MLocator.getDefault(warehouse).get_ID());
            int link_line_id = oLine.getLink_OrderLine_ID();
            String sql = "select l.m_inoutline_id from m_inoutline l inner join m_inout h on l.m_inout_id = h.m_inout_id where h.docstatus in ('CO','CL') and l.c_orderline_id = " + link_line_id + " and h.issotrx = 'N' and s_timeexpense_id = " + expenseID;
            int ioLine_id = DB.getSQLValueEx(inout.get_TrxName(), sql, new Object[0]);
            if (ioLine_id <= 0) continue;
            MInOutLine ref_line = new MInOutLine(inout.getCtx(), ioLine_id, inout.get_TrxName());
            inoutLine.setQtyEntered(ref_line.getQtyEntered());
            inoutLine.setMovementQty(ref_line.getMovementQty());
            inoutLine.saveEx();
        }
        if (inoutHdr.getLines(true).length > 0) {
            if (!inoutHdr.processIt("CO")) {
                throw new AdempiereException(inoutHdr.getProcessMsg());
            }
        } else {
            inoutHdr.deleteEx(true);
        }
    }

    private static void reversePreviousCommissionOrders(MInvoice sourceInvoice, BigDecimal reverseAmount) {
        new Query(sourceInvoice.getCtx(), "C_Order", "DocStatus IN ('CO', 'CL') AND grandTotal > 0 AND EXISTS(SELECT 1 FROM C_CommissionRun cr WHERE cr.C_CommissionRun_ID = C_Order.C_CommissionRun_ID AND cr.C_Invoice_ID IS NULL AND cr.docStatus='CO'AND EXISTS(SELECT 1 FROM C_InvoiceLine il \tINNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = il.C_OrderLine_ID) \tWHERE il.C_Invoice_ID = ? \tAND ol.C_Order_ID = cr.C_Order_ID))", sourceInvoice.get_TrxName()).setOnlyActiveRecords(true).setParameters(sourceInvoice.getC_Invoice_ID()).list().stream().forEach(commissionOrder -> {
            MOrder reverseOrder = new MOrder(commissionOrder.getCtx(), 0, commissionOrder.get_TrxName());
            PO.copyValues(commissionOrder, reverseOrder);
            reverseOrder.setDocumentNo(null);
            reverseOrder.setDateOrdered(sourceInvoice.getDateInvoiced());
            reverseOrder.setDatePromised(sourceInvoice.getDateInvoiced());
            reverseOrder.setDateAcct(sourceInvoice.getDateAcct());
            reverseOrder.setDatePrinted(sourceInvoice.getDatePrinted());
            reverseOrder.setPOReference(commissionOrder.getDocumentNo());
            reverseOrder.addDescription(Msg.parseTranslation(commissionOrder.getCtx(), "@Generated@ [@C_Order_ID@ " + commissionOrder.getDocumentNo()) + "]");
            reverseOrder.setDocStatus("DR");
            reverseOrder.setDocAction("CO");
            reverseOrder.setTotalLines(Env.ZERO);
            reverseOrder.setGrandTotal(Env.ZERO);
            reverseOrder.setIsSOTrx(commissionOrder.isSOTrx());
            reverseOrder.setRef_Order_ID(-1);
            reverseOrder.setIsDropShip(false);
            reverseOrder.setDropShip_BPartner_ID(0);
            reverseOrder.setDropShip_Location_ID(0);
            reverseOrder.setDropShip_User_ID(0);
            reverseOrder.set_ValueOfColumn("ConsumptionOrder_ID", null);
            reverseOrder.set_ValueOfColumn("PreOrder_ID", null);
            reverseOrder.saveEx();
            MOrderLine commissionOrderLine = commissionOrder.getLines(true, null)[0];
            MOrderLine reverseOrderLine = new MOrderLine(reverseOrder);
            PO.copyValues(commissionOrderLine, reverseOrderLine);
            reverseOrderLine.setOrder(reverseOrder);
            reverseOrderLine.setC_Order_ID(reverseOrder.getC_Order_ID());
            if (commissionOrderLine.getQtyOrdered().signum() < 0) {
                reverseOrderLine.setQty(Env.ONE.negate());
            } else {
                reverseOrderLine.setQty(Env.ONE);
            }
            reverseOrderLine.setPrice(reverseAmount);
            reverseOrderLine.setProcessed(true);
            reverseOrderLine.saveEx();
            reverseOrder.setDocStatus("CL");
            reverseOrder.setDocAction("--");
            reverseOrder.setProcessed(true);
            reverseOrder.calculateTaxTotal();
            reverseOrder.saveEx();
            reverseOrder.processIt("PO");
            commissionOrder.setDocStatus("CL");
            commissionOrder.saveEx();
        });
    }

    private void generateReverseAmount(MOrder sourceOrder) {
        int projectPhaseId = sourceOrder.get_ValueAsInt("C_ProjectPhase_ID");
        if (projectPhaseId <= 0) {
            return;
        }
        MDocType documentType = MDocType.get(sourceOrder.getCtx(), sourceOrder.getC_DocTypeTarget_ID());
        if (documentType.get_ValueAsBoolean("IsConsumePreOrder")) {
            int reverseDocumentTypeId = documentType.get_ValueAsInt("C_DocTypeReversal_ID");
            MOrder preOrder = (MOrder)new Query(sourceOrder.getCtx(), "C_Order", "DocStatus = 'CO' AND C_ProjectPhase_ID = ? AND IsSOTrx = '" + (sourceOrder.isSOTrx() ? "Y" : "N") + "' AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = C_Order.C_DocType_ID AND dt.IsPreOrder = 'Y')", sourceOrder.get_TrxName()).setParameters(projectPhaseId).first();
            if (preOrder != null && preOrder.getC_Order_ID() > 0) {
                BigDecimal releasedAmount;
                BigDecimal consumeAmount = DB.getSQLValueBD(sourceOrder.get_TrxName(), "SELECT SUM(TotalLines) FROM C_Order o WHERE o.DocStatus IN('CO') AND o.PreOrder_ID = ? AND o.IsSOTrx = '" + (sourceOrder.isSOTrx() ? "Y" : "N") + "' AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = o.C_DocType_ID AND dt.IsConsumePreOrder = 'Y')", preOrder.getC_Order_ID());
                if (consumeAmount == null) {
                    consumeAmount = Env.ZERO;
                }
                if ((releasedAmount = DB.getSQLValueBD(sourceOrder.get_TrxName(), "SELECT SUM(ol.ReleasedQty * ol.PriceActual) FROM C_Order o INNER JOIN C_OrderLine ol ON(ol.C_Order_ID = o.C_Order_ID) WHERE o.DocStatus IN('CO') AND COALESCE(ol.ReleasedQty, 0) > 0AND o.PreOrder_ID = ? AND o.IsSOTrx = '" + (sourceOrder.isSOTrx() ? "Y" : "N") + "' AND EXISTS(SELECT 1 FROM C_DocType dt WHERE dt.C_DocType_ID = o.C_DocType_ID AND dt.IsConsumePreOrder = 'Y')", preOrder.getC_Order_ID())) == null) {
                    releasedAmount = Env.ZERO;
                }
                consumeAmount = consumeAmount.subtract(releasedAmount);
                if ((consumeAmount = consumeAmount.add(sourceOrder.getTotalLines())).compareTo(preOrder.getTotalLines()) > 0) {
                    DecimalFormat format = DisplayType.getNumberFormat(12);
                    throw new AdempiereException("[@ConsumedAmt@] > @PreOrderAmt@ (@PreOrderAmt@ = " + format.format(preOrder.getTotalLines()) + ", @ConsumedAmt@ = " + format.format(consumeAmount) + Env.NL + "@amount.difference@ = " + format.format(preOrder.getTotalLines().subtract(consumeAmount)) + ")");
                }
                if (reverseDocumentTypeId > 0) {
                    MOrder reverseOrder = new MOrder(sourceOrder.getCtx(), 0, sourceOrder.get_TrxName());
                    PO.copyValues(preOrder, reverseOrder);
                    reverseOrder.setDocumentNo(null);
                    reverseOrder.setC_DocTypeTarget_ID(reverseDocumentTypeId);
                    reverseOrder.setDateOrdered(sourceOrder.getDateOrdered());
                    reverseOrder.setDatePromised(sourceOrder.getDatePromised());
                    reverseOrder.setPOReference(sourceOrder.getDocumentNo());
                    reverseOrder.addDescription(Msg.parseTranslation(sourceOrder.getCtx(), "@Generated@ [@C_Order_ID@ " + sourceOrder.getDocumentNo()) + "]");
                    reverseOrder.setDocStatus("DR");
                    reverseOrder.setDocAction("CO");
                    reverseOrder.setTotalLines(Env.ZERO);
                    reverseOrder.setGrandTotal(Env.ZERO);
                    reverseOrder.setIsSOTrx(sourceOrder.isSOTrx());
                    reverseOrder.setRef_Order_ID(-1);
                    reverseOrder.setIsDropShip(false);
                    reverseOrder.setDropShip_BPartner_ID(0);
                    reverseOrder.setDropShip_Location_ID(0);
                    reverseOrder.setDropShip_User_ID(0);
                    reverseOrder.set_ValueOfColumn("ConsumptionOrder_ID", (Object)sourceOrder.getC_Order_ID());
                    reverseOrder.set_ValueOfColumn("PreOrder_ID", (Object)preOrder.getC_Order_ID());
                    reverseOrder.set_ValueOfColumn("IsAllowToInvoice", (Object)false);
                    reverseOrder.saveEx();
                    DB.executeUpdateEx("update c_order set link_order_id = null where c_order_id = " + reverseOrder.get_ID(), sourceOrder.get_TrxName());
                    MOrderLine preOrderLine = preOrder.getLines(true, null)[0];
                    MOrderLine reverseOrderLine = new MOrderLine(reverseOrder);
                    PO.copyValues(reverseOrderLine, preOrderLine);
                    reverseOrderLine.setOrder(reverseOrder);
                    reverseOrderLine.setProduct(preOrderLine.getProduct());
                    reverseOrderLine.setLineNetAmt(Env.ZERO);
                    reverseOrderLine.setQty(Env.ONE);
                    reverseOrderLine.setPrice(sourceOrder.getTotalLines().negate());
                    reverseOrderLine.setTax();
                    reverseOrderLine.saveEx();
                    if (!reverseOrder.processIt("CO")) {
                        throw new AdempiereException(reverseOrder.getProcessMsg());
                    }
                    reverseOrder.saveEx();
                    if (sourceOrder.get_ValueAsInt("PreOrder_ID") <= 0) {
                        sourceOrder.set_ValueOfColumn("PreOrder_ID", (Object)preOrder.getC_Order_ID());
                    }
                    sourceOrder.saveEx();
                }
            }
        }
    }

    private static void createCommissionForOrder(MOrder order, int commissionTypeId, boolean splitDocuments) {
        if (MOrgInfo.get(order.getCtx(), order.getAD_Org_ID(), order.get_TrxName()).get_ValueAsBoolean("IsExcludeOfCommission")) {
            return;
        }
        AgencyValidator.removeLineFromCommission(order, commissionTypeId);
        new Query(order.getCtx(), "C_Commission", "C_CommissionType_ID = ? AND IsSplitDocuments = ?", order.get_TrxName()).setOnlyActiveRecords(true).setParameters(commissionTypeId, splitDocuments ? "Y" : "N").list().forEach(commissionDefinition -> {
            int documentTypeId = MDocType.getDocType("SOC", order.getAD_Org_ID());
            MCommissionRun commissionRun = new MCommissionRun((MCommission)commissionDefinition);
            commissionRun.setDateDoc(AgencyValidator.getCurrentDate());
            commissionRun.setC_DocType_ID(documentTypeId);
            commissionRun.setDescription(Msg.parseTranslation(order.getCtx(), "@Generate@: @C_Order_ID@ - " + order.getDocumentNo()));
            commissionRun.set_ValueOfColumn("C_Order_ID", (Object)order.getC_Order_ID());
            commissionRun.set_ValueOfColumn("C_Currency_ID", (Object)order.getC_Currency_ID());
            commissionRun.setAD_Org_ID(order.getAD_Org_ID());
            commissionRun.saveEx();
            commissionRun.addFilterValues("C_Order_ID", order.getC_Order_ID());
            commissionRun.setDocStatus("DR");
            if (commissionRun.processIt("CO")) {
                commissionRun.updateFromAmt();
                commissionRun.saveEx();
                if (commissionRun.getGrandTotal() != null && commissionRun.getGrandTotal().compareTo(Env.ZERO) > 0) {
                    if (commissionDefinition.get_ValueAsBoolean("IsSplitDocuments")) {
                        ProcessBuilder.create(order.getCtx()).process(CommissionOrderCreateAbstract.getProcessId()).withRecordId(I_C_CommissionRun.Table_ID, commissionRun.getC_CommissionRun_ID()).withParameter("IsSOTrx", true).withParameter("DateOrdered", commissionRun.getDateDoc()).withParameter("DocAction", "CO").withParameter("C_BPartner_ID", order.getC_BPartner_ID()).withParameter("C_DocType_ID", commissionDefinition.get_ValueAsInt("C_DocTypeOrder_ID")).withoutTransactionClose().execute(order.get_TrxName());
                    } else {
                        commissionRun.getCommissionAmtList().stream().filter(commissionAmt -> commissionAmt.getCommissionAmt() != null && commissionAmt.getCommissionAmt().compareTo(Env.ZERO) > 0).forEach(commissionAmt -> {
                            MOrderLine orderLine = new MOrderLine(order);
                            orderLine.setC_Charge_ID(commissionDefinition.getC_Charge_ID());
                            orderLine.setQty(Env.ONE);
                            orderLine.setPrice(commissionAmt.getCommissionAmt());
                            orderLine.setTax();
                            orderLine.saveEx(order.get_TrxName());
                        });
                    }
                }
            } else {
                throw new AdempiereException(commissionRun.getProcessMsg());
            }
        });
    }

    public static void createCommissionForInvoice(MInvoice invoice, int commissionTypeId, boolean splitDocuments) {
        if (MOrgInfo.get(invoice.getCtx(), invoice.getAD_Org_ID(), invoice.get_TrxName()).get_ValueAsBoolean("IsExcludeOfCommission")) {
            return;
        }
        AgencyValidator.removeLineFromCommission(invoice, commissionTypeId);
        ArrayList<MCommissionRun> currentCRuns = new ArrayList<MCommissionRun>();
        AtomicReference<BigDecimal> reverseAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        new Query(invoice.getCtx(), "C_Commission", "C_CommissionType_ID = ? AND IsSplitDocuments = ?", invoice.get_TrxName()).setOnlyActiveRecords(true).setParameters(commissionTypeId, splitDocuments ? "Y" : "N").list().forEach(commissionDefinition -> {
            int documentTypeId = MDocType.getDocType("SOC", invoice.getAD_Org_ID());
            MCommissionRun commissionRun = new MCommissionRun((MCommission)commissionDefinition);
            commissionRun.setDateDoc(invoice.getDateInvoiced());
            commissionRun.setC_DocType_ID(documentTypeId);
            commissionRun.setDescription(Msg.parseTranslation(invoice.getCtx(), "@Generate@: @C_Order_ID@ - " + invoice.getDocumentNo()));
            if (invoice.getC_Order_ID() > 0) {
                commissionRun.set_ValueOfColumn("C_Order_ID", (Object)invoice.getC_Order_ID());
            }
            commissionRun.set_ValueOfColumn("C_Invoice_ID", (Object)invoice.getC_Invoice_ID());
            commissionRun.set_ValueOfColumn("C_Currency_ID", (Object)invoice.getC_Currency_ID());
            commissionRun.setAD_Org_ID(invoice.getAD_Org_ID());
            commissionRun.saveEx();
            commissionRun.addFilterValues("C_Invoice_ID", invoice.getC_Invoice_ID());
            if (!invoice.isSOTrx()) {
                List<MInvoice> refInvoices = AgencyValidator.getReferencedCorrectionNotes(invoice);
                for (MInvoice refInvoice : refInvoices) {
                    commissionRun.addArrayFilterValues("C_Invoice_ID", refInvoice.get_ID());
                }
            }
            commissionRun.setDocStatus("DR");
            if (commissionRun.processIt("CO")) {
                commissionRun.updateFromAmt();
                commissionRun.saveEx();
                if (commissionRun.getGrandTotal() != null && commissionRun.getGrandTotal().compareTo(Env.ZERO) > 0) {
                    if (commissionDefinition.get_ValueAsBoolean("IsSplitDocuments")) {
                        ProcessBuilder.create(invoice.getCtx()).process(CommissionOrderCreateAbstract.getProcessId()).withRecordId(I_C_CommissionRun.Table_ID, commissionRun.getC_CommissionRun_ID()).withParameter("IsSOTrx", true).withParameter("DateOrdered", invoice.getDateInvoiced()).withParameter("DocAction", "CO").withParameter("C_BPartner_ID", invoice.getC_BPartner_ID()).withParameter("C_DocType_ID", commissionDefinition.get_ValueAsInt("C_DocTypeOrder_ID")).withoutTransactionClose().execute(invoice.get_TrxName());
                        reverseAmount.updateAndGet(reverse -> reverse.add(commissionRun.getGrandTotal()));
                    } else {
                        commissionRun.getCommissionAmtList().stream().filter(commissionAmt -> commissionAmt.getCommissionAmt() != null && commissionAmt.getCommissionAmt().compareTo(Env.ZERO) > 0).forEach(commissionAmt -> {
                            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                            invoiceLine.setC_Charge_ID(commissionDefinition.getC_Charge_ID());
                            invoiceLine.setQty(Env.ONE);
                            invoiceLine.setPrice(commissionAmt.getCommissionAmt());
                            invoiceLine.setTax();
                            invoiceLine.saveEx(invoice.get_TrxName());
                        });
                    }
                }
            } else {
                throw new AdempiereException(commissionRun.getProcessMsg());
            }
            currentCRuns.add(commissionRun);
        });
        AgencyValidator.reversePreviousCommissionOrders(invoice, reverseAmount.get().negate());
        AgencyValidator.closePreviousInvoiceCRun(invoice, currentCRuns);
    }

    private static void closePreviousInvoiceCRun(MInvoice invoice, List<MCommissionRun> currentCRuns) {
        try {
            Object sqlPrevCRunInv = "docStatus<>'CL' AND C_Invoice_ID=? AND C_Order_ID=?";
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(invoice.get_ID());
            params.add(invoice.getC_Order_ID());
            if (!currentCRuns.isEmpty()) {
                sqlPrevCRunInv = (String)sqlPrevCRunInv + " AND C_CommissionRun_ID NOT IN (";
                sqlPrevCRunInv = (String)sqlPrevCRunInv + currentCRuns.stream().map(mCommissionRun -> String.valueOf(mCommissionRun.get_ID())).collect(Collectors.joining(","));
                sqlPrevCRunInv = (String)sqlPrevCRunInv + " )";
            }
            List prevCRuns = new Query(invoice.getCtx(), "C_CommissionRun", (String)sqlPrevCRunInv, invoice.get_TrxName()).setParameters(params).list();
            for (MCommissionRun prevCRun : prevCRuns) {
                prevCRun.processIt("CL");
                prevCRun.saveEx();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void removeLineFromCommission(MOrder order, int commissionTypeId) {
        String whereClause = " AND EXISTS(SELECT 1 FROM C_Commission c WHERE c.C_CommissionType_ID = " + commissionTypeId + " AND c.C_Charge_ID = C_OrderLine.C_Charge_ID)";
        for (MOrderLine line : order.getLines(whereClause, "")) {
            line.deleteEx(true);
        }
    }

    private static void removeLineFromCommission(MInvoice invoice, int commissionTypeId) {
        String whereClause = "EXISTS(SELECT 1 FROM C_Commission c WHERE c.C_CommissionType_ID = " + commissionTypeId + " AND c.C_Charge_ID = C_InvoiceLine.C_Charge_ID)";
        List invoiceLineList = new Query(invoice.getCtx(), "C_InvoiceLine", whereClause, invoice.get_TrxName()).list();
        for (MInvoiceLine line : invoiceLineList) {
            line.deleteEx(true);
        }
    }

    public static List<MInvoice> getReferencedCorrectionNotes(MInvoice mInvoice) {
        ArrayList<MInvoice> ret = new ArrayList<MInvoice>();
        try {
            if (mInvoice.getC_DocType().getDocBaseType().endsWith("I")) {
                List mAllocationHdrs = Arrays.stream(MAllocationHdr.getOfInvoice(mInvoice.getCtx(), mInvoice.get_ID(), mInvoice.get_TrxName())).filter(mAllocationHdr -> mAllocationHdr.getDocStatus().equalsIgnoreCase("CO")).collect(Collectors.toList());
                for (MAllocationHdr mAllocationHdr2 : mAllocationHdrs) {
                    MAllocationLine[] mAllocationLines;
                    for (MAllocationLine mAllocationLine : mAllocationLines = mAllocationHdr2.getLines(true)) {
                        MInvoice refInv = mAllocationLine.getInvoice();
                        if (refInv.get_ID() == mInvoice.get_ID() || !refInv.getC_DocType().getDocBaseType().endsWith("C")) continue;
                        ret.add(refInv);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

