/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.model.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.X_C_DocType;
import org.adempiere.core.domains.models.X_FM_Agreement;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAccountProduct;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.util.FinancialSetting;

public class LoanManagement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LoanManagement.class);
    private int clientId = -1;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        if (mClient != null) {
            this.clientId = mClient.getAD_Client_ID();
        }
        modelValidationEngine.addModelChange("FM_Agreement", this);
        modelValidationEngine.addModelChange("C_Invoice", this);
        modelValidationEngine.addDocValidate("FM_Agreement", this);
        modelValidationEngine.addDocValidate("C_PaySelection", this);
        modelValidationEngine.addDocValidate("C_Payment", this);
        modelValidationEngine.addDocValidate("C_Invoice", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public String login(int n, int n2, int n3) {
        return null;
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        block11: {
            block9: {
                block10: {
                    if (!pO.get_TableName().equals("FM_Agreement")) break block9;
                    if (n != 4 && n != 5) break block10;
                    log.fine("FM_Agreement = type == TYPE_AFTER_NEW || type == TYPE_AFTER_CHANGE");
                    MFMAgreement mFMAgreement = (MFMAgreement)pO;
                    if (mFMAgreement.isProcessed()) {
                        return null;
                    }
                    if (mFMAgreement.getFM_Product_ID() == 0) break block11;
                    List<MFMAccount> list = MFMAccount.getAccountFromAgreement(mFMAgreement);
                    MFMAccount mFMAccount = null;
                    if (list.isEmpty()) {
                        mFMAccount = new MFMAccount(mFMAgreement);
                        mFMAccount.saveEx();
                    } else {
                        mFMAccount = list.get(0);
                    }
                    MFMAccountProduct mFMAccountProduct = new MFMAccountProduct(mFMAccount);
                    mFMAccountProduct.setFM_Product_ID(mFMAgreement.getFM_Product_ID());
                    mFMAccountProduct.setValidFrom(mFMAgreement.getDateDoc());
                    mFMAccountProduct.saveEx();
                    break block11;
                }
                if (n != 6) break block11;
                log.fine("FM_Agreement = type == TYPE_AFTER_DELETE");
                MFMAgreement mFMAgreement = (MFMAgreement)pO;
                if (mFMAgreement.isProcessed()) {
                    return null;
                }
                List<MFMAccount> list = MFMAccount.getAccountFromAgreement(mFMAgreement);
                for (MFMAccount mFMAccount : list) {
                    mFMAccount.deleteEx(true);
                }
                break block11;
            }
            if (pO.get_TableName().equals("C_Invoice") && n == 5) {
                log.fine("C_Invoice = type == TYPE_AFTER_CHANGE");
                MInvoice mInvoice = (MInvoice)pO;
                if (mInvoice.is_ValueChanged("IsPaid")) {
                    boolean bl = mInvoice.isPaid();
                    if (!mInvoice.getDocStatus().equals("CO") && !mInvoice.getDocStatus().equals("CL")) {
                        bl = false;
                    }
                    for (MInvoiceLine mInvoiceLine : mInvoice.getLines()) {
                        if (mInvoiceLine.get_ValueAsInt("FM_Amortization_ID") == 0) continue;
                        MFMAmortization mFMAmortization = new MFMAmortization(mInvoice.getCtx(), mInvoiceLine.get_ValueAsInt("FM_Amortization_ID"), mInvoice.get_TrxName());
                        mFMAmortization.setIsPaid(bl);
                        mFMAmortization.saveEx();
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String docValidate(PO pO, int n) {
        if (pO instanceof MPaySelection) {
            if (n == 7) {
                MPaySelection mPaySelection = (MPaySelection)pO;
                String string = new String("SELECT ag.FM_Agreement_ID, ag.DocumentNo FROM FM_Agreement ag INNER JOIN FM_Account ac ON(ac.FM_Agreement_ID = ag.FM_Agreement_ID) INNER JOIN (SELECT pl.FM_Account_ID, SUM(pl.AmtSource) AmtSource FROM C_PaySelectionLine pl WHERE EXISTS(SELECT 1 FROM C_PaySelection ps \t\t\t\tWHERE ps.C_PaySelection_ID = pl.C_PaySelection_ID \t\t\t\tAND ps.DocStatus IN('CO')) \t\t\t\tGROUP BY pl.FM_Account_ID) ps ON(ps.FM_Account_ID = ac.FM_Account_ID) WHERE ac.CapitalAmt = COALESCE(ps.AmtSource, 0) AND EXISTS(SELECT 1 FROM C_PaySelectionLine pl WHERE pl.FM_Account_ID = ac.FM_Account_ID AND pl.C_PaySelection_ID = ?)");
                KeyNamePair[] keyNamePairArray = DB.getKeyNamePairs(mPaySelection.get_TrxName(), string, false, mPaySelection.getC_PaySelection_ID());
                if (keyNamePairArray != null && keyNamePairArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (KeyNamePair keyNamePair : keyNamePairArray) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",").append(Env.NL);
                        }
                        stringBuffer.append(keyNamePair.getName());
                    }
                    if (stringBuffer.length() > 0) {
                        throw new AdempiereException("@Loan@ @Processed@ [" + stringBuffer.toString() + "]");
                    }
                }
            }
        } else if (pO instanceof MPayment) {
            if (n == 9 || n == 13 || n == 14 || n == 10) {
                MPayment mPayment = (MPayment)pO;
                if (n == 9 && mPayment.getReversal_ID() != 0) {
                    return null;
                }
                String string = new String("EXISTS(SELECT 1 FROM C_PaySelectionLine pl INNER JOIN C_PaySelectionCheck pc ON(pc.C_PaySelectionCheck_ID = pl.C_PaySelectionCheck_ID) WHERE pl.FM_Account_ID = FM_Account.FM_Account_ID AND pc.C_Payment_ID = ?)");
                List list = new Query(mPayment.getCtx(), "FM_Account", string, mPayment.get_TrxName()).setParameters(mPayment.getC_Payment_ID()).list();
                if (list != null && list.size() > 0) {
                    list.stream().forEach(mFMAccount -> {
                        mFMAccount.set_ValueOfColumn("IsPaid", (Object)(n == 9 ? 1 : 0));
                        mFMAccount.saveEx();
                    });
                }
            }
        } else if (pO instanceof MFMAgreement) {
            MFMAgreement mFMAgreement = (MFMAgreement)pO;
            if (n == 7) {
                if (!mFMAgreement.isSOTrx()) {
                    return null;
                }
                String string = new String("SELECT la.DocumentNo, SUM(COALESCE(la.CurrentDunningAmt, 0)) AS CurrentDunningAmt FROM RV_FM_LoanAmortization la WHERE DocStatus IN('CO') AND C_BPartner_ID = ? AND la.IsSOTrx = 'Y' AND (la.IsPaid = 'N' OR la.IsInvoiced = 'N') GROUP BY la.DocumentNo HAVING(SUM(COALESCE(la.CurrentDunningAmt, 0)) > 0)");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(mFMAgreement.getC_BPartner_ID());
                ValueNamePair[] valueNamePairArray = DB.getValueNamePairs(string, false, arrayList);
                if (valueNamePairArray != null && valueNamePairArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer(Msg.getMsg(mFMAgreement.getCtx(), "Loan.DunningBalanceOpen"));
                    String string2 = Msg.getMsg(mFMAgreement.getCtx(), "Loan");
                    for (ValueNamePair valueNamePair : valueNamePairArray) {
                        if (Util.isEmpty(valueNamePair.getName())) continue;
                        stringBuffer.append(Env.NL);
                        BigDecimal bigDecimal = new BigDecimal(valueNamePair.getName());
                        stringBuffer.append("- " + string2 + ": " + valueNamePair.getID() + " = " + DisplayType.getNumberFormat(12).format(bigDecimal));
                    }
                    mFMAgreement.set_ValueOfColumn("LastResult", (Object)stringBuffer.toString());
                    mFMAgreement.saveEx();
                }
            } else if (n == 9) {
                List<MFMAccount> list = mFMAgreement.getAccounts();
                if (list != null && !list.isEmpty()) {
                    BigDecimal bigDecimal = Env.ZERO;
                    BigDecimal bigDecimal2 = Env.ZERO;
                    BigDecimal bigDecimal3 = Env.ZERO;
                    for (MFMAccount mFMAccount2 : list) {
                        void var7_35;
                        void stringBuffer;
                        List<MFMAmortization> list2 = MFMAmortization.getFromAccount(mFMAccount2.getFM_Account_ID(), mFMAccount2.get_TrxName());
                        for (MFMAmortization mFMAmortization : list2) {
                            if (mFMAmortization.getCapitalAmt() != null) {
                                BigDecimal bl = stringBuffer.add(mFMAmortization.getCapitalAmt());
                            }
                            if (mFMAmortization.getInterestAmt() != null) {
                                bigDecimal2 = bigDecimal2.add(mFMAmortization.getInterestAmt());
                            }
                            if (mFMAmortization.getTaxAmt() == null) continue;
                            BigDecimal bigDecimal4 = var7_35.add(mFMAmortization.getTaxAmt());
                        }
                        if (mFMAccount2.get_Value("CapitalAmt") == null || ((BigDecimal)mFMAccount2.get_Value("CapitalAmt")).equals(Env.ZERO)) {
                            mFMAccount2.set_ValueOfColumn("CapitalAmt", (Object)stringBuffer);
                        }
                        if (mFMAccount2.get_Value("InterestAmt") == null || ((BigDecimal)mFMAccount2.get_Value("InterestAmt")).equals(Env.ZERO)) {
                            mFMAccount2.set_ValueOfColumn("InterestAmt", (Object)bigDecimal2);
                        }
                        if (mFMAccount2.get_Value("TaxAmt") == null || ((BigDecimal)mFMAccount2.get_Value("TaxAmt")).equals(Env.ZERO)) {
                            mFMAccount2.set_ValueOfColumn("TaxAmt", (Object)var7_35);
                        }
                        mFMAccount2.saveEx();
                    }
                }
            } else if (n == 5 || n == 6 || n == 2 || n == 4) {
                List<MFMAccount> list = mFMAgreement.getAccounts();
                StringBuffer mFMAccount3 = new StringBuffer();
                if (list != null && !list.isEmpty()) {
                    for (MFMAccount mFMAccount4 : list) {
                        if (mFMAccount3.length() > 0) {
                            mFMAccount3.append(", ");
                        }
                        mFMAccount3.append(mFMAccount4.getFM_Account_ID());
                    }
                }
                if (mFMAccount3.length() > 0) {
                    Object object = new String("SELECT ps.C_PaySelection_ID, ps.DocumentNo FROM C_PaySelection ps INNER JOIN C_PaySelectionLine pl ON(pl.C_PaySelection_ID = ps.C_PaySelection_ID) WHERE ps.DocStatus IN('CO', 'CL') AND pl.FM_Account_ID IN(" + mFMAccount3.toString() + ")");
                    KeyNamePair[] keyNamePairArray = DB.getKeyNamePairs(mFMAgreement.get_TrxName(), (String)object, false, new Object[0]);
                    object = new String("SELECT p.C_Payment_ID, p.DocumentNo FROM C_PaySelectionLine pl INNER JOIN C_PaySelectionCheck pc ON(pc.C_PaySelectionCheck_ID = pl.C_PaySelectionCheck_ID) INNER JOIN C_Payment p ON(p.C_Payment_ID = pc.C_Payment_ID) WHERE p.DocStatus IN('CO', 'CL') AND EXISTS(SELECT 1 FROM C_PaySelection ps \t\t\t\tWHERE ps.C_PaySelection_ID = pl.C_PaySelection_ID\t\t\t\tAND ps.DocStatus IN('CO', 'CL')) AND pl.FM_Account_ID IN(" + mFMAccount3.toString() + ")");
                    KeyNamePair[] keyNamePairArray2 = DB.getKeyNamePairs(mFMAgreement.get_TrxName(), (String)object, false, new Object[0]);
                    object = new String("SELECT i.C_Invoice_ID, i.DocumentNo FROM C_Invoice i WHERE i.DocStatus IN('CO', 'CL') AND i.FM_Account_ID IN(" + mFMAccount3.toString() + ")");
                    KeyNamePair[] keyNamePairArray3 = DB.getKeyNamePairs(mFMAgreement.get_TrxName(), (String)object, false, new Object[0]);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (keyNamePairArray != null && keyNamePairArray.length > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(Env.NL);
                        }
                        stringBuffer.append(Msg.getElement(mFMAgreement.getCtx(), "C_PaySelection_ID"));
                        for (KeyNamePair keyNamePair : keyNamePairArray) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(Env.NL);
                            }
                            stringBuffer.append(keyNamePair.getName());
                        }
                    }
                    if (keyNamePairArray2 != null && keyNamePairArray2.length > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(Env.NL);
                        }
                        stringBuffer.append(Msg.getElement(mFMAgreement.getCtx(), "C_Payment_ID"));
                        for (KeyNamePair keyNamePair : keyNamePairArray2) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(Env.NL);
                            }
                            stringBuffer.append(keyNamePair.getName());
                        }
                    }
                    if (keyNamePairArray3 != null && keyNamePairArray3.length > 0) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(Env.NL);
                        }
                        stringBuffer.append(Msg.getElement(mFMAgreement.getCtx(), "C_Invoice_ID"));
                        for (KeyNamePair keyNamePair : keyNamePairArray3) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(Env.NL);
                            }
                            stringBuffer.append(keyNamePair.getName());
                        }
                    }
                    if (stringBuffer.length() > 0) {
                        return Msg.getMsg(mFMAgreement.getCtx(), "SQLErrorReferenced") + Env.NL + stringBuffer.toString();
                    }
                }
            }
        } else if (pO.get_TableName().equals("C_Invoice")) {
            Object object;
            MInvoice mInvoice = (MInvoice)pO;
            int n2 = mInvoice.getFM_Account_ID();
            if (n2 <= 0) {
                return null;
            }
            if (n == 7) {
                int n3 = DB.getSQLValue(mInvoice.get_TrxName(), "SELECT MIN(a.PeriodNo) AS PeriodNo FROM C_InvoiceLine il INNER JOIN FM_Amortization a ON(a.FM_Amortization_ID = il.FM_Amortization_ID) WHERE il.C_Invoice_ID = ?", mInvoice.getC_Invoice_ID());
                object = new String("SELECT la.PeriodNo FROM RV_FM_LoanAmortization la WHERE FM_Account_ID = ? AND la.IsSOTrx = 'Y' AND (la.IsPaid = 'N' OR la.IsInvoiced = 'N') AND la.PeriodNo < ?");
                int n4 = DB.getSQLValue(mInvoice.get_TrxName(), (String)object, n2, n3);
                if (n4 > 0) {
                    return Msg.getMsg(mInvoice.getCtx(), "Loan.PreviousFeeUnpaid") + ": " + n4;
                }
            } else if (n == 9) {
                boolean bl = true;
                if (!mInvoice.getDocStatus().equals("CO") && !mInvoice.getDocStatus().equals("CL") && !mInvoice.getDocStatus().equals("IP") || mInvoice.getReversal_ID() != 0) {
                    boolean bl2 = false;
                } else {
                    object = MDocType.get(mInvoice.getCtx(), mInvoice.getC_DocType_ID());
                    if (((X_C_DocType)object).getDocBaseType().endsWith("C")) {
                        boolean bl3 = false;
                    }
                }
                for (MInvoiceLine mInvoiceLine : mInvoice.getLines()) {
                    void var5_24;
                    if (mInvoiceLine.getFM_Amortization_ID() == 0) continue;
                    MFMAmortization mFMAmortization = new MFMAmortization(mInvoice.getCtx(), mInvoiceLine.getFM_Amortization_ID(), mInvoice.get_TrxName());
                    mFMAmortization.setIsInvoiced((boolean)var5_24);
                    if (var5_24 == false) {
                        mFMAmortization.setIsPaid(false);
                    }
                    mFMAmortization.saveEx();
                }
            }
            MFMAccount mFMAccount5 = new MFMAccount(mInvoice.getCtx(), n2, mInvoice.get_TrxName());
            object = (MFMAgreement)mFMAccount5.getFM_Agreement();
            String string = FinancialSetting.get().fireDocValidate(mInvoice, n, ((X_FM_Agreement)object).getFM_Product_ID());
            if (string != null) {
                return string;
            }
        }
        return null;
    }
}

