/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.spin.investment.loan.util.AmortizationValue;
import org.spin.investment.loan.util.LoanUtil;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMBatch;
import org.spin.investment.model.MFMFunctionalSetting;
import org.spin.investment.model.MFMTransaction;
import org.spin.investment.model.MFMTransactionType;
import org.spin.investment.util.AbstractFunctionalSetting;

public class LoanProvisionProcess
extends AbstractFunctionalSetting {
    public LoanProvisionProcess(MFMFunctionalSetting mFMFunctionalSetting) {
        super(mFMFunctionalSetting);
    }

    @Override
    public String run() {
        MFMAgreement mFMAgreement = (MFMAgreement)this.getParameter("MFMAgreement");
        MFMBatch mFMBatch = (MFMBatch)this.getParameter("MFMBatch");
        String string = (String)this.getParameter("TRX_NAME");
        if (mFMAgreement == null || mFMBatch == null) {
            return null;
        }
        MFMTransactionType mFMTransactionType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LPC");
        if (mFMTransactionType == null) {
            throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LPC");
        }
        HashMap<String, Object> hashMap = LoanUtil.calculateLoanProvision(this.getCtx(), mFMAgreement.getFM_Agreement_ID(), new Timestamp(System.currentTimeMillis()), string);
        if (hashMap == null || hashMap.isEmpty()) {
            return null;
        }
        List list = (List)hashMap.get("AMORTIZATION_LIST");
        if (list == null) {
            return null;
        }
        for (AmortizationValue amortizationValue : list) {
            MFMTransaction mFMTransaction = mFMBatch.addTransaction(mFMTransactionType.getFM_TransactionType_ID(), amortizationValue.getProvisionAmt());
            if (mFMTransaction == null) continue;
            mFMTransaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationValue.getAmortizationId());
            mFMTransaction.saveEx();
        }
        return null;
    }
}

