/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.spin.investment.loan.util.AmortizationValue;
import org.spin.investment.loan.util.LoanUtil;
import org.spin.investment.model.MFMAccount;
import org.spin.investment.model.MFMAgreement;
import org.spin.investment.model.MFMAmortization;
import org.spin.investment.model.MFMAmortizationSummary;
import org.spin.investment.model.MFMBatch;
import org.spin.investment.model.MFMFunctionalSetting;
import org.spin.investment.model.MFMTransaction;
import org.spin.investment.model.MFMTransactionType;
import org.spin.investment.util.AbstractFunctionalSetting;

public class LoanDunningProcess
extends AbstractFunctionalSetting {
    public LoanDunningProcess(MFMFunctionalSetting setting) {
        super(setting);
    }

    @Override
    public String run() {
        MFMAgreement agreement = (MFMAgreement)this.getParameter("MFMAgreement");
        MFMBatch batch = (MFMBatch)this.getParameter("MFMBatch");
        String trxName = (String)this.getParameter("TRX_NAME");
        if (agreement == null || batch == null) {
            return null;
        }
        MFMTransactionType dunningType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LDD");
        MFMTransactionType dunningTaxType = MFMTransactionType.getTransactionTypeFromType(this.getCtx(), "LDT");
        if (dunningType == null) {
            throw new AdempiereException("@FM_TransactionType_ID@ @NotFound@ LDD");
        }
        HashMap<String, Object> returnValues = LoanUtil.calculateLoanDunning(this.getCtx(), agreement.getFM_Agreement_ID(), new Timestamp(System.currentTimeMillis()), trxName);
        if (returnValues == null || returnValues.isEmpty()) {
            return null;
        }
        List amortizationList = (List)returnValues.get("AMORTIZATION_LIST");
        if (amortizationList == null) {
            return null;
        }
        AtomicReference<BigDecimal> capitalAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> dunningAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> dunningTaxAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        amortizationList.forEach(amortization -> {
            capitalAmount.updateAndGet(amount -> amount.add(amortization.getCapitalAmtFee()));
            dunningAmount.updateAndGet(amount -> amount.add(amortization.getDunningInterestAmount()));
            dunningTaxAmount.updateAndGet(amount -> amount.add(amortization.getDunningTaxAmt()));
        });
        List<MFMAccount> accounts = MFMAccount.getAccountFromAgreement(agreement);
        MFMAccount account = null;
        if (accounts.isEmpty()) {
            account = new MFMAccount(agreement);
            account.saveEx();
        } else {
            account = accounts.get(0);
        }
        for (AmortizationValue amortizationReferencia : amortizationList) {
            MFMTransaction transaction = batch.addTransaction(dunningType.getFM_TransactionType_ID(), amortizationReferencia.getDunningInterestAmount());
            if (transaction != null) {
                transaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationReferencia.getAmortizationId());
                transaction.saveEx();
            }
            if (dunningTaxType != null && amortizationReferencia.getDunningTaxAmt() != null && (transaction = batch.addTransaction(dunningTaxType.getFM_TransactionType_ID(), amortizationReferencia.getDunningTaxAmt())) != null) {
                transaction.set_ValueOfColumn("FM_Amortization_ID", (Object)amortizationReferencia.getAmortizationId());
                transaction.saveEx();
            }
            MFMAmortization amortization2 = new MFMAmortization(this.getCtx(), amortizationReferencia.getAmortizationId(), trxName);
            amortization2.setCurrentCapitalAmt(amortizationReferencia.getCapitalAmtFee());
            amortization2.setCurrentDunningAmt(amortizationReferencia.getDunningInterestAmount());
            amortization2.setCurrentDunningTaxAmt(amortizationReferencia.getDunningTaxAmt());
            amortization2.setCurrentInterestAmt(amortizationReferencia.getInterestAmtFee());
            amortization2.setCurrentTaxAmt(amortizationReferencia.getTaxAmtFee());
            amortization2.saveEx();
            MFMAmortizationSummary.setCurrentDunning(this.getCtx(), account.getFM_Account_ID(), amortizationReferencia.getAmortizationId(), batch.getDateDoc(), capitalAmount.get(), dunningAmount.get(), dunningTaxAmount.get(), trxName);
        }
        return null;
    }
}

