/*
 * Decompiled with CFR 0.152.
 */
package org.spin.investment.loan.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.TimeUtil;
import org.spin.investment.model.MFMAmortization;

public class AmortizationValue {
    private int periodNo = 0;
    private Timestamp startDate;
    private Timestamp endDate;
    private Timestamp dueDate;
    private int dayOfMonth = 0;
    private int cumulativeDays = 0;
    private BigDecimal remainingCapital;
    private BigDecimal monthInterest;
    private BigDecimal cumulativeInterest;
    private BigDecimal dailyInterest;
    private BigDecimal interestAmtFee;
    private BigDecimal capitalAmtFee;
    private BigDecimal taxAmtFee;
    private BigDecimal dailyInterestAmt;
    private BigDecimal fixedFeeAmt;
    private int amortizationId;
    private int daysDue;
    private BigDecimal dunningDailyInterest;
    private BigDecimal dunningInterestAmount;
    private BigDecimal dunningTaxRate;
    private BigDecimal dunningTaxAmt;
    private boolean isPaid;
    private BigDecimal provisionAmt;

    public AmortizationValue() {
    }

    public AmortizationValue(MFMAmortization mFMAmortization) {
        this.setPeriodNo(mFMAmortization.getPeriodNo());
        this.setStartDate(mFMAmortization.getStartDate());
        this.setEndDate(mFMAmortization.getEndDate());
        this.setDueDate(mFMAmortization.getDueDate());
        this.setCapitalAmtFee(mFMAmortization.getCapitalAmt());
        this.setTaxAmtFee(mFMAmortization.getTaxAmt());
        this.setInterestAmtFee(mFMAmortization.getInterestAmt());
        this.setAmortizationId(mFMAmortization.getFM_Amortization_ID());
        this.setPaid(mFMAmortization.isPaid());
    }

    public int getPeriodNo() {
        return this.periodNo;
    }

    public void setPeriodNo(int n) {
        this.periodNo = n;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Timestamp timestamp) {
        this.startDate = timestamp;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp timestamp) {
        this.endDate = timestamp;
    }

    public int getDayOfMonth() {
        if (this.dayOfMonth == 0 && this.getStartDate() != null && this.getEndDate() != null) {
            this.dayOfMonth = TimeUtil.getDaysBetween(this.getStartDate(), this.getEndDate(), new int[0]);
        }
        return this.dayOfMonth;
    }

    public int getDayOfMonth(Timestamp timestamp) {
        if (this.getStartDate() != null && timestamp != null) {
            return TimeUtil.getDaysBetween(this.getStartDate(), timestamp, new int[0]);
        }
        return 0;
    }

    public void setDayOfMonth(int n) {
        this.dayOfMonth = n;
    }

    public int getCumulativeDays() {
        return this.cumulativeDays;
    }

    public void setCumulativeDays(int n) {
        this.cumulativeDays = n;
    }

    public BigDecimal getRemainingCapital() {
        return this.remainingCapital;
    }

    public void setRemainingCapital(BigDecimal bigDecimal) {
        this.remainingCapital = bigDecimal;
    }

    public BigDecimal getMonthInterest() {
        return this.monthInterest;
    }

    public void setMonthInterest(BigDecimal bigDecimal) {
        this.monthInterest = bigDecimal;
    }

    public BigDecimal getCumulativeInterest() {
        return this.cumulativeInterest;
    }

    public void setCumulativeInterest(BigDecimal bigDecimal) {
        this.cumulativeInterest = bigDecimal;
    }

    public BigDecimal getDailyInterest() {
        return this.dailyInterest;
    }

    public void setDailyInterest(BigDecimal bigDecimal) {
        this.dailyInterest = bigDecimal;
    }

    public BigDecimal getInterestAmtFee() {
        return this.interestAmtFee;
    }

    public void setInterestAmtFee(BigDecimal bigDecimal) {
        this.interestAmtFee = bigDecimal;
    }

    public BigDecimal getCapitalAmtFee() {
        return this.capitalAmtFee;
    }

    public void setCapitalAmtFee(BigDecimal bigDecimal) {
        this.capitalAmtFee = bigDecimal;
    }

    public BigDecimal getDailyInterestAmt() {
        return this.dailyInterestAmt;
    }

    public void setDailyInterestAmt(BigDecimal bigDecimal) {
        this.dailyInterestAmt = bigDecimal;
    }

    public BigDecimal getTaxAmtFee() {
        return this.taxAmtFee;
    }

    public void setTaxAmtFee(BigDecimal bigDecimal) {
        this.taxAmtFee = bigDecimal;
    }

    public BigDecimal getFixedFeeAmt() {
        return this.fixedFeeAmt;
    }

    public void setFixedFeeAmt(BigDecimal bigDecimal) {
        this.fixedFeeAmt = bigDecimal;
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Timestamp timestamp) {
        this.dueDate = timestamp;
    }

    public int getAmortizationId() {
        return this.amortizationId;
    }

    public void setAmortizationId(int n) {
        this.amortizationId = n;
    }

    public int getDaysDue() {
        return this.daysDue;
    }

    public int getDaysDue(Timestamp timestamp) {
        if (this.getDueDate() != null && timestamp != null) {
            this.daysDue = TimeUtil.getDaysBetween(this.getDueDate(), timestamp, new int[0]);
        }
        return this.daysDue;
    }

    public void setDaysDue(int n) {
        this.daysDue = n;
    }

    public BigDecimal getDunningDailyInterest() {
        return this.dunningDailyInterest;
    }

    public void setDunningDailyInterest(BigDecimal bigDecimal) {
        this.dunningDailyInterest = bigDecimal;
    }

    public BigDecimal getDunningInterestAmount() {
        return this.dunningInterestAmount;
    }

    public void setDunningInterestAmount(BigDecimal bigDecimal) {
        this.dunningInterestAmount = bigDecimal;
    }

    public BigDecimal getDunningTaxRate() {
        return this.dunningTaxRate;
    }

    public void setDunningTaxRate(BigDecimal bigDecimal) {
        this.dunningTaxRate = bigDecimal;
    }

    public BigDecimal getDunningTaxAmt() {
        return this.dunningTaxAmt;
    }

    public void setDunningTaxAmt(BigDecimal bigDecimal) {
        this.dunningTaxAmt = bigDecimal;
    }

    public boolean isPaid() {
        return this.isPaid;
    }

    public void setPaid(boolean bl) {
        this.isPaid = bl;
    }

    public BigDecimal getProvisionAmt() {
        return this.provisionAmt;
    }

    public void setProvisionAmt(BigDecimal bigDecimal) {
        this.provisionAmt = bigDecimal;
    }

    public String toString() {
        return "AmortizationValue [periodNo=" + this.periodNo + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", dueDate=" + this.dueDate + ", dayOfMonth=" + this.dayOfMonth + ", cumulativeDays=" + this.cumulativeDays + ", remainingCapital=" + this.remainingCapital + ", monthInterest=" + this.monthInterest + ", cumulativeInterest=" + this.cumulativeInterest + ", dailyInterest=" + this.dailyInterest + ", interestAmtFee=" + this.interestAmtFee + ", capitalAmtFee=" + this.capitalAmtFee + ", taxAmtFee=" + this.taxAmtFee + ", dailyInterestAmt=" + this.dailyInterestAmt + ", fixedFeeAmt=" + this.fixedFeeAmt + ", amortizationId=" + this.amortizationId + ", daysDue=" + this.daysDue + ", dunningDailyInterest=" + this.dunningDailyInterest + ", dunningInteretAmount=" + this.dunningInterestAmount + ", dunningTaxRate=" + this.dunningTaxRate + ", dunningTaxAmt=" + this.dunningTaxAmt + "]";
    }
}

