/*
 * Decompiled with CFR 0.152.
 */
package org.spin.hr.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.core.domains.models.X_HR_Concept;
import org.compiere.Adempiere;
import org.compiere.model.MRule;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.util.RuleEngineUtil;

public class RuleClassGenerator {
    private final String[] VARIABLES = new String[]{"_HR_Employee_Payroll_Value", "_HR_Employee_Contract", "_HR_Employee_ValidFrom", "_HR_Employee_ValidTo", "_HR_Payroll_Value", "_Process", "_Period", "_Payroll", "_Department", "_PeriodNo", "_HR_Period_ID", "SCOPE_PROCESS", "SCOPE_EMPLOYEE", "SCOPE_CONCEPT", "PERSISTENCE_SAVE", "PERSISTENCE_IGNORE", "ACTION_BREAK", "_C_BPartner_ID", "_HR_Employee_ID", "_C_BPartner", "_HR_Employee", "_DateStart", "_DateEnd", "_Days", "_From", "_To"};
    private MRule rule = null;
    private X_HR_Concept concept = null;
    private String directoryName = null;
    private Map<String, Boolean> importClasses = new HashMap<String, Boolean>();
    private static CLogger log = CLogger.getCLogger(RuleClassGenerator.class);

    public RuleClassGenerator(MRule mRule, String string) {
        this.rule = mRule;
        this.directoryName = string;
        this.concept = (X_HR_Concept)new Query(mRule.getCtx(), "HR_Concept", "EXISTS(SELECT 1 FROM HR_Attribute a WHERE a.HR_Concept_ID = HR_Concept.HR_Concept_ID AND a.AD_Rule_ID = ?)", mRule.get_TrxName()).setParameters(mRule.getAD_Rule_ID()).first();
        this.loadImports();
    }

    private void loadImports() {
        this.importClasses.put("import org.eevolution.model.*;", true);
        this.importClasses.put("import org.compiere.model.*;", true);
        this.importClasses.put("import org.adempiere.model.*;", true);
        this.importClasses.put("import org.compiere.util.*;", true);
        this.importClasses.put("import org.spin.model.*;", true);
        this.importClasses.put("import org.spin.util.*;", true);
        this.importClasses.put("import java.util.*;", true);
        this.importClasses.put("import java.math.*;", true);
        this.importClasses.put("import java.sql.*;", true);
    }

    private String extractImports(String string) {
        Pattern pattern = Pattern.compile("import");
        Matcher matcher = pattern.matcher(string);
        Pattern pattern2 = Pattern.compile(";");
        Matcher matcher2 = pattern2.matcher(string);
        while (matcher.find()) {
            int n = matcher.start();
            if (!matcher2.find(n)) continue;
            String string2 = string.substring(n, matcher2.start() + 1);
            this.importClasses.put(string2, true);
        }
        for (String string2 : this.importClasses.keySet()) {
            string = string.replace(string2, "");
        }
        return string;
    }

    private String getScript() {
        String string = this.rule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
        string = this.extractImports(string);
        String string2 = "double";
        String string3 = "0";
        if ("D".equals(this.concept.getColumnType())) {
            string2 = "Timestamp";
            string3 = "null";
        } else if ("T".equals(this.concept.getColumnType())) {
            string2 = "String";
            string3 = "null";
        }
        String string4 = Env.NL + string2 + " result = " + string3 + ";" + Env.NL + "description = null;" + Env.NL + string;
        return this.changeValues(string4).replaceAll("\\R", "\n\t\t");
    }

    public String createFile() {
        if (this.concept == null || this.concept.getHR_Concept_ID() <= 0) {
            return "";
        }
        String string = RuleEngineUtil.getPackageName(this.rule);
        String string2 = RuleEngineUtil.getClassName(this.rule);
        StringBuffer stringBuffer = this.createHeader(string, string2);
        if (!this.directoryName.endsWith(File.separator)) {
            this.directoryName = this.directoryName + File.separator;
        }
        this.writeToFile(stringBuffer, this.directoryName + string2 + ".java");
        return this.directoryName + string2 + ".java";
    }

    private StringBuffer createHeader(String string2, String string3) {
        String string4 = this.getScript();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/******************************************************************************\n * Product: ADempiere ERP & CRM Smart Business Solution                       *\n * Copyright (C) 2006-2017 ADempiere Foundation, All Rights Reserved.         *\n * This program is free software, you can redistribute it and/or modify it    *\n * under the terms version 2 of the GNU General Public License as published   *\n * or (at your option) any later version.                                     *\n * by the Free Software Foundation. This program is distributed in the hope   *\n * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *\n * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *\n * See the GNU General Public License for more details.                       *\n * You should have received a copy of the GNU General Public License along    *\n * with this program, if not, write to the Free Software Foundation, Inc.,    *\n * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *\n * For the text or an alternative of this public license, you may reach us    *\n * or via info@adempiere.net                                                  *\n * or https://github.com/adempiere/adempiere/blob/develop/license.html        *\n *****************************************************************************/\n");
        stringBuffer.append("\n");
        stringBuffer.append("package ").append(string2).append(";\n");
        stringBuffer.append("\n");
        this.importClasses.keySet().forEach(string -> stringBuffer.append((String)string).append("\n"));
        stringBuffer.append("\n");
        stringBuffer.append("\n\n/** Generated Process for (").append(this.rule.getValue()).append(" ").append(this.rule.getName()).append(")\n");
        if (this.rule.getDescription() != null) {
            stringBuffer.append(" *  Description: ").append(this.rule.getDescription()).append("\n");
        }
        if (this.rule.getHelp() != null) {
            stringBuffer.append(" *  Help: ").append(this.rule.getHelp()).append("\n");
        }
        stringBuffer.append(" *  @author ADempiere (generated) \n").append(" *  @version ").append(Adempiere.MAIN_VERSION).append("\n").append(" */\n");
        stringBuffer.append("public class ").append(RuleEngineUtil.getClassName(this.rule)).append(" implements RuleInterface {");
        stringBuffer.append("\n\n\tString description = null;");
        stringBuffer.append("\n\n\t@Override").append("\n\tpublic Object run(MHRProcess process, Map<String, Object> engineContext) {").append("\n\t\t").append(string4).append("\n\t\treturn result;").append("\n\t}");
        stringBuffer.append("\n\n\t@Override").append("\n\tpublic String getDescription() {").append("\n\t\treturn description;").append("\n\t}");
        stringBuffer.append("\n}");
        return stringBuffer;
    }

    private String changeValues(String string3) {
        AtomicReference<String> atomicReference = new AtomicReference<String>(string3);
        Arrays.asList(this.VARIABLES).stream().filter(string2 -> string3.contains((CharSequence)string2)).forEach(string -> atomicReference.set(((String)atomicReference.get()).replaceAll("\\b" + string + "\\b", this.getValueFromMap((String)string))));
        return atomicReference.get();
    }

    private String getValueFromMap(String string) {
        Object object = string;
        if (string.equals("_Process") || string.equals("_Period") || string.equals("_Payroll") || string.equals("_Department") || string.equals("_PeriodNo") || string.equals("_HR_Period_ID") || string.equals("SCOPE_PROCESS") || string.equals("SCOPE_EMPLOYEE") || string.equals("SCOPE_CONCEPT") || string.equals("PERSISTENCE_SAVE") || string.equals("PERSISTENCE_IGNORE") || string.equals("ACTION_BREAK") || string.equals("_Days") || string.equals("_C_BPartner_ID") || string.equals("_HR_Employee_ID")) {
            object = "((Integer) engineContext.get(\"" + string + "\"))";
        } else if (string.equals("_From") || string.equals("_To") || string.equals("_HR_Employee_ValidFrom") || string.equals("_HR_Employee_ValidTo") || string.equals("_DateStart") || string.equals("_DateEnd")) {
            object = "((Timestamp) engineContext.get(\"" + string + "\"))";
        } else if (string.equals("_HR_Payroll_Value") || string.equals("_HR_Employee_Payroll_Value")) {
            object = "((String) engineContext.get(\"" + string + "\"))";
        } else if (string.equals("_C_BPartner")) {
            object = "((MBPartner) engineContext.get(\"" + string + "\"))";
        } else if (string.equals("_HR_Employee")) {
            object = "((MHREmployee) engineContext.get(\"" + string + "\"))";
        } else if (string.equals("_HR_Employee_Contract")) {
            object = "((MHRContract) engineContext.get(\"" + string + "\"))";
        }
        return object;
    }

    private void writeToFile(StringBuffer stringBuffer, String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");
            for (int i = 0; i < stringBuffer.length(); ++i) {
                char c = stringBuffer.charAt(i);
                if (c == ';' || c == '}') {
                    ((Writer)outputStreamWriter).write(c);
                    continue;
                }
                if (c == '{') {
                    ((Writer)outputStreamWriter).write(c);
                    continue;
                }
                ((Writer)outputStreamWriter).write(c);
            }
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            float f = file.length();
            log.info(file.getAbsolutePath() + " - " + (f /= 1024.0f) + " kB");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, string, exception);
            throw new RuntimeException(exception);
        }
    }
}

