/*
 * Decompiled with CFR 0.152.
 */
package org.spin.hr.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.model.MRule;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.spin.hr.util.RuleInterface;
import org.spin.util.RuleEngineUtil;

public class PayrollEngineHandler {
    private static PayrollEngineHandler ruleEngineHandler = null;
    private Map<Integer, RuleInterface> ruleEngineMap = new HashMap<Integer, RuleInterface>();
    private static final CLogger logger = CLogger.getCLogger(PayrollEngineHandler.class);

    public static PayrollEngineHandler getInstance() {
        if (ruleEngineHandler == null) {
            ruleEngineHandler = new PayrollEngineHandler();
        }
        return ruleEngineHandler;
    }

    public RuleInterface getRuleEngine(MRule mRule) throws Exception {
        if (mRule == null) {
            return null;
        }
        if (!this.ruleEngineMap.containsKey(mRule.getAD_Rule_ID())) {
            this.loadClass(mRule);
            return this.ruleEngineMap.get(mRule.getAD_Rule_ID());
        }
        return this.ruleEngineMap.get(mRule.getAD_Rule_ID());
    }

    private Class<?> getHandlerClass(MRule mRule) {
        String string = RuleEngineUtil.getCompleteClassName(mRule);
        if (Util.isEmpty(string)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (RuleInterface.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (clazz2 != RuleInterface.class) continue;
                logger.log(Level.SEVERE, "Error loading class, Use: " + string);
                return clazz;
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Loading class Error" + exception.getMessage());
        }
        logger.log(Level.SEVERE, "Not found Class: " + string);
        return null;
    }

    private void loadClass(MRule mRule) throws Exception {
        Class<?> clazz = this.getHandlerClass(mRule);
        RuleInterface ruleInterface = null;
        if (clazz == null) {
            logger.log(Level.SEVERE, "Class not found, Using Standard Class");
            ruleInterface = null;
            throw new ClassNotFoundException("Class for rule engine not found");
        }
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        ruleInterface = (RuleInterface)constructor.newInstance(new Object[0]);
        this.ruleEngineMap.put(mRule.getAD_Rule_ID(), ruleInterface);
    }
}

