/*
 * Decompiled with CFR 0.152.
 */
package org.spin.freight.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.distribution.model.MDDFreightLine;
import org.spin.freight.process.GenerateAPInvoiceFromFreightOrderAbstract;

public class GenerateAPInvoiceFromFreightOrder
extends GenerateAPInvoiceFromFreightOrderAbstract {
    private MInvoice invoice;
    private AtomicInteger created = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.getInstancesForSelection(this.get_TrxName()).stream().forEach(mDDFreightLine -> this.createInvoiceLine((MDDFreightLine)mDDFreightLine));
        return "@Created@ " + this.created.get();
    }

    private void createInvoiceLine(MDDFreightLine mDDFreightLine) {
        MFreightCategory mFreightCategory = MFreightCategory.getById(this.getCtx(), mDDFreightLine.getM_FreightCategory_ID(), this.get_TrxName());
        BigDecimal bigDecimal = Env.ZERO;
        bigDecimal = Util.isEmpty(mFreightCategory.getFreightCalculationType()) || mFreightCategory.getFreightCalculationType().equals("W") ? mDDFreightLine.getWeight() : mDDFreightLine.getVolume();
        MInvoiceLine mInvoiceLine = new MInvoiceLine(this.invoice);
        mInvoiceLine.setDD_FreightLine_ID(mDDFreightLine.getDD_FreightLine_ID());
        if (mDDFreightLine.getM_Product_ID() != 0) {
            mInvoiceLine.setM_Product_ID(mDDFreightLine.getM_Product_ID());
            mInvoiceLine.setQty(bigDecimal);
            mInvoiceLine.setPrice(mDDFreightLine.getFreightAmt().divide(bigDecimal, MathContext.DECIMAL128));
            mInvoiceLine.setTax();
        } else if (mDDFreightLine.getC_Charge_ID() != 0) {
            mInvoiceLine.setC_Charge_ID(mDDFreightLine.getC_Charge_ID());
            mInvoiceLine.setQty(Env.ONE);
            mInvoiceLine.setPrice(mDDFreightLine.getFreightAmt());
            mInvoiceLine.setTax();
        } else {
            mInvoiceLine.setQty(Env.ONE);
            mInvoiceLine.setPrice(mDDFreightLine.getFreightAmt());
        }
        mInvoiceLine.addDescription(Msg.getMsg(this.getCtx(), "FreightLineDetailForAP", new Object[]{mDDFreightLine.getParent().getDocumentNo(), mDDFreightLine.getLine(), mDDFreightLine.getWeight(), mDDFreightLine.getVolume(), mDDFreightLine.getFreightRate(), mDDFreightLine.getFreightAmt()}));
        mInvoiceLine.saveEx();
    }
}

