/*
 * Decompiled with CFR 0.152.
 */
package org.spin.freight.process;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_AD_ClientInfo;
import org.adempiere.core.domains.models.X_M_Freight;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MFreight;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MPackage;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.distribution.model.MDDFreight;
import org.eevolution.distribution.model.MDDFreightLine;
import org.spin.freight.process.CreateFreightOrderFromPackageAbstract;

public class CreateFreightOrderFromPackage
extends CreateFreightOrderFromPackageAbstract {
    @Override
    protected void prepare() {
        super.prepare();
        if (this.getFreightAmt() == null) {
            this.setFreightAmt(Env.ZERO);
        }
    }

    @Override
    protected String doIt() throws Exception {
        MDDFreight mDDFreight = new MDDFreight(this.getCtx(), 0, this.get_TrxName());
        if (this.getDriverId() > 0) {
            mDDFreight.setDD_Driver_ID(this.getDriverId());
        }
        if (this.getVehicleId() > 0) {
            mDDFreight.setDD_Vehicle_ID(this.getVehicleId());
        }
        mDDFreight.setDateDoc(this.getDateDoc());
        mDDFreight.setM_Shipper_ID(this.getShipperId());
        if (this.getDateOrdered() == null) {
            mDDFreight.setDateOrdered(this.getDateDoc());
        } else {
            mDDFreight.setDateOrdered(this.getDateOrdered());
        }
        if (this.getDocTypeId() > 0) {
            mDDFreight.setC_DocType_ID(this.getDocTypeId());
        } else {
            mDDFreight.setC_DocType_ID(MDocType.getDocType("FRO", Env.getAD_Org_ID(this.getCtx())));
        }
        mDDFreight.setDocAction(this.getDocAction());
        if (this.isOverwriteFreightCostRule()) {
            mDDFreight.setFreightCostRule(this.getFreightCostRule());
        }
        mDDFreight.setFreightAmt(this.getFreightAmt());
        mDDFreight.saveEx();
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicInteger atomicInteger2 = new AtomicInteger();
        AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(Env.ZERO);
        this.getSelectionKeys().forEach(n -> {
            PO pO;
            MPackage mPackage = new MPackage(this.getCtx(), (int)n, this.get_TrxName());
            MDDFreightLine mDDFreightLine = new MDDFreightLine(this.getCtx(), 0, this.get_TrxName());
            mDDFreightLine.setDD_Freight_ID(mDDFreight.getDD_Freight_ID());
            mDDFreightLine.setLine(atomicInteger.addAndGet(10));
            mDDFreightLine.setWeight(mPackage.getWeight());
            mDDFreightLine.setVolume(mPackage.getVolume());
            mDDFreightLine.setFreightAmt(mPackage.getFreightAmt());
            mDDFreightLine.setFreightRate(mPackage.getFreightRate());
            if (mPackage.getM_Freight_ID() > 0) {
                mDDFreightLine.setM_Freight_ID(mPackage.getM_Freight_ID());
            }
            if (this.isOverwriteFreightCostRule()) {
                mDDFreightLine.setM_FreightCategory_ID(this.getFreightCategoryId());
                pO = new MFreight(this.getCtx(), this.getFreightCategoryId(), this.get_TrxName());
                mDDFreightLine.setM_FreightCategory_ID(((X_M_Freight)pO).getM_FreightCategory_ID());
            } else {
                mDDFreightLine.setM_FreightCategory_ID(mPackage.getM_FreightCategory_ID());
            }
            pO = MClientInfo.get(this.getCtx());
            if (((X_AD_ClientInfo)pO).getC_UOM_Weight_ID() <= 0) {
                throw new AdempiereException("@C_UOM_Weight_ID@ @NotFound@ @SeeClientInfoConfig@");
            }
            if (((X_AD_ClientInfo)pO).getC_UOM_Volume_ID() <= 0) {
                throw new AdempiereException("@C_UOM_Volume_ID@ @NotFound@ @SeeClientInfoConfig@");
            }
            mDDFreightLine.setWeight_UOM_ID(((X_AD_ClientInfo)pO).getC_UOM_Weight_ID());
            mDDFreightLine.setVolume_UOM_ID(((X_AD_ClientInfo)pO).getC_UOM_Volume_ID());
            mDDFreightLine.setM_Package_ID(mPackage.getM_Package_ID());
            if (mPackage.getC_BPartner_ID() > 0) {
                mDDFreightLine.setC_BPartner_ID(mPackage.getC_BPartner_ID());
            }
            mDDFreightLine.setIsInvoiced(mPackage.isInvoiced());
            if (mPackage.getM_FreightCategory_ID() <= 0) {
                throw new AdempiereException("@M_FreightCategory_ID@ @NotFound@");
            }
            MFreightCategory mFreightCategory = MFreightCategory.getById(this.getCtx(), mPackage.getM_FreightCategory_ID(), this.get_TrxName());
            if (mPackage.isInvoiced() && mFreightCategory.getM_Product_ID() <= 0 && mFreightCategory.getC_Charge_ID() <= 0) {
                throw new AdempiereException(mFreightCategory.getName() + ": @IsInvoiced@ @M_Product_ID@ / @C_Charge_ID@ @NotFound@");
            }
            if (mFreightCategory.getM_Product_ID() > 0) {
                mDDFreightLine.setM_Product_ID(mFreightCategory.getM_Product_ID());
            } else {
                mDDFreightLine.setC_Charge_ID(mFreightCategory.getC_Charge_ID());
            }
            mDDFreightLine.saveEx();
            atomicInteger2.addAndGet(1);
            atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mPackage.getFreightAmt()));
            this.addLog(mDDFreight.getDD_Freight_ID(), mDDFreight.getDateDoc(), null, "@Created@");
        });
        if (!this.isOverwriteFreightCostRule()) {
            mDDFreight.setFreightAmt(atomicReference.get());
        }
        mDDFreight.processIt(this.getDocAction());
        mDDFreight.saveEx();
        this.openResult("DD_Freight");
        return "@DD_Freight_ID@ @Created@: " + mDDFreight.getDocumentInfo() + " @Lines@: " + atomicInteger2.get();
    }
}

