/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.openup.core.utils.Evaluation2FunctionalInterface;
import org.openup.core.utils.GenericActionFunctionalInterface;

public class Utils {
    private static CLogger log = CLogger.getCLogger(Utils.class);

    @Deprecated
    public static <Val> Val when(Val o1, Val o2, Evaluation2FunctionalInterface<Val> condition) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition mandatory");
        }
        return condition.evaluate(o1, o2) ? o1 : o2;
    }

    public static <Val> Val when(Evaluation2FunctionalInterface<Val> condition, Val o1, Val o2) {
        if (condition == null) {
            throw new IllegalArgumentException("Condition mandatory");
        }
        return condition.evaluate(o1, o2) ? o1 : o2;
    }

    public static <Val> Val whenNull(Val value, Val elseValue) {
        return Optional.ofNullable(value).orElse(elseValue);
    }

    public static <Val> void setWhenNotNull(Val val, GenericActionFunctionalInterface<Val> theFunction) {
        Utils.doWhenNotNull(val, theFunction, false);
    }

    public static <Val> void setWhenNotNullNoEx(Val val, GenericActionFunctionalInterface<Val> theFunction) {
        Utils.doWhenNotNull(val, theFunction, true);
    }

    public static <Val> void doWhenNotNull(Val val, GenericActionFunctionalInterface<Val> theFunction, boolean catchException) {
        if (val != null && theFunction != null) {
            if (catchException) {
                try {
                    theFunction.doTheWork(val);
                }
                catch (Exception e) {
                    log.fine("@Error@ " + e.getMessage());
                }
            } else {
                theFunction.doTheWork(val);
            }
        }
    }

    public static SimpleDateFormat getSQLSDF() {
        return new SimpleDateFormat("yyyy/MM/dd");
    }

    public static Timestamp getTimestampPrev3112(Timestamp tstm) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(tstm.getTime());
            cal.add(1, -1);
            String prevYear = new SimpleDateFormat("yyyy").format(new Timestamp(cal.getTimeInMillis()));
            return new Timestamp(new SimpleDateFormat("ddMMyyyy").parse("3112" + prevYear).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <Val> Val firstNotNull(Val ... values) {
        return Arrays.stream(values).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static int firstNot0(int ... values) {
        return Arrays.stream(values).filter(value -> value != 0).findFirst().orElse(0);
    }

    public static int getAcctCurrency(Properties ctx) {
        int acctCurrency_id;
        try {
            acctCurrency_id = new MAcctSchema(ctx, Env.getContextAsInt(ctx, "$C_AcctSchema_ID"), null).getC_Currency_ID();
        }
        catch (Exception e) {
            acctCurrency_id = 0;
        }
        return acctCurrency_id;
    }

    public static String getCurrentTimestampFormatted(String pattern) {
        return new SimpleDateFormat(pattern).format(new Timestamp(System.currentTimeMillis()));
    }

    public static List<MColumn> getMColumns(Properties ctx, String tableName, String trxName) {
        int tableId = MTable.getTable_ID(tableName);
        return new Query(ctx, "AD_Column", "AD_Table_ID=?", trxName).setParameters(tableId).list();
    }
}

