/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.sql.ResultSet;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.services.CPOS;
import org.adempiere.pos.util.POSTicketHandler;
import org.compiere.model.MInvoice;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.eevolution.services.dsl.ProcessBuilder;

public class POSPrintInvoice
extends POSTicketHandler {
    public POSPrintInvoice(CPOS pos) {
        super(pos);
    }

    @Override
    public void printTicket() {
        try {
            ProcessInfo info = new ProcessInfo(null, 0);
            info.setTransactionName(this.getPOS().get_TrxName());
            if (!this.getPOS().isInvoiced()) {
                ReportCtl.startDocumentPrint(0, null, this.getPOS().getC_Order_ID(), null, this.getPOS().getWindowNo(), false, null, info);
            } else {
                int processID = this.getPrintProcessID();
                if (processID <= 0) {
                    throw new AdempiereException("No se encontro ID de proceso de impresion");
                }
                for (MInvoice invoice : this.getPOS().getOrder().getInvoices()) {
                    log.warning("Hay factura!!");
                    ProcessBuilder.create(invoice.getCtx()).process(processID).withParameter("AD_Table_ID", I_C_Invoice.Table_ID).withParameter("Record_ID", invoice.get_ID()).withoutTransactionClose().execute(this.getPOS().get_TrxName());
                }
            }
        }
        catch (Exception e) {
            throw new AdempierePOSException("PrintTicket - Error Printing Ticket");
        }
    }

    private int getPrintProcessID() {
        String sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        int value = 0;
        try {
            sql = "select ad_process_id from ad_process where lower(value)='pmigrateprintcfe'";
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getInt(1);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return value;
    }

    @Override
    public void openDrawer() {
    }

    @Override
    public void showMessage(String message) {
    }
}

