/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.compiere.model.MBPartner;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.openup.core.utils.LUYPaymentExportList;

public class OnTop_PaymentExport
extends LUYPaymentExportList {
    private static CLogger s_log = CLogger.getCLogger(OnTop_PaymentExport.class);
    private int paymentQty = 0;
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final String CRLF = "\r\n";

    @Override
    public int exportToFile(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        return this.export(checks, file, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int export(List<MPaySelectionCheck> checks, File file, StringBuffer error) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        try {
            s_log.fine("Delete file if exist");
            this.openFileWriter(file, checks);
            MPaySelection paySelection = (MPaySelection)checks.get(0).getC_PaySelection();
            s_log.fine("Iterate Payments");
            checks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
                String mail1 = "";
                String mail2 = "";
                MBPartner bpartner = MBPartner.get(paySelectionCheck.getCtx(), paySelectionCheck.getC_BPartner_ID());
                List<MUser> users = Arrays.asList(MUser.getOfBPartner(paySelectionCheck.getCtx(), bpartner.getC_BPartner_ID(), paySelectionCheck.get_TrxName()));
                if (!users.isEmpty()) {
                    int userID = ((MUser)users.stream().findFirst().get()).getAD_User_ID();
                    MUser user = new MUser(paySelectionCheck.getCtx(), userID, paySelectionCheck.get_TrxName());
                    if (user.getEMail() != null) {
                        mail1 = user.getEMail();
                    }
                    if (user.getFax() != null) {
                        mail2 = user.getFax();
                    }
                }
                String bpname = bpartner.getName();
                String currency = paySelection.getC_Currency().getISO_Code();
                String amount = String.format("%.2f", paySelectionCheck.getPayAmt().abs()).replace(",", "").replace(".", ",");
                String finalAmount = currency + " " + amount;
                StringBuffer line = new StringBuffer();
                line.append(CRLF).append(mail1).append(";").append(mail2).append(";").append(bpname).append(";").append(finalAmount);
                this.writeLine(line.toString());
                this.addPaymentToCounter();
            });
        }
        catch (Exception e) {
            this.addError(e.toString());
        }
        finally {
            this.closeFileWriter();
            error.append(this.getError());
            if (error.length() > 0) {
                this.setExportedPayments(-1);
            }
        }
        return this.getExportedPayments();
    }

    private int getPaymentQty() {
        return this.paymentQty;
    }

    private void addPaymentToCounter() {
        ++this.paymentQty;
    }
}

