/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.core.domains.models.X_C_BP_BankAccount;
import org.adempiere.core.domains.models.X_C_BPartner;
import org.adempiere.core.domains.models.X_I_BankStatement;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MColumn;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.openup.core.model.MBankStatementConfig;
import org.spin.util.impexp.BankTransactionAbstract;

public class ITAU_BankTransaction
extends BankTransactionAbstract {
    public static final String LINE_TRANSACTION_Date = "TrxDate";
    public static final String LINE_TRANSACTION_Type = "Type";
    public static final String LINE_TRANSACTION_ReferenceNo = "ReferenceNo";
    public static final String LINE_TRANSACTION_Description = "Description";
    public static final String LINE_TRANSACTION_Amount = "Amount";
    public static final String LINE_TRANSACTION_BPartnerValue = "BPartnerValue";
    public static final String LINE_TRANSACTION_BPartnerID = "BPartnerID";
    private static final char START_CHAR_VALUE = ';';
    private boolean isTransaction = false;
    public static final String DEBT = "DR";
    public static final String CREDIT = "CR";

    @Override
    public void parseLine(String line, MBankAccount bankAccount) throws Exception {
        if (Util.isEmpty(line)) {
            return;
        }
        if (Util.isEmpty(line = this.processValue(line))) {
            return;
        }
        line = line.replaceAll("\"", "");
        int startIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < 3; ++i) {
            startIndex = line.indexOf(59);
            line = line.substring(startIndex + 1);
        }
        this.addValue(LINE_TRANSACTION_Date, this.getDate("dd.MM.yy", this.subString(line, 0, 8)));
        Timestamp date = this.getDate("dd.MM.yy", this.subString(line, 0, 8));
        line = line.substring(10);
        int initPosition = 1;
        startIndex = line.indexOf(59);
        line = line.substring(startIndex + 1);
        endIndex = line.indexOf(59) + initPosition;
        String value = this.subString(line, 0, endIndex);
        if (!Util.isEmpty(value)) {
            this.addValue(LINE_TRANSACTION_Description, value.replaceAll(";", "").trim());
        }
        if (!Util.isEmpty(value = this.subString(line = line.substring(endIndex + 2), startIndex = 0, endIndex = line.indexOf(59) + initPosition))) {
            this.addValue(LINE_TRANSACTION_ReferenceNo, value.replaceAll(";", "").trim());
            for (MBankStatementConfig confLine : MBankStatementConfig.getLines(Env.getCtx(), bankAccount.get_ID())) {
                MColumn column;
                if (!value.contains(confLine.getDescription())) continue;
                int qty = confLine.getQtyCount();
                int length = confLine.getDescription().length();
                int intIndex = value.indexOf(confLine.getDescription());
                int indexFrom = 0;
                int indexTo = 0;
                try {
                    if (qty < 0) {
                        indexFrom = intIndex + qty;
                        indexTo = intIndex;
                        value = value.substring(indexFrom, indexTo);
                    } else if (qty > 0) {
                        indexFrom = intIndex + length;
                        indexTo = indexFrom + qty;
                        value = value.substring(indexFrom, indexTo);
                    }
                }
                catch (Exception e) {
                    System.out.println("ERROR:" + value);
                    value = null;
                }
                if (value == null) break;
                MBPartner partner = null;
                if (confLine.getAD_Table().getAD_Table_ID() == X_C_BPartner.Table_ID) {
                    partner = ITAU_BankTransaction.getPartner(Env.getCtx(), value, confLine.getAD_Column().getColumnName());
                } else if (confLine.getAD_Table().getAD_Table_ID() == X_C_BP_BankAccount.Table_ID) {
                    MBPBankAccount bpAccount = ITAU_BankTransaction.getPartnerAccount(Env.getCtx(), value, confLine.getAD_Column().getColumnName());
                    if (confLine.getAD_Table_ID_2() == X_C_BPartner.Table_ID && bpAccount != null && bpAccount.get_ID() > 0) {
                        partner = (MBPartner)bpAccount.getC_BPartner();
                    }
                }
                if (partner == null || partner.get_ID() <= 0 || confLine.getAD_Table_ID_3() != X_I_BankStatement.Table_ID || !(column = new MColumn(Env.getCtx(), confLine.getAD_Column_ID_3(), null)).getColumnName().equalsIgnoreCase(LINE_TRANSACTION_BPartnerValue)) break;
                this.addValue(LINE_TRANSACTION_BPartnerValue, partner.getValue());
                this.addValue(LINE_TRANSACTION_BPartnerID, partner.get_ID());
                break;
            }
        }
        line = line.substring(endIndex);
        line = line.replaceAll("\\+", "");
        startIndex = 0;
        endIndex = line.indexOf(59) + initPosition;
        BigDecimal amount = this.getNumber(',', "#,###,###,###,###,###.##", this.subString(line, startIndex, endIndex));
        this.addValue(LINE_TRANSACTION_Amount, amount);
        if (amount != null && amount.compareTo(Env.ZERO) < 0) {
            this.addValue(LINE_TRANSACTION_Type, DEBT);
        } else if (amount != null) {
            this.addValue(LINE_TRANSACTION_Type, CREDIT);
        }
        this.isTransaction = true;
    }

    @Override
    public Timestamp getTrxDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public BigDecimal getAmount() {
        return this.getNumber(LINE_TRANSACTION_Amount);
    }

    @Override
    public String getPayeeAccountNo() {
        return null;
    }

    @Override
    public String getCheckNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    @Override
    protected String processValue(String value) {
        return value;
    }

    @Override
    public boolean isEndTransactionLine(String line) {
        return true;
    }

    @Override
    public boolean isCompleteData() {
        return this.isTransaction;
    }

    @Override
    public String getCurrency() {
        return null;
    }

    @Override
    public Timestamp getValueDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public Timestamp getStatementDate() {
        return this.getDate(LINE_TRANSACTION_Date);
    }

    @Override
    public String getReferenceNo() {
        return this.getString(LINE_TRANSACTION_ReferenceNo);
    }

    @Override
    public String getPayeeName() {
        return null;
    }

    @Override
    public String getPayeeDescription() {
        return this.getString(LINE_TRANSACTION_Description);
    }

    @Override
    public String getBPartnerValue() {
        return this.getString(LINE_TRANSACTION_BPartnerValue);
    }

    @Override
    public int getBPartnerID() {
        return this.getInt(LINE_TRANSACTION_BPartnerID);
    }

    @Override
    public String getMemo() {
        return null;
    }

    @Override
    public String getTrxType() {
        return null;
    }

    @Override
    public String getTrxCode() {
        return null;
    }
}

