/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MProjectProgressLog;
import org.openup.core.process.UpdateProjectProgressLogAbstract;

public class UpdateProjectProgressLog
extends UpdateProjectProgressLogAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MProject mProject = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        String query = "SELECT CASE WHEN SUM(ol.lineNetAmt) = 0 THEN 0 ELSE 100 * SUM(qtyDelivered * PriceEntered) / SUM(ol.lineNetAmt) END\nFROM C_Order o\nJOIN C_DocType dt ON o.C_DocTypeTarget_ID=dt.C_DocType_ID\nJOIN C_OrderLine ol ON o.C_Order_ID=ol.C_Order_ID\nWHERE o.IsSOTrx='Y'\nAND o.docStatus IN('CO','CL')\nAND ol.IsBonusProduct='N'\nAND dt.IsSplitDocuments='N'\nAND o.C_CommissionRun_ID IS NULL\nAND o.AD_Org_ID=" + mProject.getAD_Org_ID() + "\nAND o.C_Project_ID=" + mProject.get_ID();
        BigDecimal percentage = Env.ZERO;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(query, this.get_TrxName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                percentage = rs.getBigDecimal(1).setScale(1, RoundingMode.HALF_UP);
            }
        }
        catch (Exception ex) {
            this.log.warning(ex.getMessage());
        }
        MProjectProgressLog mProjectProgressLog = (MProjectProgressLog)new Query(this.getCtx(), "C_ProjectProgressLog", "C_Project_ID=?", this.get_TrxName()).setParameters(mProject.get_ID()).first();
        if (mProjectProgressLog == null || mProjectProgressLog.get_ID() <= 0) {
            mProjectProgressLog = new MProjectProgressLog(this.getCtx(), 0, this.get_TrxName());
            mProjectProgressLog.setC_Project_ID(mProject.get_ID());
            mProjectProgressLog.setAD_Org_ID(mProject.getAD_Org_ID());
        }
        mProjectProgressLog.setProgressPercentWO(percentage);
        mProjectProgressLog.saveEx();
        return "@C_Project_ID@ " + mProject.getValue() + " @Updated@ " + percentage + "%";
    }
}

