/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.core.process.UpdateOrderCurrencyRateAbstract;

public class UpdateOrderCurrencyRate
extends UpdateOrderCurrencyRateAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Query q;
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@Record_ID@ @not.found@");
        }
        if (this.getCurrencyRate().compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("@CurrencyRate@: @positive.number@");
        }
        if (this.getTable_ID() == 259) {
            String whereClause = "C_Order_ID=?";
            q = new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(this.getRecord_ID());
        } else if (this.getTable_ID() == 203) {
            MProject mProject = new MProject(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            String whereClause = "C_Project_ID=? AND C_BPartner_ID=?";
            q = new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(mProject.get_ID(), mProject.getC_BPartner_ID());
        } else {
            throw new AdempiereException("@AD_Table_ID@ " + this.getTable_ID() + " @not.found@");
        }
        List mOrders = q.list();
        int ordersUpdated = 0;
        for (MOrder mOrder : mOrders) {
            MProject mProject = (MProject)mOrder.getC_Project();
            if (mOrder.getC_BPartner_ID() != mProject.getC_BPartner_ID()) continue;
            mOrder.set_ValueOfColumn("C_Currency_ID_To", (Object)this.getCurrencyId());
            mOrder.set_ValueOfColumn("CurrencyRate", (Object)this.getCurrencyRate());
            mOrder.saveEx();
            ++ordersUpdated;
        }
        return "@C_Order_ID@ @Updated@: " + ordersUpdated;
    }
}

