/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.process.UpdateGenericRecordColumnAbstract;

public class UpdateGenericRecordColumn
extends UpdateGenericRecordColumnAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int ad_table_id = ((BigDecimal)this.getTable()).intValue();
        MTable mTable = new MTable(this.getCtx(), ad_table_id, this.get_TrxName());
        String sqlToExec = "UPDATE " + mTable.getTableName() + " ";
        sqlToExec = sqlToExec + "SET " + new MColumn(this.getCtx(), this.getColumnId(), this.get_TrxName()).getColumnName() + "=" + this.getValue() + " ";
        sqlToExec = sqlToExec + "WHERE " + this.getWhereClause();
        this.log.warning("SQL TO EXECUTE: " + sqlToExec);
        String resultMsg = sqlToExec;
        try {
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM " + mTable.getTableName() + " WHERE " + this.getWhereClause());
            if (cant > 1) {
                throw new AdempiereException("No se permiten actualizar mas de un registro por vez ");
            }
            resultMsg = resultMsg + " | " + DB.executeUpdate(sqlToExec, false, this.get_TrxName());
        }
        catch (Exception ex) {
            resultMsg = resultMsg + " | " + ex.getMessage();
            Exception cExc = (Exception)Env.getCtx().get("org.compiere.util.CLogger.lastException");
            if (cExc != null) {
                resultMsg = resultMsg + " | " + cExc.getMessage();
            }
            throw new AdempiereException(resultMsg, ex);
        }
        return resultMsg;
    }
}

