/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUnbilled;
import org.openup.core.model.X_T_Unbilled;

public class Unbilled
extends SvrProcess {
    private Timestamp p_StatementDate = null;
    private int p_C_AcctSchema_ID = 0;
    private boolean p_DateAcct = false;
    private boolean p_IsSOTrx = false;
    private boolean p_IsDirectInvoice = false;
    private String p_DropShipType = "";
    private int p_C_Currency_ID = 0;
    private int as_C_Currency_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_C_ProjectCategory_ID = 0;
    private int p_C_Project_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private String p_ReportType = "";
    private static final String TABLA_MOLDE = "T_Unbilled";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ProjectCategory_ID")) {
                this.p_C_ProjectCategory_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("IsSOTrx")) {
                this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsDropShip")) {
                this.p_DropShipType = para[i].getParameter().toString();
                continue;
            }
            if (name.equals("IsDirectInvoice")) {
                this.p_IsDirectInvoice = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("ReportType")) {
                this.p_ReportType = para[i].getParameter().toString();
                continue;
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_ConversionType_ID")) {
                this.p_C_ConversionType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteOldData();
        Object sql = "";
        String where = " o.ad_client_id = " + this.getAD_Client_ID() + " AND io.movementdate <= '" + this.p_StatementDate + "'";
        String where2 = " v.ad_client_id = " + this.getAD_Client_ID();
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        this.as_C_Currency_ID = as.getC_Currency_ID();
        if (this.p_AD_Org_ID > 0) {
            where = where + " AND o.ad_org_id = " + this.p_AD_Org_ID;
            where2 = where2 + " AND v.ad_org_id = " + this.p_AD_Org_ID;
        }
        if (this.p_C_Currency_ID > 0) {
            where = where + " AND o.c_currency_id = " + this.p_C_Currency_ID;
            where2 = where2 + " AND i.c_currency_id = " + this.p_C_Currency_ID;
        }
        if (this.p_C_BPartner_ID > 0) {
            where = where + " AND o.c_bpartner_id = " + this.p_C_BPartner_ID;
            where2 = where2 + " AND i.c_bpartner_id = " + this.p_C_BPartner_ID;
        }
        if (this.p_C_BP_Group_ID > 0) {
            where = where + " AND bp.c_bp_group_id = " + this.p_C_BP_Group_ID;
            where2 = where2 + " AND bp.c_bp_group_id = " + this.p_C_BP_Group_ID;
        }
        if (this.p_IsSOTrx) {
            if (this.p_ReportType.equalsIgnoreCase("G") || this.p_ReportType.equalsIgnoreCase("GM")) {
                where = where + " AND o.issotrx = 'Y' AND o.c_doctypetarget_id IN (1000098,1000122,1000118,1000128,1000115,1000146,1000148,1000163) AND o.docstatus IN ('CO','CL') AND io.docstatus = 'CO'";
                if (this.p_C_Project_ID > 0) {
                    where = where + " AND p.c_project_id = " + this.p_C_Project_ID;
                }
                if (this.p_C_ProjectCategory_ID > 0) {
                    where = where + " AND p.c_projectcategory_id = " + this.p_C_ProjectCategory_ID;
                }
                if (this.p_DropShipType.equalsIgnoreCase("Y")) {
                    where = where + " AND o.isdropship = 'Y'";
                } else if (this.p_DropShipType.equalsIgnoreCase("N")) {
                    where = where + " AND o.isdropship = 'N'";
                }
                where = this.p_IsDirectInvoice ? where + " AND o.isdirectinvoice = 'Y'" : where + " AND o.isdirectinvoice = 'N'";
            } else if (this.p_ReportType.equalsIgnoreCase("V")) {
                where = where + " AND o.issotrx = 'Y' AND o.c_doctypetarget_id IN (1000098,1000122,1000118,1000128) AND o.docstatus IN ('CO','CL')";
                if (this.p_C_ProjectCategory_ID > 0) {
                    where = where + " AND p.c_projectcategory_id = " + this.p_C_ProjectCategory_ID;
                }
                where2 = where2 + " AND i.issotrx = 'Y'";
            }
        } else if (this.p_ReportType.equalsIgnoreCase("E")) {
            where = where + " AND o.issotrx = 'N' AND o.c_doctypetarget_id = 1000016 AND o.docstatus IN ('CO','CL')";
        } else if (this.p_ReportType.equalsIgnoreCase("G") || this.p_ReportType.equalsIgnoreCase("GM")) {
            where = where + " AND o.issotrx = 'N' AND o.docstatus IN ('CO','CL') AND o.c_doctypetarget_id <> 1000161 AND io.docstatus = 'CO'";
            if (this.p_C_Project_ID > 0) {
                where = where + " AND p.c_project_id = " + this.p_C_Project_ID;
            }
            if (this.p_C_ProjectCategory_ID > 0) {
                where = where + " AND p.c_projectcategory_id = " + this.p_C_ProjectCategory_ID;
            }
            if (this.p_DropShipType.equalsIgnoreCase("Y")) {
                where = where + " AND o.isdropship = 'Y'";
            } else if (this.p_DropShipType.equalsIgnoreCase("N")) {
                where = where + " AND o.isdropship = 'N'";
            }
            where = this.p_IsDirectInvoice ? where + " AND o.isdirectinvoice = 'Y'" : where + " AND o.isdirectinvoice = 'N'";
        } else if (this.p_ReportType.equalsIgnoreCase("O")) {
            where = where + " AND o.issotrx = 'N' AND o.c_doctypetarget_id IN (1000123,1000117,1000053) AND o.docstatus IN ('CO','CL') AND iv.docstatus IN ('CO','IP') AND iv.ispaid = 'N'";
            if (this.p_C_ProjectCategory_ID > 0) {
                where = where + " AND p.c_projectcategory_id = " + this.p_C_ProjectCategory_ID;
            }
        } else if (this.p_ReportType.equalsIgnoreCase("V")) {
            where = where + " AND o.issotrx = 'N' AND o.docstatus IN ('CO','CL') AND o.c_doctypetarget_id <> 1000161";
            where2 = where2 + " AND i.issotrx = 'N'";
        }
        if (this.p_ReportType.equalsIgnoreCase("E")) {
            sql = " SELECT o.ad_org_id,    o.ad_client_id,    o.c_bpartner_id,    o.s_contract_id,    o.c_doctypetarget_id,    o.c_order_id,    o.dateordered,    o.totallines AS subtotal_so,    o.dropship_bpartner_id,    o.c_currency_id,    o.issotrx,    io.m_inout_id,    io.movementdate,    io.c_campaign_id,    io.c_activity_id,    round(iol.qtyentered * ol.priceentered, 2) AS total_delivered,    bp.c_bp_group_id,    p.user1_id,    p.c_projectcategory_id,    (select coalesce(sum(ivl.linenetamt),0)    from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id    where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') as amtinvoiced,    (select coalesce(ol.linenetamt,0) - coalesce(sum(ivl.linenetamt),0)    from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id    where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') as openamt   FROM c_order o     INNER JOIN c_orderline ol ON o.c_order_id = ol.c_order_id     INNER JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id     INNER JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id     INNER JOIN m_inout io ON iol.m_inout_id = io.m_inout_id AND (io.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar]))     LEFT JOIN c_project p ON o.c_project_id = p.c_project_id  WHERE " + where + "  AND NOT EXISTS (select ivl.c_invoiceline_id from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id)  GROUP BY io.m_inout_id,o.ad_org_id,o.ad_client_id,o.c_bpartner_id,o.s_contract_id,o.c_doctypetarget_id,o.c_order_id,ol.c_orderline_id,iol.qtyentered,ol.priceentered,bp.c_bp_group_id,p.user1_id,p.c_projectcategory_id ";
        } else if (this.p_ReportType.equalsIgnoreCase("G")) {
            sql = " SELECT *, (x.openamt - x.OpenAmtDelivery) as amount FROM  (SELECT o.ad_org_id,    o.ad_client_id,    o.c_bpartner_id,    p.s_contract_id,    p.c_project_id,    p.user1_id,    p.user4_id,    p.c_projecttype_id,    p.c_projectcategory_id,    o.c_doctypetarget_id,    o.c_order_id,    o.dateordered,    o.totallines AS subtotal_so,    o.dropship_bpartner_id,    o.c_currency_id,    o.issotrx,    pre_so.c_doctypetarget_id AS doctype_pre_so,    pre_so.c_order_id AS preorder_id_so,    pre_so.dateordered AS date_pre_so,    pre_so.totallines AS subtotal_pre_so,    io.m_inout_id,    io.c_doctype_id,    io.movementdate,    io.c_campaign_id,    io.c_activity_id,    round(iol.qtyentered * ol.priceentered, 2) AS total_delivered,    bp.c_bp_group_id,    coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ", io.movementdate, 0, io.ad_client_id, 0),0) as currencyrate,    coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ", '" + this.p_StatementDate + "', 0, io.ad_client_id, 0),0) as rate,      (select coalesce(sum(ivl.linenetamt),0)    from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id    where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') as amtinvoiced,    (select coalesce(ol.linenetamt,0) - coalesce(sum(ivl.linenetamt),0)    from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id    where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') as openamt,    (select coalesce(ol.linenetamt,0) - round(iol.qtyentered * ol.priceentered, 2)) as OpenAmtDelivery    FROM c_order o     INNER JOIN c_project p ON o.c_project_id = p.c_project_id     INNER JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id     INNER JOIN c_orderline ol ON o.c_order_id = ol.c_order_id     INNER JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id     INNER JOIN m_inout io ON iol.m_inout_id = io.m_inout_id AND (io.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar]))     LEFT JOIN c_order pre_so ON o.preorder_id = pre_so.c_order_id AND (pre_so.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar, 'IP'::bpchar]))     LEFT JOIN c_orderline pre_ol ON pre_so.c_order_id = pre_ol.c_order_id  WHERE " + where + "  AND (select coalesce(sum(ivl.linenetamt),0) - ol.linenetamt from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id  where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') < 0  AND (select coalesce(sum(ivl.linenetamt),0) - ol.linenetamt from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id  where iv.docstatus = 'CO' AND ivl.c_orderline_id = pre_ol.c_orderline_id and iv.dateinvoiced <= '" + this.p_StatementDate + "') < 0  GROUP BY io.m_inout_id,p.ad_org_id,p.ad_client_id,p.c_bpartner_id,p.s_contract_id,p.c_project_id,o.c_doctypetarget_id,o.c_order_id,  pre_so.c_doctypetarget_id,pre_so.c_order_id,iol.qtyentered,ol.priceentered,bp.c_bp_group_id,ol.linenetamt,ol.c_orderline_id) as x  where (x.openamt - x.OpenAmtDelivery) > 0";
        } else if (this.p_ReportType.equalsIgnoreCase("O")) {
            sql = " SELECT o.ad_org_id,    o.ad_client_id,    o.c_bpartner_id,    p.s_contract_id,    p.c_project_id,    p.user1_id,    p.user4_id,    p.c_projecttype_id,    p.c_projectcategory_id,    o.c_doctypetarget_id,    o.c_order_id,    o.dateordered,    o.totallines AS subtotal_so,    o.dropship_bpartner_id,    o.c_currency_id,    o.issotrx,    pre_so.c_doctypetarget_id AS doctype_pre_so,    pre_so.c_order_id AS preorder_id_so,    pre_so.dateordered AS date_pre_so,    pre_so.totallines AS subtotal_pre_so,    io.m_inout_id,    io.movementdate,    io.c_campaign_id,    io.c_activity_id,    round(iol.qtyentered * ol.priceentered, 2) AS total_delivered,    bp.c_bp_group_id   FROM c_order o     INNER JOIN c_project p ON o.c_project_id = p.c_project_id     INNER JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id     INNER JOIN c_orderline ol ON o.c_order_id = ol.c_order_id     INNER JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id     INNER JOIN m_inout io ON iol.m_inout_id = io.m_inout_id AND (io.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar]))     INNER JOIN c_invoiceline ivl ON ol.c_orderline_id = ivl.c_orderline_id     INNER JOIN c_invoice iv ON ivl.c_invoice_id = iv.c_invoice_id     LEFT JOIN c_order pre_so ON o.preorder_id = pre_so.c_order_id AND (pre_so.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar, 'IP'::bpchar]))     LEFT JOIN c_orderline pre_ol ON pre_so.c_order_id = pre_ol.c_order_id  WHERE " + where + "  GROUP BY io.m_inout_id,p.ad_org_id,p.ad_client_id,p.c_bpartner_id,p.s_contract_id,p.c_project_id,o.c_doctypetarget_id,o.c_order_id,pre_so.c_doctypetarget_id,pre_so.c_order_id,iol.qtyentered,ol.priceentered,bp.c_bp_group_id ";
        } else if (this.p_ReportType.equalsIgnoreCase("V")) {
            sql = " SELECT o.ad_org_id,o.ad_client_id,o.c_bpartner_id,p.s_contract_id,p.c_project_id,p.user1_id,p.user4_id,p.c_projecttype_id,p.c_projectcategory_id,o.c_doctypetarget_id,o.c_order_id,null as c_invoice_id, o.dateordered,o.totallines AS subtotal_so,o.dropship_bpartner_id,o.c_currency_id,o.issotrx,pre_so.c_doctypetarget_id AS doctype_pre_so,pre_so.c_order_id AS preorder_id_so, pre_so.dateordered AS date_pre_so,pre_so.totallines AS subtotal_pre_so,io.m_inout_id,io.movementdate,io.c_campaign_id,io.c_activity_id,round(iol.qtyentered * ol.priceentered, 2) AS total_delivered,bp.c_bp_group_id, null as isindispute FROM c_order o INNER JOIN c_project p ON o.c_project_id = p.c_project_id INNER JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id INNER JOIN c_orderline ol ON o.c_order_id = ol.c_order_id INNER JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id INNER JOIN m_inout io ON iol.m_inout_id = io.m_inout_id AND (io.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar])) LEFT JOIN c_order pre_so ON o.preorder_id = pre_so.c_order_id AND (pre_so.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar, 'IP'::bpchar])) LEFT JOIN c_orderline pre_ol ON pre_so.c_order_id = pre_ol.c_order_id WHERE " + where + " AND (select coalesce(sum(ivl.linenetamt),0) - ol.linenetamt from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id  where iv.docstatus = 'CO' AND ivl.c_orderline_id = ol.c_orderline_id) < 0  AND (select coalesce(sum(ivl.linenetamt),0) - ol.linenetamt from c_invoiceline ivl join c_invoice iv on ivl.c_invoice_id = iv.c_invoice_id where iv.docstatus = 'CO' AND ivl.c_orderline_id = pre_ol.c_orderline_id) < 0 GROUP BY io.m_inout_id,p.ad_org_id,p.ad_client_id,p.c_bpartner_id,p.s_contract_id,p.c_project_id,o.c_doctypetarget_id,o.c_order_id, pre_so.c_doctypetarget_id,pre_so.c_order_id,iol.qtyentered,ol.priceentered,bp.c_bp_group_id UNION SELECT v.ad_org_id, v.ad_client_id, i.c_bpartner_id, v.s_contract_id, v.c_project_id, v.sello_proyecto, v.user4_id, v.c_projecttype_id, v.c_projectcategory_id, null, v.c_order_id, i.c_invoice_id, null, null, null, i.c_currency_id, i.issotrx, null, null, null, null, null, null, i.c_campaign_id, i.c_activity_id, coalesce((v.amtinvoiced * -1),0) as total_delivered, bp.c_bp_group_id, i.isindispute FROM vuy_r_invnodelivered v INNER JOIN c_invoice i ON v.c_invoice_id = i.c_invoice_id INNER JOIN c_bpartner bp ON i.c_bpartner_id = bp.c_bpartner_id WHERE " + where2;
        } else if (this.p_ReportType.equalsIgnoreCase("GM")) {
            Object rate_fields = "";
            if (this.p_C_ConversionType_ID == 114) {
                rate_fields = " coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ", io.movementdate, 114, io.ad_client_id, 0),0) as currencyrate,\n coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ", '" + this.p_StatementDate + "', 114, io.ad_client_id, 0),0) as rate,\n";
            } else if (this.p_C_ConversionType_ID == 115) {
                rate_fields = " coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ",'" + this.p_StatementDate + "', 115, io.ad_client_id, 0),0) as currencyrate,\n coalesce(currencyrate(o.c_currency_id, " + this.as_C_Currency_ID + ", '" + this.p_StatementDate + "', 115, io.ad_client_id, 0),0) as rate,\n";
            }
            sql = "select * from\n(select o.ad_org_id,\n o.ad_client_id,\n o.c_bpartner_id,\n p.s_contract_id,\n p.c_project_id,\n p.user1_id,\n p.user4_id,\n p.c_projecttype_id,\n p.c_projectcategory_id,\n o.c_doctypetarget_id,\n o.c_order_id,\n o.dateordered,\n o.totallines AS subtotal_so,\n o.dropship_bpartner_id,\n o.c_currency_id,\n o.issotrx,\n pre_so.c_doctypetarget_id AS doctype_pre_so,\n pre_so.c_order_id AS preorder_id_so,\n pre_so.dateordered AS date_pre_so,\n pre_so.totallines AS subtotal_pre_so,\n io.m_inout_id,\n io.c_doctype_id,\n io.movementdate,\n io.c_campaign_id,\n io.c_activity_id,\n bp.c_bp_group_id,\n" + (String)rate_fields + " round(iol.qtyentered * ol.priceentered, 2) * (case when doc.issotrx = 'N' and doc.docbasetype = 'MMS' then -1 ELSE 1 END) AS total_delivered,\n (iol.qtyentered * ol.priceentered * (case when doc.issotrx = 'N' and doc.docbasetype = 'MMS' then -1 ELSE 1 END)) - (coalesce(sum(matchInv.qtymatch),0) * ol.priceentered) as openamt \nFROM m_inout io\nINNER JOIN m_inoutline iol ON io.m_inout_id = iol.m_inout_id\nINNER JOIN c_doctype doc ON io.c_doctype_id = doc.c_doctype_id\nINNER JOIN c_orderline ol ON iol.c_orderline_id = ol.c_orderline_id\nINNER JOIN c_order o ON ol.c_order_id = o.c_order_id\nLEFT JOIN c_project p ON o.c_project_id = p.c_project_id\nINNER JOIN c_bpartner bp ON o.c_bpartner_id = bp.c_bpartner_id\nLEFT JOIN c_order pre_so ON o.preorder_id = pre_so.c_order_id AND (pre_so.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar, 'IP'::bpchar]))\nLEFT JOIN c_orderline pre_ol ON pre_so.c_order_id = pre_ol.c_order_id\nLEFT JOIN (\nSELECT m2.m_inoutline_ID, ABS(SUM(ivl2.qtyinvoiced * ivl2.priceentered)) as amtInvoiced, ABS(SUM(m2.qty)) qtymatch\nFROM M_MatchInv m2\nJOIN M_InOutLine iol2 ON m2.M_InOutLine_ID=iol2.M_InOutLine_ID\nJOIN M_InOut io2 ON iol2.M_InOut_ID=io2.M_InOut_ID\nJOIN C_InvoiceLine ivl2 ON m2.C_InvoiceLine_ID=ivl2.C_InvoiceLine_ID\nJOIN C_Invoice iv2 ON ivl2.C_Invoice_ID=iv2.C_Invoice_ID\nJOIN C_DocType dt2 ON iv2.C_DocTypeTarget_ID=dt2.C_DocType_ID\nWHERE io2.docStatus IN ('CO','CL')\nAND m2.dateAcct <= '" + this.p_StatementDate + "'\nGROUP BY m2.m_inoutline_ID) matchInv ON iol.m_inoutline_ID=matchInv.m_inoutline_ID\nwhere " + where + "\nGROUP BY io.m_inout_id,p.ad_org_id,p.ad_client_id,p.c_bpartner_id,p.s_contract_id,p.c_project_id,o.c_doctypetarget_id,o.c_order_id, pre_so.c_doctypetarget_id,pre_so.c_order_id,iol.qtyentered,ol.priceentered,\nbp.c_bp_group_id,ol.linenetamt,ol.c_orderline_id,iol.m_inoutline_id,matchinv.amtinvoiced,matchinv.qtymatch, doc.issotrx,doc.docbasetype) as x\nwhere x.openamt <> 0";
        }
        this.log.finest((String)sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        PO unbilled = null;
        int counter = 0;
        int rows = 0;
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal openAmt;
                int C_DocType_ID;
                int DaysDue = 0;
                int AD_Client_ID = rs.getInt("AD_Client_ID");
                int AD_Org_ID = rs.getInt("AD_Org_ID");
                int C_BP_Group_ID = rs.getInt("C_BP_Group_ID");
                int C_BPartner_ID = rs.getInt("C_BPartner_ID");
                int C_Currency_ID = rs.getInt("C_Currency_ID");
                int M_InOut_ID = rs.getInt("M_InOut_ID");
                BigDecimal totalDelivered = rs.getBigDecimal("total_delivered");
                Timestamp movementDate = rs.getTimestamp("MovementDate");
                if (movementDate != null) {
                    DaysDue = DB.getSQLValueEx(this.get_TrxName(), "select (EXTRACT(epoch FROM ('" + this.p_StatementDate + "'::timestamp - '" + movementDate + "'::timestamp )))/3600/24", new Object[0]);
                }
                ++rows;
                if (unbilled != null) {
                    unbilled.saveEx();
                    this.log.fine("#" + ++counter + " - " + (MUnbilled)unbilled);
                }
                unbilled = new MUnbilled(this.getCtx(), AD_PInstance_ID, this.p_StatementDate, C_BPartner_ID, C_Currency_ID, M_InOut_ID, C_BP_Group_ID, AD_Org_ID, movementDate, this.get_TrxName());
                ((X_T_Unbilled)unbilled).setIsSOTrx(this.p_IsSOTrx);
                ((X_T_Unbilled)unbilled).setDateAcct(this.p_DateAcct);
                unbilled.set_ValueOfColumn("C_AcctSchema_ID", (Object)this.p_C_AcctSchema_ID);
                ((X_T_Unbilled)unbilled).setDueDate(movementDate);
                ((X_T_Unbilled)unbilled).setDaysDue(DaysDue);
                ((X_T_Unbilled)unbilled).setC_BP_Group_ID(C_BP_Group_ID);
                ((X_T_Unbilled)unbilled).setC_Campaign_ID(rs.getInt("C_Campaign_ID"));
                ((X_T_Unbilled)unbilled).setC_Activity_ID(rs.getInt("C_Activity_ID"));
                ((X_T_Unbilled)unbilled).setC_Order_ID(rs.getInt("C_Order_ID"));
                ((X_T_Unbilled)unbilled).setC_DocTypeTarget_ID(rs.getInt("C_DocTypeTarget_ID"));
                ((X_T_Unbilled)unbilled).setDateOrdered(rs.getTimestamp("DateOrdered"));
                ((X_T_Unbilled)unbilled).setTotalLines(rs.getBigDecimal("subtotal_so"));
                ((X_T_Unbilled)unbilled).setDropShip_BPartner_ID(rs.getInt("DropShip_BPartner_ID"));
                ((X_T_Unbilled)unbilled).setS_Contract_ID(rs.getInt("S_Contract_ID"));
                ((X_T_Unbilled)unbilled).settotal_delivered(totalDelivered);
                ((X_T_Unbilled)unbilled).setMovementDate(movementDate);
                if (this.p_ReportType.equalsIgnoreCase("G")) {
                    C_DocType_ID = rs.getInt("C_DocType_ID");
                    ((X_T_Unbilled)unbilled).setAmtInvoiced(rs.getBigDecimal("AmtInvoiced"));
                    openAmt = rs.getBigDecimal("OpenAmt");
                    BigDecimal openAmtDelivery = rs.getBigDecimal("OpenAmtDelivery");
                    BigDecimal difAmt = openAmt.subtract(openAmtDelivery);
                    if (difAmt.compareTo(Env.ZERO) > 0 && (C_DocType_ID == 1000013 || C_DocType_ID == 1000015)) {
                        difAmt = difAmt.negate();
                        if (totalDelivered.compareTo(Env.ZERO) > 0) {
                            ((X_T_Unbilled)unbilled).settotal_delivered(totalDelivered.negate());
                        }
                    }
                    ((X_T_Unbilled)unbilled).setOpenAmt(difAmt);
                    BigDecimal OpenAmtAcct = MConversionRate.convert(this.getCtx(), difAmt, C_Currency_ID, 142, movementDate, 0, AD_Client_ID, AD_Org_ID);
                    if (OpenAmtAcct != null) {
                        unbilled.set_ValueOfColumn("OpenAmtAcct", (Object)OpenAmtAcct);
                    }
                    if (difAmt != null && difAmt.compareTo(Env.ZERO) != 0) {
                        totalDelivered = difAmt;
                    } else {
                        ((X_T_Unbilled)unbilled).setOpenAmt(totalDelivered);
                    }
                    BigDecimal currencyRate = rs.getBigDecimal("CurrencyRate");
                    ((X_T_Unbilled)unbilled).setCurrencyRate(currencyRate);
                    ((X_T_Unbilled)unbilled).setAmount(totalDelivered.multiply(currencyRate));
                    BigDecimal rate = rs.getBigDecimal("Rate");
                    ((X_T_Unbilled)unbilled).setRate(rate);
                    ((X_T_Unbilled)unbilled).setConvertedAmt(totalDelivered.multiply(rate));
                }
                if (this.p_ReportType.equalsIgnoreCase("GM")) {
                    C_DocType_ID = rs.getInt("C_DocType_ID");
                    openAmt = rs.getBigDecimal("OpenAmt");
                    if (openAmt.compareTo(Env.ZERO) > 0 && (C_DocType_ID == 1000013 || C_DocType_ID == 1000015)) {
                        openAmt = openAmt.negate();
                        if (totalDelivered.compareTo(Env.ZERO) > 0) {
                            ((X_T_Unbilled)unbilled).settotal_delivered(totalDelivered.negate());
                        }
                    }
                    ((X_T_Unbilled)unbilled).setOpenAmt(openAmt);
                    BigDecimal OpenAmtAcct = Env.ZERO;
                    BigDecimal totalDeliveredAcct = Env.ZERO;
                    if (this.p_C_ConversionType_ID == 114) {
                        OpenAmtAcct = MConversionRate.convert(this.getCtx(), openAmt, C_Currency_ID, 142, movementDate, 114, AD_Client_ID, AD_Org_ID);
                        totalDeliveredAcct = MConversionRate.convert(this.getCtx(), totalDelivered, C_Currency_ID, 142, movementDate, 114, AD_Client_ID, AD_Org_ID);
                    } else if (this.p_C_ConversionType_ID == 115) {
                        OpenAmtAcct = MConversionRate.convert(this.getCtx(), openAmt, C_Currency_ID, 142, this.p_StatementDate, 115, AD_Client_ID, AD_Org_ID);
                        totalDeliveredAcct = MConversionRate.convert(this.getCtx(), totalDelivered, C_Currency_ID, 142, this.p_StatementDate, 115, AD_Client_ID, AD_Org_ID);
                    }
                    if (OpenAmtAcct != null) {
                        unbilled.set_ValueOfColumn("OpenAmtAcct", (Object)OpenAmtAcct);
                    }
                    BigDecimal currencyRate = rs.getBigDecimal("CurrencyRate");
                    ((X_T_Unbilled)unbilled).setCurrencyRate(currencyRate);
                    ((X_T_Unbilled)unbilled).setAmount(totalDelivered.multiply(currencyRate));
                    BigDecimal rate = rs.getBigDecimal("Rate");
                    ((X_T_Unbilled)unbilled).setRate(rate);
                    ((X_T_Unbilled)unbilled).setConvertedAmt(totalDelivered.multiply(rate));
                    if (OpenAmtAcct != null && OpenAmtAcct.compareTo(Env.ZERO) != 0) {
                        totalDelivered = OpenAmtAcct;
                    } else {
                        totalDelivered = totalDeliveredAcct;
                        ((X_T_Unbilled)unbilled).setOpenAmt(totalDelivered);
                    }
                }
                if (this.p_ReportType.equalsIgnoreCase("G") || this.p_ReportType.equalsIgnoreCase("O") || this.p_ReportType.equalsIgnoreCase("GM")) {
                    ((X_T_Unbilled)unbilled).setC_Project_ID(rs.getInt("C_Project_ID"));
                    ((X_T_Unbilled)unbilled).setC_ProjectType_ID(rs.getInt("C_ProjectType_ID"));
                    ((X_T_Unbilled)unbilled).setC_ProjectCategory_ID(rs.getInt("C_ProjectCategory_ID"));
                    ((X_T_Unbilled)unbilled).setUser1_ID(rs.getInt("User1_ID"));
                    ((X_T_Unbilled)unbilled).setUser4_ID(rs.getInt("User4_ID"));
                    ((X_T_Unbilled)unbilled).setdoctype_pre_so(rs.getInt("doctype_pre_so"));
                    ((X_T_Unbilled)unbilled).setpreorder_id_so(rs.getInt("preorder_id_so"));
                    ((X_T_Unbilled)unbilled).setdate_pre_so(rs.getTimestamp("date_pre_so"));
                    ((X_T_Unbilled)unbilled).setsubtotal_pre_so(rs.getBigDecimal("subtotal_pre_so"));
                } else if (this.p_ReportType.equalsIgnoreCase("V")) {
                    ((X_T_Unbilled)unbilled).setC_Invoice_ID(rs.getInt("C_Invoice_ID"));
                    ((X_T_Unbilled)unbilled).setIsInDispute(rs.getBoolean("IsInDispute"));
                } else if (this.p_ReportType.equalsIgnoreCase("E")) {
                    ((X_T_Unbilled)unbilled).setUser1_ID(rs.getInt("User1_ID"));
                    ((X_T_Unbilled)unbilled).setC_ProjectCategory_ID(rs.getInt("C_ProjectCategory_ID"));
                    ((X_T_Unbilled)unbilled).setAmtInvoiced(rs.getBigDecimal("AmtInvoiced"));
                    ((X_T_Unbilled)unbilled).setOpenAmt(rs.getBigDecimal("OpenAmt"));
                }
                if (movementDate == null) continue;
                ((MUnbilled)unbilled).add(movementDate, DaysDue, totalDelivered);
            }
            if (unbilled != null) {
                unbilled.saveEx();
                this.log.fine("#" + ++counter + " - " + (MUnbilled)unbilled);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, (String)sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.info("#" + counter + " - rows=" + rows);
        return "";
    }

    private void deleteOldData() throws Exception {
        Object sql = "";
        sql = " DELETE FROM T_Unbilled WHERE createdby = " + this.getAD_User_ID();
        DB.executeUpdateEx((String)sql, null);
    }
}

