/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.TaxNoExemptFoundException;
import org.compiere.model.MActivity;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrg;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.util.Env;
import org.openup.core.process.TimeExpenseGenFromBPAbstract;

public class TimeExpenseGenFromBP
extends TimeExpenseGenFromBPAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        ArrayList<MTimeExpense> mTimeExpenses = new ArrayList<MTimeExpense>();
        MProduct mProduct = new MProduct(this.getCtx(), this.getProductId(), this.get_TrxName());
        BigDecimal priceEntererd = this.getPriceEntered();
        MPriceListVersion mPriceListVersion = new MPriceListVersion(this.getCtx(), this.getPriceListVersionId(), this.get_TrxName());
        MActivity mActivity = new MActivity(this.getCtx(), this.getActivityId(), this.get_TrxName());
        if (mProduct.get_ID() <= 0) {
            throw new AdempiereException("Seleccione Producto");
        }
        if (mPriceListVersion.get_ID() <= 0) {
            throw new AdempiereException("Seleccionar versi\u00f3n de lista de precios");
        }
        if (this.getProductId() <= 0) {
            throw new AdempiereException("Seleccionar Producto");
        }
        if (mActivity.get_ID() <= 0) {
            throw new AdempiereException("Seleccione una actividad");
        }
        if (priceEntererd == null || priceEntererd.compareTo(Env.ZERO) <= 0) {
            MProductPrice[] mProductPrices = mPriceListVersion.getProductPrice(" AND M_Product_ID=" + mProduct.get_ID());
            if (mProductPrices.length == 0) {
                throw new AdempiereException("Producto no est\u00e1 en la versi\u00f3n de lista de precios");
            }
            MProductPrice mProductPrice = mProductPrices[0];
            priceEntererd = mProductPrice.getPriceList();
            if (priceEntererd == null || priceEntererd.compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("Precio no definido en la versi\u00f3n de lista de precios");
            }
        }
        for (Integer selectionKey : this.getSelectionKeys()) {
            MBPartner mbPartner = new MBPartner(this.getCtx(), selectionKey, this.get_TrxName());
            MTimeExpense mTimeExpense = new MTimeExpense(this.getCtx(), 0, this.get_TrxName());
            mTimeExpenses.add(mTimeExpense);
            mTimeExpense.setC_BPartner_ID(mbPartner.get_ID());
            mTimeExpense.set_ValueOfColumn("Bill_BPartner_ID", this.getSelection(selectionKey, "C_Bill_BPartner_ID"));
            mTimeExpense.setDateReport(this.getDateDoc());
            mTimeExpense.setM_PriceList_ID(mPriceListVersion.getM_PriceList_ID());
            mTimeExpense.setM_Warehouse_ID(Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID"));
            mTimeExpense.set_ValueOfColumn("S_Contract_ID", this.getSelection(selectionKey, "C_S_Contract_ID"));
            mTimeExpense.set_ValueOfColumn("IsSelfService", (Object)true);
            mTimeExpense.saveEx();
            MTax mTax = null;
            if (mbPartner.isTaxExempt()) {
                mTax = MTax.getTaxExempt(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
                if (mTax == null || mTax.get_ID() <= 0) {
                    throw new TaxNoExemptFoundException(Env.getAD_Org_ID(this.getCtx()));
                }
            } else {
                MOrg org = new MOrg(this.getCtx(), Env.getAD_Org_ID(this.getCtx()), null);
                int bpLink_ID = org.getLinkedC_BPartner_ID(null);
                MBPartner linkPartner = new MBPartner(this.getCtx(), bpLink_ID, null);
                if (linkPartner != null && linkPartner.get_ID() > 0 && linkPartner.isTaxExempt() && ((mTax = MTax.getTaxExempt(this.getCtx(), Env.getAD_Client_ID(this.getCtx()), null)) == null || mTax.get_ID() <= 0)) {
                    throw new TaxNoExemptFoundException(Env.getAD_Org_ID(this.getCtx()));
                }
            }
            if (mTax == null && ((mTax = ((MTaxCategory)mProduct.getC_TaxCategory()).getDefaultTax()) == null || mTax.get_ID() <= 0)) {
                throw new AdempiereException("Sin impuesto por defecto para Categor\u00eda de Impuesto del Producto");
            }
            MTimeExpenseLine mTimeExpenseLine = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
            mTimeExpenseLine.setS_TimeExpense_ID(mTimeExpense.get_ID());
            mTimeExpenseLine.set_ValueOfColumn("Line", (Object)10);
            mTimeExpenseLine.setM_Product_ID(mProduct.get_ID());
            mTimeExpenseLine.setC_Tax_ID(mTax.get_ID());
            mTimeExpenseLine.setQty(Env.ONE);
            mTimeExpenseLine.setExpenseAmt(priceEntererd);
            mTimeExpenseLine.setDateExpense(this.getDateDoc());
            mTimeExpenseLine.setC_Activity_ID(mActivity.get_ID());
            mTimeExpenseLine.saveEx();
        }
        for (MTimeExpense mTimeExpens : mTimeExpenses) {
            mTimeExpens.processIt("CO");
            mTimeExpens.saveEx();
        }
        return "OK";
    }
}

