/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import io.vavr.Tuple2;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_Column;
import org.compiere.model.MTimeExpense;
import org.compiere.model.Query;
import org.openup.core.process.SetImportInvoiceToTE2Abstract;
import org.openup.core.utils.Utils;

public class SetImportInvoiceToTE2
extends SetImportInvoiceToTE2Abstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List teColumns = Utils.getMColumns(this.getCtx(), "S_TimeExpense", this.get_TrxName()).stream().map(X_AD_Column::getColumnName).collect(Collectors.toList());
        List telColumns = Utils.getMColumns(this.getCtx(), "S_TimeExpenseLine", this.get_TrxName()).stream().map(X_AD_Column::getColumnName).collect(Collectors.toList());
        List params = Arrays.stream(this.getParameter()).filter(processInfoParameter -> processInfoParameter.getParameter() != null).map(processInfoParameter -> {
            if (teColumns.contains(processInfoParameter.getParameterName())) {
                return new Tuple2((Object)("te." + processInfoParameter.getParameterName() + "=?"), processInfoParameter.getParameter());
            }
            if (telColumns.contains(processInfoParameter.getParameterName())) {
                return new Tuple2((Object)("tel." + processInfoParameter.getParameterName() + "=?"), processInfoParameter.getParameter());
            }
            return new Tuple2((Object)("prod." + processInfoParameter.getParameterName() + "=?"), processInfoParameter.getParameter());
        }).collect(Collectors.toList());
        Object sqlWhere = "EXISTS (\n\tSELECT te.S_TimeExpense_ID\n\tFROM S_TimeExpense te\n\tJOIN S_TimeExpenseLine tel ON te.S_TimeExpense_ID=tel.S_TimeExpense_ID\n\tJOIN M_Product prod ON tel.M_Product_ID=prod.M_Product_ID\tWHERE te.S_TimeExpense_ID = S_TimeExpense.S_TimeExpense_ID\n\tAND tel.IsInvoiced='N'\tAND ";
        sqlWhere = (String)sqlWhere + params.stream().map(Tuple2::_1).collect(Collectors.joining(" AND "));
        sqlWhere = (String)sqlWhere + ")";
        List<Object> p = params.stream().map(Tuple2::_2).collect(Collectors.toList());
        List timeExpenses = new Query(this.getCtx(), "S_TimeExpense", (String)sqlWhere, this.get_TrxName()).setParameters(p).list();
        for (MTimeExpense timeExpense : timeExpenses) {
            timeExpense.set_ValueOfColumn("UY_InvoiceImport_ID", (Object)this.getRecord_ID());
            timeExpense.saveEx();
        }
        this.addLog("@Updated@: " + timeExpenses.size() + " @S_TimeExpense_ID@");
        return "@Updated@: " + timeExpenses.size() + " @S_TimeExpense_ID@";
    }
}

