/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.core.model.MSContractDiscount;
import org.openup.core.process.ServiceContractGenTimeExpenseAbstract;

public class ServiceContractGenTimeExpense
extends ServiceContractGenTimeExpenseAbstract {
    private MSContract msContract;
    private List<MSContractDiscount> msContractDiscounts;
    private HashMap<Integer, List<PO>> msContractLinesSorted;
    private Timestamp startDate;
    private Timestamp endDate;
    private List<MTimeExpense> mTimeExpenses;
    private int teCount;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.teCount = 0;
        Object whereClause = "";
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.getContractId() > 0 || this.getRecord_ID() > 0) {
            whereClause = (String)whereClause + "S_Contract_ID=?";
            params.add(this.getContractId() > 0 ? this.getContractId() : this.getRecord_ID());
        } else {
            whereClause = "IsActive = 'Y'";
        }
        if (this.getOrgId() > 0) {
            if (!((String)whereClause).isEmpty()) {
                whereClause = (String)whereClause + " AND ";
            }
            whereClause = (String)whereClause + "AD_Org_ID=?";
            params.add(this.getOrgId());
        }
        if (this.getBPGroupId() > 0) {
            if (!((String)whereClause).isEmpty()) {
                whereClause = (String)whereClause + " AND ";
            }
            whereClause = (String)whereClause + "S_Contract_ID IN (SELECT S_Contract_ID FROM S_Contract c JOIN C_BPartner p ON c.Bill_BPartner_ID=p.C_BPartner_ID WHERE c.S_Contract_ID = S_Contract_ID AND p.C_BP_Group_ID = ?)";
            params.add(this.getBPGroupId());
        }
        List msContracts = new Query(this.getCtx(), "S_Contract", (String)whereClause, this.get_TrxName()).setParameters(params).list();
        Iterator iterator = msContracts.iterator();
        while (iterator.hasNext()) {
            MSContract contract;
            this.msContract = contract = (MSContract)iterator.next();
            this.generateByContract();
        }
        return "Informes de Gasto generados: " + this.teCount;
    }

    private void generateByContract() {
        this.startDate = this.msContract.getDateStart();
        if (this.msContract.isIndefinite()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.startDate);
            cal.add(2, 12);
            this.endDate = new Timestamp(cal.getTimeInMillis());
        } else {
            this.endDate = this.msContract.getDateFinishSchedule();
        }
        if (this.getDateTo() != null && this.getDateTo().compareTo(this.endDate) < 0) {
            this.endDate = this.getDateTo();
        }
        this.msContractLinesSorted = new HashMap();
        this.mTimeExpenses = new ArrayList<MTimeExpense>();
        List<PO> sContractLines = new Query(this.getCtx(), "S_ContractLine", "S_Contract_ID=?", this.get_TrxName()).setParameters(this.msContract.get_ID()).list(PO.class);
        for (PO sContractLine : sContractLines) {
            this.log.info(sContractLine.toString());
            if (!sContractLine.get_ValueAsBoolean("IsRecurrent")) continue;
            this.putContractLine(sContractLine);
        }
        this.msContractDiscounts = null;
        if (this.isDiscountLineAmt()) {
            this.msContractDiscounts = new Query(this.getCtx(), "S_ContractDiscount", "S_Contract_ID=?", this.get_TrxName()).setParameters(this.msContract.get_ID()).list();
        }
        this.iterateContractLineByFrequency();
        this.processTimeExpens();
    }

    private void putContractLine(PO contractLine) {
        int frequency = contractLine.get_ValueAsInt("Frequency");
        List contractLineByFrequency = this.msContractLinesSorted.computeIfAbsent(frequency, k -> new ArrayList());
        contractLineByFrequency.add(contractLine);
    }

    private void iterateContractLineByFrequency() {
        this.msContractLinesSorted.forEach((frequency, contractLines) -> this.createNextTimeExpense(this.startDate, (int)frequency, (List<PO>)contractLines));
    }

    private void createNextTimeExpense(Timestamp currentDate, int frequency, List<PO> contractLines) {
        Timestamp nextDate = currentDate;
        while (frequency > 0 && nextDate.compareTo(this.endDate) < 0) {
            this.createTimeExpense(nextDate, contractLines);
            Calendar cal = Calendar.getInstance();
            cal.setTime(nextDate);
            cal.add(2, frequency);
            nextDate = new Timestamp(cal.getTimeInMillis());
        }
    }

    private void createTimeExpense(Timestamp dateTrx, List<PO> contractLines) {
        this.log.info("Instantiating Time Expense " + dateTrx + ", Count of Lines: " + contractLines.size());
        String dateFrom = new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(dateTrx);
        String dateTo = new SimpleDateFormat("yyyy-MM-dd 23:59:59").format(dateTrx);
        String existwhere = "S_Contract_ID=? AND (DateReport >= '" + dateFrom + "' AND DateReport <= '" + dateTo + "') AND DocStatus ='CO' AND IsSelfService='N'";
        boolean alreadyCreated = new Query(this.getCtx(), "S_TimeExpense", existwhere, this.get_TrxName()).setParameters(this.msContract.get_ID()).match();
        if (!alreadyCreated) {
            MTimeExpense mTimeExpense = new MTimeExpense(this.getCtx(), 0, this.get_TrxName());
            this.mTimeExpenses.add(mTimeExpense);
            mTimeExpense.setC_BPartner_ID(this.msContract.getC_BPartner_ID());
            mTimeExpense.set_ValueOfColumn("Bill_BPartner_ID", (Object)this.msContract.getBill_BPartner_ID());
            mTimeExpense.setDateReport(dateTrx);
            mTimeExpense.setM_PriceList_ID(this.msContract.getM_PriceList_ID());
            mTimeExpense.setM_Warehouse_ID(this.msContract.getM_Warehouse_ID());
            mTimeExpense.set_ValueOfColumn("S_Contract_ID", (Object)this.msContract.get_ID());
            mTimeExpense.saveEx();
            int line = 10;
            for (PO contractLine : contractLines) {
                MProduct mProduct = new MProduct(this.getCtx(), contractLine.get_ValueAsInt("M_Product_ID"), this.get_TrxName());
                BigDecimal amt = (BigDecimal)contractLine.get_Value("PriceEntered");
                MTimeExpenseLine mTimeExpenseLine = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
                mTimeExpenseLine.setS_TimeExpense_ID(mTimeExpense.get_ID());
                mTimeExpenseLine.set_ValueOfColumn("Line", (Object)line);
                mTimeExpenseLine.setM_Product_ID(mProduct.get_ID());
                mTimeExpenseLine.setC_Tax_ID(contractLine.get_ValueAsInt("C_Tax_ID"));
                mTimeExpenseLine.setQty((BigDecimal)contractLine.get_Value("QtyEntered"));
                mTimeExpenseLine.setExpenseAmt(amt);
                mTimeExpenseLine.setDateExpense(dateTrx);
                mTimeExpenseLine.setDescription(contractLine.get_ValueAsString("Description"));
                mTimeExpenseLine.setC_Activity_ID(contractLine.get_ValueAsInt("C_Activity_ID"));
                mTimeExpenseLine.set_ValueOfColumn("S_ContractLine_ID", (Object)contractLine.get_ID());
                mTimeExpenseLine.setC_Currency_ID(this.msContract.getC_Currency_ID());
                mTimeExpenseLine.saveEx();
                contractLine.set_ValueOfColumn("IsPrinted", (Object)true);
                contractLine.saveEx();
                line += 10;
                if (!this.isDiscountLineAmt() || this.msContractDiscounts == null) continue;
                for (MSContractDiscount msContractDiscount : this.msContractDiscounts) {
                    if (msContractDiscount.getM_Product_Category_ID() != mProduct.getM_Product_Category_ID()) continue;
                    MProduct discountProduct = (MProduct)msContractDiscount.getM_DiscountSchema().getM_Product();
                    if (discountProduct == null || discountProduct.get_ID() <= 0) {
                        throw new AdempiereException("@M_DiscountSchema@ " + msContractDiscount.getM_DiscountSchema().getName() + " @not.found@ @M_Product_ID@");
                    }
                    BigDecimal discountAmt = amt.multiply(msContractDiscount.getDiscount()).divide(Env.ONEHUNDRED).negate();
                    MTimeExpenseLine mTimeExpenseLineDiscount = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
                    mTimeExpenseLineDiscount.setS_TimeExpense_ID(mTimeExpense.get_ID());
                    mTimeExpenseLineDiscount.set_ValueOfColumn("Line", (Object)line);
                    mTimeExpenseLineDiscount.setM_Product_ID(discountProduct.get_ID());
                    mTimeExpenseLineDiscount.setC_Tax_ID(contractLine.get_ValueAsInt("C_Tax_ID"));
                    mTimeExpenseLineDiscount.setQty(Env.ONE);
                    mTimeExpenseLineDiscount.setExpenseAmt(discountAmt);
                    mTimeExpenseLineDiscount.setDateExpense(dateTrx);
                    mTimeExpenseLineDiscount.setDescription(msContractDiscount.get_ValueAsString("Description"));
                    mTimeExpenseLineDiscount.setC_Activity_ID(contractLine.get_ValueAsInt("C_Activity_ID"));
                    mTimeExpenseLineDiscount.set_ValueOfColumn("S_ContractLine_ID", (Object)contractLine.get_ID());
                    mTimeExpenseLineDiscount.saveEx();
                    line += 10;
                }
            }
            ++this.teCount;
        }
    }

    private void processTimeExpens() {
        for (MTimeExpense mTimeExpens : this.mTimeExpenses) {
            mTimeExpens.processIt("CO");
            mTimeExpens.saveEx();
        }
    }
}

